/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zeitlich geglätte Verkehrsprognosedaten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class OdVerkehrsDatenKurzZeitGeglaettetMq extends AbstractOnlineDatensatz<OdVerkehrsDatenKurzZeitGeglaettetMq.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.PrognoseFlink,
					Aspekte.PrognoseNormal,
					Aspekte.PrognoseTraege,
				};
			}
	
			/**
			 * Prognosewertberechnung mit schwacher"Dämpfung", d.h.
						den Analysewerten"flink" folgend.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PrognoseFlink = new Aspekte("PrognoseFlink", "asp.prognoseFlink");
			
			/**
			 * Prognosewertberechnung mit normaler"Dämpfung", d.h.
						den Analysewerten normal" folgend.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PrognoseNormal = new Aspekte("PrognoseNormal", "asp.prognoseNormal");
			
			/**
			 * Prognosewertberechnung mit schwacher"Dämpfung", d.h.
						den Analysewerten"träge" folgend.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PrognoseTraege = new Aspekte("PrognoseTräge", "asp.prognoseTräge");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qKfzG
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vKfzG
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qLkwG
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vLkwG
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qPkwG
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vPkwG
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
				 _aLkwG
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 _kKfzG
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 _kLkwG
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 _kPkwG
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsVerkehrsStaerkeStunde
				 _qBG
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsFahrzeugDichte
				 _kBG
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsFahrzeugDichte
				()
				;
		
			/**
			Geglättete Fahrzeugmenge Kfz (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von QKfzG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQKfzG() {
				return _qKfzG;
			}
		
			/**
			Geglättete Fahrzeugmenge Kfz (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _qKfzG der neue Wert von QKfzG.
			*/
			public void setQKfzG(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qKfzG) {
				this._qKfzG = _qKfzG;
			}
		
			/**
			Geglättete Geschwindigkeit Kfz (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von VKfzG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVKfzG() {
				return _vKfzG;
			}
		
			/**
			Geglättete Geschwindigkeit Kfz (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _vKfzG der neue Wert von VKfzG.
			*/
			public void setVKfzG(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vKfzG) {
				this._vKfzG = _vKfzG;
			}
		
			/**
			Geglättete Fahrzeugmenge Lkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von QLkwG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQLkwG() {
				return _qLkwG;
			}
		
			/**
			Geglättete Fahrzeugmenge Lkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _qLkwG der neue Wert von QLkwG.
			*/
			public void setQLkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qLkwG) {
				this._qLkwG = _qLkwG;
			}
		
			/**
			Geglättete Geschwindigkeit Lkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von VLkwG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVLkwG() {
				return _vLkwG;
			}
		
			/**
			Geglättete Geschwindigkeit Lkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _vLkwG der neue Wert von VLkwG.
			*/
			public void setVLkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vLkwG) {
				this._vLkwG = _vLkwG;
			}
		
			/**
			Geglättete Fahrzeugmenge Pkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von QPkwG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQPkwG() {
				return _qPkwG;
			}
		
			/**
			Geglättete Fahrzeugmenge Pkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _qPkwG der neue Wert von QPkwG.
			*/
			public void setQPkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qPkwG) {
				this._qPkwG = _qPkwG;
			}
		
			/**
			Geglättete Geschwindigkeit Pkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von VPkwG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVPkwG() {
				return _vPkwG;
			}
		
			/**
			Geglättete Geschwindigkeit Pkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _vPkwG der neue Wert von VPkwG.
			*/
			public void setVPkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vPkwG) {
				this._vPkwG = _vPkwG;
			}
		
			/**
			Geglättete Lkw-Anteil (mit Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von ALkwG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
				 getALkwG() {
				return _aLkwG;
			}
		
			/**
			Geglättete Lkw-Anteil (mit Statusinformationen).
			<p>
			
			</p>
			
			@param _aLkwG der neue Wert von ALkwG.
			*/
			public void setALkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
			 _aLkwG) {
				this._aLkwG = _aLkwG;
			}
		
			/**
			Geglättete Dichte der Kfz (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von KKfzG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 getKKfzG() {
				return _kKfzG;
			}
		
			/**
			Geglättete Dichte der Kfz (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _kKfzG der neue Wert von KKfzG.
			*/
			public void setKKfzG(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
			 _kKfzG) {
				this._kKfzG = _kKfzG;
			}
		
			/**
			Geglättete Dichte der Lkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von KLkwG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 getKLkwG() {
				return _kLkwG;
			}
		
			/**
			Geglättete Dichte der Lkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _kLkwG der neue Wert von KLkwG.
			*/
			public void setKLkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
			 _kLkwG) {
				this._kLkwG = _kLkwG;
			}
		
			/**
			Geglättete Dichte der Pkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von KPkwG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 getKPkwG() {
				return _kPkwG;
			}
		
			/**
			Geglättete Dichte der Pkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _kPkwG der neue Wert von KPkwG.
			*/
			public void setKPkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
			 _kPkwG) {
				this._kPkwG = _kPkwG;
			}
		
			/**
			Geglättete Bemessungsverkehrsstärke (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von QBG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsVerkehrsStaerkeStunde
				 getQBG() {
				return _qBG;
			}
		
			/**
			Geglättete Bemessungsverkehrsstärke (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _qBG der neue Wert von QBG.
			*/
			public void setQBG(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsVerkehrsStaerkeStunde
			 _qBG) {
				this._qBG = _qBG;
			}
		
			/**
			Geglättete Bemessungsverkehrsdichte (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von KBG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsFahrzeugDichte
				 getKBG() {
				return _kBG;
			}
		
			/**
			Geglättete Bemessungsverkehrsdichte (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _kBG der neue Wert von KBG.
			*/
			public void setKBG(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsFahrzeugDichte
			 _kBG) {
				this._kBG = _kBG;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getQKfzG().bean2Atl(datum.getItem("QKfzG"), factory);
					// AttributListenDefinition
						getVKfzG().bean2Atl(datum.getItem("VKfzG"), factory);
					// AttributListenDefinition
						getQLkwG().bean2Atl(datum.getItem("QLkwG"), factory);
					// AttributListenDefinition
						getVLkwG().bean2Atl(datum.getItem("VLkwG"), factory);
					// AttributListenDefinition
						getQPkwG().bean2Atl(datum.getItem("QPkwG"), factory);
					// AttributListenDefinition
						getVPkwG().bean2Atl(datum.getItem("VPkwG"), factory);
					// AttributListenDefinition
						getALkwG().bean2Atl(datum.getItem("ALkwG"), factory);
					// AttributListenDefinition
						getKKfzG().bean2Atl(datum.getItem("KKfzG"), factory);
					// AttributListenDefinition
						getKLkwG().bean2Atl(datum.getItem("KLkwG"), factory);
					// AttributListenDefinition
						getKPkwG().bean2Atl(datum.getItem("KPkwG"), factory);
					// AttributListenDefinition
						getQBG().bean2Atl(datum.getItem("QBG"), factory);
					// AttributListenDefinition
						getKBG().bean2Atl(datum.getItem("KBG"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getQKfzG().atl2Bean(daten.getItem("QKfzG"), factory);
					// AttributListenDefinition
						getVKfzG().atl2Bean(daten.getItem("VKfzG"), factory);
					// AttributListenDefinition
						getQLkwG().atl2Bean(daten.getItem("QLkwG"), factory);
					// AttributListenDefinition
						getVLkwG().atl2Bean(daten.getItem("VLkwG"), factory);
					// AttributListenDefinition
						getQPkwG().atl2Bean(daten.getItem("QPkwG"), factory);
					// AttributListenDefinition
						getVPkwG().atl2Bean(daten.getItem("VPkwG"), factory);
					// AttributListenDefinition
						getALkwG().atl2Bean(daten.getItem("ALkwG"), factory);
					// AttributListenDefinition
						getKKfzG().atl2Bean(daten.getItem("KKfzG"), factory);
					// AttributListenDefinition
						getKLkwG().atl2Bean(daten.getItem("KLkwG"), factory);
					// AttributListenDefinition
						getKPkwG().atl2Bean(daten.getItem("KPkwG"), factory);
					// AttributListenDefinition
						getQBG().atl2Bean(daten.getItem("QBG"), factory);
					// AttributListenDefinition
						getKBG().atl2Bean(daten.getItem("KBG"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._qKfzG = getQKfzG().clone();
							klon._vKfzG = getVKfzG().clone();
							klon._qLkwG = getQLkwG().clone();
							klon._vLkwG = getVLkwG().clone();
							klon._qPkwG = getQPkwG().clone();
							klon._vPkwG = getVPkwG().clone();
							klon._aLkwG = getALkwG().clone();
							klon._kKfzG = getKKfzG().clone();
							klon._kLkwG = getKLkwG().clone();
							klon._kPkwG = getKPkwG().clone();
							klon._qBG = getQBG().clone();
							klon._kBG = getKBG().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.verkehrsDatenKurzZeitGeglättetMq";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdVerkehrsDatenKurzZeitGeglaettetMq(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
