/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Verkehrsdaten (Kurzzeit) mit Intervallwerten
					(normiert auf Stundenwerte).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class OdVerkehrsDatenKurzZeitMq extends AbstractOnlineDatensatz<OdVerkehrsDatenKurzZeitMq.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Analyse,
					Aspekte.Agregation1Minute,
					Aspekte.Agregation5Minuten,
					Aspekte.Agregation15Minuten,
					Aspekte.Agregation30Minuten,
					Aspekte.Agregation60Minuten,
					Aspekte.AnalyseHB,
				};
			}
	
			/**
			 * Analysewerte.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Analyse = new Aspekte("Analyse", "asp.analyse");
			
			/**
			 * Aggregierte Werte: 1-Minuten-Werte.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Agregation1Minute = new Aspekte("Aggregation1Minute", "asp.agregation1Minute");
			
			/**
			 * Aggregierte Werte: 5-Minuten-Werte.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Agregation5Minuten = new Aspekte("Aggregation5Minuten", "asp.agregation5Minuten");
			
			/**
			 * Aggregierte Werte: 15-Minuten-Werte.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Agregation15Minuten = new Aspekte("Aggregation15Minuten", "asp.agregation15Minuten");
			
			/**
			 * Aggregierte Werte: 30-Minuten-Werte.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Agregation30Minuten = new Aspekte("Aggregation30Minuten", "asp.agregation30Minuten");
			
			/**
			 * Aggregierte Werte: 60-Minuten-Werte.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Agregation60Minuten = new Aspekte("Aggregation60Minuten", "asp.agregation60Minuten");
			
			/**
			 * Analysewerte von HB.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AnalyseHB = new Aspekte("AnalyseHB", "asp.analyseHB");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qLkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vLkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qPkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vPkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
				 _b
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
				 _bMax
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _sKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vgKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
				 _aLkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 _kKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 _kLkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 _kPkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsVerkehrsStaerkeStunde
				 _qB
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsFahrzeugDichte
				 _kB
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsFahrzeugDichte
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vDelta
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
		
			/**
			Fahrzeugmenge Kfz (mit Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von QKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQKfz() {
				return _qKfz;
			}
		
			/**
			Fahrzeugmenge Kfz (mit Statusinformationen).
			<p>
			
			</p>
			
			@param _qKfz der neue Wert von QKfz.
			*/
			public void setQKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qKfz) {
				this._qKfz = _qKfz;
			}
		
			/**
			Geschwindigkeit Kfz (mit Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von VKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVKfz() {
				return _vKfz;
			}
		
			/**
			Geschwindigkeit Kfz (mit Statusinformationen).
			<p>
			
			</p>
			
			@param _vKfz der neue Wert von VKfz.
			*/
			public void setVKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vKfz) {
				this._vKfz = _vKfz;
			}
		
			/**
			Fahrzeugmenge Lkw (mit Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von QLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQLkw() {
				return _qLkw;
			}
		
			/**
			Fahrzeugmenge Lkw (mit Statusinformationen).
			<p>
			
			</p>
			
			@param _qLkw der neue Wert von QLkw.
			*/
			public void setQLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qLkw) {
				this._qLkw = _qLkw;
			}
		
			/**
			Geschwindigkeit Lkw (mit Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von VLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVLkw() {
				return _vLkw;
			}
		
			/**
			Geschwindigkeit Lkw (mit Statusinformationen).
			<p>
			
			</p>
			
			@param _vLkw der neue Wert von VLkw.
			*/
			public void setVLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vLkw) {
				this._vLkw = _vLkw;
			}
		
			/**
			Fahrzeugmenge Pkw (mit Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von QPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQPkw() {
				return _qPkw;
			}
		
			/**
			Fahrzeugmenge Pkw (mit Statusinformationen).
			<p>
			
			</p>
			
			@param _qPkw der neue Wert von QPkw.
			*/
			public void setQPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qPkw) {
				this._qPkw = _qPkw;
			}
		
			/**
			Geschwindigkeit Pkw (mit Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von VPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVPkw() {
				return _vPkw;
			}
		
			/**
			Geschwindigkeit Pkw (mit Statusinformationen).
			<p>
			
			</p>
			
			@param _vPkw der neue Wert von VPkw.
			*/
			public void setVPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vPkw) {
				this._vPkw = _vPkw;
			}
		
			/**
			Belegungsgrad (mit Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von B.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
				 getB() {
				return _b;
			}
		
			/**
			Belegungsgrad (mit Statusinformationen).
			<p>
			
			</p>
			
			@param _b der neue Wert von B.
			*/
			public void setB(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
			 _b) {
				this._b = _b;
			}
		
			/**
			Maximum des Belegungsgrades (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von BMax.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
				 getBMax() {
				return _bMax;
			}
		
			/**
			Maximum des Belegungsgrades (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _bMax der neue Wert von BMax.
			*/
			public void setBMax(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
			 _bMax) {
				this._bMax = _bMax;
			}
		
			/**
			Standardabweichung der Geschwindigkeit (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von SKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getSKfz() {
				return _sKfz;
			}
		
			/**
			Standardabweichung der Geschwindigkeit (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _sKfz der neue Wert von SKfz.
			*/
			public void setSKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _sKfz) {
				this._sKfz = _sKfz;
			}
		
			/**
			Geglätte mittlere Geschwindigkeit (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von VgKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVgKfz() {
				return _vgKfz;
			}
		
			/**
			Geglätte mittlere Geschwindigkeit (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _vgKfz der neue Wert von VgKfz.
			*/
			public void setVgKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vgKfz) {
				this._vgKfz = _vgKfz;
			}
		
			/**
			Lkw-Anteil (mit Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von ALkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
				 getALkw() {
				return _aLkw;
			}
		
			/**
			Lkw-Anteil (mit Statusinformationen).
			<p>
			
			</p>
			
			@param _aLkw der neue Wert von ALkw.
			*/
			public void setALkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
			 _aLkw) {
				this._aLkw = _aLkw;
			}
		
			/**
			Dichte der Kfz (mit Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von KKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 getKKfz() {
				return _kKfz;
			}
		
			/**
			Dichte der Kfz (mit Statusinformationen).
			<p>
			
			</p>
			
			@param _kKfz der neue Wert von KKfz.
			*/
			public void setKKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
			 _kKfz) {
				this._kKfz = _kKfz;
			}
		
			/**
			Dichte der Lkw (mit Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von KLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 getKLkw() {
				return _kLkw;
			}
		
			/**
			Dichte der Lkw (mit Statusinformationen).
			<p>
			
			</p>
			
			@param _kLkw der neue Wert von KLkw.
			*/
			public void setKLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
			 _kLkw) {
				this._kLkw = _kLkw;
			}
		
			/**
			Dichte der Pkw (mit Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von KPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 getKPkw() {
				return _kPkw;
			}
		
			/**
			Dichte der Pkw (mit Statusinformationen).
			<p>
			
			</p>
			
			@param _kPkw der neue Wert von KPkw.
			*/
			public void setKPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
			 _kPkw) {
				this._kPkw = _kPkw;
			}
		
			/**
			Bemessungsverkehrsstärke (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von QB.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsVerkehrsStaerkeStunde
				 getQB() {
				return _qB;
			}
		
			/**
			Bemessungsverkehrsstärke (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _qB der neue Wert von QB.
			*/
			public void setQB(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsVerkehrsStaerkeStunde
			 _qB) {
				this._qB = _qB;
			}
		
			/**
			Bemessungsverkehrsdichte (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von KB.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsFahrzeugDichte
				 getKB() {
				return _kB;
			}
		
			/**
			Bemessungsverkehrsdichte (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _kB der neue Wert von KB.
			*/
			public void setKB(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsFahrzeugDichte
			 _kB) {
				this._kB = _kB;
			}
		
			/**
			Gewichtete Differenzgeschwindigkeit (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von VDelta.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVDelta() {
				return _vDelta;
			}
		
			/**
			Gewichtete Differenzgeschwindigkeit (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _vDelta der neue Wert von VDelta.
			*/
			public void setVDelta(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vDelta) {
				this._vDelta = _vDelta;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getQKfz().bean2Atl(datum.getItem("QKfz"), factory);
					// AttributListenDefinition
						getVKfz().bean2Atl(datum.getItem("VKfz"), factory);
					// AttributListenDefinition
						getQLkw().bean2Atl(datum.getItem("QLkw"), factory);
					// AttributListenDefinition
						getVLkw().bean2Atl(datum.getItem("VLkw"), factory);
					// AttributListenDefinition
						getQPkw().bean2Atl(datum.getItem("QPkw"), factory);
					// AttributListenDefinition
						getVPkw().bean2Atl(datum.getItem("VPkw"), factory);
					// AttributListenDefinition
						getB().bean2Atl(datum.getItem("B"), factory);
					// AttributListenDefinition
						getBMax().bean2Atl(datum.getItem("BMax"), factory);
					// AttributListenDefinition
						getSKfz().bean2Atl(datum.getItem("SKfz"), factory);
					// AttributListenDefinition
						getVgKfz().bean2Atl(datum.getItem("VgKfz"), factory);
					// AttributListenDefinition
						getALkw().bean2Atl(datum.getItem("ALkw"), factory);
					// AttributListenDefinition
						getKKfz().bean2Atl(datum.getItem("KKfz"), factory);
					// AttributListenDefinition
						getKLkw().bean2Atl(datum.getItem("KLkw"), factory);
					// AttributListenDefinition
						getKPkw().bean2Atl(datum.getItem("KPkw"), factory);
					// AttributListenDefinition
						getQB().bean2Atl(datum.getItem("QB"), factory);
					// AttributListenDefinition
						getKB().bean2Atl(datum.getItem("KB"), factory);
					// AttributListenDefinition
						getVDelta().bean2Atl(datum.getItem("VDelta"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getQKfz().atl2Bean(daten.getItem("QKfz"), factory);
					// AttributListenDefinition
						getVKfz().atl2Bean(daten.getItem("VKfz"), factory);
					// AttributListenDefinition
						getQLkw().atl2Bean(daten.getItem("QLkw"), factory);
					// AttributListenDefinition
						getVLkw().atl2Bean(daten.getItem("VLkw"), factory);
					// AttributListenDefinition
						getQPkw().atl2Bean(daten.getItem("QPkw"), factory);
					// AttributListenDefinition
						getVPkw().atl2Bean(daten.getItem("VPkw"), factory);
					// AttributListenDefinition
						getB().atl2Bean(daten.getItem("B"), factory);
					// AttributListenDefinition
						getBMax().atl2Bean(daten.getItem("BMax"), factory);
					// AttributListenDefinition
						getSKfz().atl2Bean(daten.getItem("SKfz"), factory);
					// AttributListenDefinition
						getVgKfz().atl2Bean(daten.getItem("VgKfz"), factory);
					// AttributListenDefinition
						getALkw().atl2Bean(daten.getItem("ALkw"), factory);
					// AttributListenDefinition
						getKKfz().atl2Bean(daten.getItem("KKfz"), factory);
					// AttributListenDefinition
						getKLkw().atl2Bean(daten.getItem("KLkw"), factory);
					// AttributListenDefinition
						getKPkw().atl2Bean(daten.getItem("KPkw"), factory);
					// AttributListenDefinition
						getQB().atl2Bean(daten.getItem("QB"), factory);
					// AttributListenDefinition
						getKB().atl2Bean(daten.getItem("KB"), factory);
					// AttributListenDefinition
						getVDelta().atl2Bean(daten.getItem("VDelta"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._qKfz = getQKfz().clone();
							klon._vKfz = getVKfz().clone();
							klon._qLkw = getQLkw().clone();
							klon._vLkw = getVLkw().clone();
							klon._qPkw = getQPkw().clone();
							klon._vPkw = getVPkw().clone();
							klon._b = getB().clone();
							klon._bMax = getBMax().clone();
							klon._sKfz = getSKfz().clone();
							klon._vgKfz = getVgKfz().clone();
							klon._aLkw = getALkw().clone();
							klon._kKfz = getKKfz().clone();
							klon._kLkw = getKLkw().clone();
							klon._kPkw = getKPkw().clone();
							klon._qB = getQB().clone();
							klon._kB = getKB().clone();
							klon._vDelta = getVDelta().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.verkehrsDatenKurzZeitMq";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdVerkehrsDatenKurzZeitMq(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
