/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Langzeitverkehrsdaten mit Geschwindigkeitsverteilung (aus TLS Version 24 (FG 1 &#47; Typ 79) und
					berechneten Zusatzwerten)für Fahrstreifen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 41
 */
public class OdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungFs extends AbstractOnlineDatensatz<OdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungFs.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.MessWertErsetzung,
					Aspekte.ExterneErfassung,
				};
			}
	
			/**
			 * Attributgruppe nach Modifikation durch die Messwertersetzung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt MessWertErsetzung = new Aspekte("MessWertErsetzung", "asp.messWertErsetzung");
			
			/**
			 * Attributgruppe wurde durch eine externe Erfassungseinheit geschrieben (z.B. TLS).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ExterneErfassung = new Aspekte("ExterneErfassung", "asp.externeErfassung");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerStunden1Bis
				 _t
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 _qKfzNk
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 _qKrad
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 _qPkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 _qLfw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 _qPkwA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 _qLkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 _qLkwA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 _qSattelKfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 _qBus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 _qSGV
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
				 _anteilSGV
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _vLVo
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _vSGV
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _vBPA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _sLVo
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _sSGV
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _sBPA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _v85LVo
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _v85SGV
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _v85BPA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _v15LVo
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _v15SGV
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _v15BPA
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				> _qLVoGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				> _qSGVGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				> _qBPAGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGrenzGeschwindigkeit
				> _vGrenzLVo = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGrenzGeschwindigkeit
				>(15, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGrenzGeschwindigkeit
				> _vGrenzSGV = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGrenzGeschwindigkeit
				>(15, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGrenzGeschwindigkeit
				> _vGrenzBPA = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGrenzGeschwindigkeit
				>(15, true);
		
			/**
			Intervalldauer, mit dem die Werte erfasst wurden.
			<p>
			
			</p>
			
			@return der Wert von T.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerStunden1Bis
				 getT() {
				return _t;
			}
		
			/**
			Intervalldauer, mit dem die Werte erfasst wurden.
			<p>
			
			</p>
			
			@param _t der neue Wert von T.
			*/
			public void setT(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerStunden1Bis
			 _t) {
				this._t = _t;
			}
		
			/**
			Fahrzeugmenge Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@return der Wert von QKfzNk.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 getQKfzNk() {
				return _qKfzNk;
			}
		
			/**
			Fahrzeugmenge Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@param _qKfzNk der neue Wert von QKfzNk.
			*/
			public void setQKfzNk(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 _qKfzNk) {
				this._qKfzNk = _qKfzNk;
			}
		
			/**
			Fahrzeugmenge Krad.
			<p>
			
			</p>
			
			@return der Wert von QKrad.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 getQKrad() {
				return _qKrad;
			}
		
			/**
			Fahrzeugmenge Krad.
			<p>
			
			</p>
			
			@param _qKrad der neue Wert von QKrad.
			*/
			public void setQKrad(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 _qKrad) {
				this._qKrad = _qKrad;
			}
		
			/**
			Fahrzeugmenge Pkw.
			<p>
			
			</p>
			
			@return der Wert von QPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 getQPkw() {
				return _qPkw;
			}
		
			/**
			Fahrzeugmenge Pkw.
			<p>
			
			</p>
			
			@param _qPkw der neue Wert von QPkw.
			*/
			public void setQPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 _qPkw) {
				this._qPkw = _qPkw;
			}
		
			/**
			Fahrzeugmenge Lieferwagen.
			<p>
			
			</p>
			
			@return der Wert von QLfw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 getQLfw() {
				return _qLfw;
			}
		
			/**
			Fahrzeugmenge Lieferwagen.
			<p>
			
			</p>
			
			@param _qLfw der neue Wert von QLfw.
			*/
			public void setQLfw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 _qLfw) {
				this._qLfw = _qLfw;
			}
		
			/**
			Fahrzeugmenge Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von QPkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 getQPkwA() {
				return _qPkwA;
			}
		
			/**
			Fahrzeugmenge Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _qPkwA der neue Wert von QPkwA.
			*/
			public void setQPkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 _qPkwA) {
				this._qPkwA = _qPkwA;
			}
		
			/**
			Fahrzeugmenge Lkw.
			<p>
			
			</p>
			
			@return der Wert von QLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 getQLkw() {
				return _qLkw;
			}
		
			/**
			Fahrzeugmenge Lkw.
			<p>
			
			</p>
			
			@param _qLkw der neue Wert von QLkw.
			*/
			public void setQLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 _qLkw) {
				this._qLkw = _qLkw;
			}
		
			/**
			Fahrzeugmenge Lkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von QLkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 getQLkwA() {
				return _qLkwA;
			}
		
			/**
			Fahrzeugmenge Lkw mit Anhänger.
			<p>
			
			</p>
			
			@param _qLkwA der neue Wert von QLkwA.
			*/
			public void setQLkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 _qLkwA) {
				this._qLkwA = _qLkwA;
			}
		
			/**
			Fahrzeugmenge Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von QSattelKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 getQSattelKfz() {
				return _qSattelKfz;
			}
		
			/**
			Fahrzeugmenge Sattel-Kfz.
			<p>
			
			</p>
			
			@param _qSattelKfz der neue Wert von QSattelKfz.
			*/
			public void setQSattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 _qSattelKfz) {
				this._qSattelKfz = _qSattelKfz;
			}
		
			/**
			Fahrzeugmenge Busse.
			<p>
			
			</p>
			
			@return der Wert von QBus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 getQBus() {
				return _qBus;
			}
		
			/**
			Fahrzeugmenge Busse.
			<p>
			
			</p>
			
			@param _qBus der neue Wert von QBus.
			*/
			public void setQBus(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 _qBus) {
				this._qBus = _qBus;
			}
		
			/**
			Berechneter Wert = qLkw + qLkwA + qSattelKfz.
			<p>
			
			</p>
			
			@return der Wert von QSGV.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 getQSGV() {
				return _qSGV;
			}
		
			/**
			Berechneter Wert = qLkw + qLkwA + qSattelKfz.
			<p>
			
			</p>
			
			@param _qSGV der neue Wert von QSGV.
			*/
			public void setQSGV(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 _qSGV) {
				this._qSGV = _qSGV;
			}
		
			/**
			Berechneter Wert = qSGV &#47; qKfzGesamt * 100%.
			<p>
			
			</p>
			
			@return der Wert von AnteilSGV.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
				 getAnteilSGV() {
				return _anteilSGV;
			}
		
			/**
			Berechneter Wert = qSGV &#47; qKfzGesamt * 100%.
			<p>
			
			</p>
			
			@param _anteilSGV der neue Wert von AnteilSGV.
			*/
			public void setAnteilSGV(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
			 _anteilSGV) {
				this._anteilSGV = _anteilSGV;
			}
		
			/**
			Geschwindigkeit Leichtverkehr ohne Anhänger.
			<p>
			
			</p>
			
			@return der Wert von VLVo.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getVLVo() {
				return _vLVo;
			}
		
			/**
			Geschwindigkeit Leichtverkehr ohne Anhänger.
			<p>
			
			</p>
			
			@param _vLVo der neue Wert von VLVo.
			*/
			public void setVLVo(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vLVo) {
				this._vLVo = _vLVo;
			}
		
			/**
			Geschwindigkeit Schwerer Güterverkehr.
			<p>
			
			</p>
			
			@return der Wert von VSGV.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getVSGV() {
				return _vSGV;
			}
		
			/**
			Geschwindigkeit Schwerer Güterverkehr.
			<p>
			
			</p>
			
			@param _vSGV der neue Wert von VSGV.
			*/
			public void setVSGV(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vSGV) {
				this._vSGV = _vSGV;
			}
		
			/**
			Geschwindigkeit Busse und Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von VBPA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getVBPA() {
				return _vBPA;
			}
		
			/**
			Geschwindigkeit Busse und Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _vBPA der neue Wert von VBPA.
			*/
			public void setVBPA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vBPA) {
				this._vBPA = _vBPA;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Leichtverkehr ohne Anhänger.
			<p>
			
			</p>
			
			@return der Wert von SLVo.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getSLVo() {
				return _sLVo;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Leichtverkehr ohne Anhänger.
			<p>
			
			</p>
			
			@param _sLVo der neue Wert von SLVo.
			*/
			public void setSLVo(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _sLVo) {
				this._sLVo = _sLVo;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Schwerer Güterverkehr.
			<p>
			
			</p>
			
			@return der Wert von SSGV.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getSSGV() {
				return _sSGV;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Schwerer Güterverkehr.
			<p>
			
			</p>
			
			@param _sSGV der neue Wert von SSGV.
			*/
			public void setSSGV(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _sSGV) {
				this._sSGV = _sSGV;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Busse und Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von SBPA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getSBPA() {
				return _sBPA;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Busse und Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _sBPA der neue Wert von SBPA.
			*/
			public void setSBPA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _sBPA) {
				this._sBPA = _sBPA;
			}
		
			/**
			v85-Geschwindigkeit Leichtverkehr ohne Anhänger.
			<p>
			
			</p>
			
			@return der Wert von V85LVo.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getV85LVo() {
				return _v85LVo;
			}
		
			/**
			v85-Geschwindigkeit Leichtverkehr ohne Anhänger.
			<p>
			
			</p>
			
			@param _v85LVo der neue Wert von V85LVo.
			*/
			public void setV85LVo(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _v85LVo) {
				this._v85LVo = _v85LVo;
			}
		
			/**
			v85-Geschwindigkeit Pkw Schwerer Güterverkehr.
			<p>
			
			</p>
			
			@return der Wert von V85SGV.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getV85SGV() {
				return _v85SGV;
			}
		
			/**
			v85-Geschwindigkeit Pkw Schwerer Güterverkehr.
			<p>
			
			</p>
			
			@param _v85SGV der neue Wert von V85SGV.
			*/
			public void setV85SGV(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _v85SGV) {
				this._v85SGV = _v85SGV;
			}
		
			/**
			v85-Geschwindigkeit Busse und Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von V85BPA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getV85BPA() {
				return _v85BPA;
			}
		
			/**
			v85-Geschwindigkeit Busse und Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _v85BPA der neue Wert von V85BPA.
			*/
			public void setV85BPA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _v85BPA) {
				this._v85BPA = _v85BPA;
			}
		
			/**
			v15-Geschwindigkeit Leichtverkehr ohne Anhänger.
			<p>
			
			</p>
			
			@return der Wert von V15LVo.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getV15LVo() {
				return _v15LVo;
			}
		
			/**
			v15-Geschwindigkeit Leichtverkehr ohne Anhänger.
			<p>
			
			</p>
			
			@param _v15LVo der neue Wert von V15LVo.
			*/
			public void setV15LVo(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _v15LVo) {
				this._v15LVo = _v15LVo;
			}
		
			/**
			v15-Geschwindigkeit Pkw Schwerer Güterverkehr.
			<p>
			
			</p>
			
			@return der Wert von V15SGV.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getV15SGV() {
				return _v15SGV;
			}
		
			/**
			v15-Geschwindigkeit Pkw Schwerer Güterverkehr.
			<p>
			
			</p>
			
			@param _v15SGV der neue Wert von V15SGV.
			*/
			public void setV15SGV(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _v15SGV) {
				this._v15SGV = _v15SGV;
			}
		
			/**
			v15-Geschwindigkeit Busse und Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von V15BPA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getV15BPA() {
				return _v15BPA;
			}
		
			/**
			v15-Geschwindigkeit Busse und Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _v15BPA der neue Wert von V15BPA.
			*/
			public void setV15BPA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _v15BPA) {
				this._v15BPA = _v15BPA;
			}
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Leichtverkehr ohne Anhänger.
			<p>
			
			</p>
			
			@return der Wert von QLVoGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				> getQLVoGeschwKlasse() {
				return _qLVoGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Schwerer Güterverkehr.
			<p>
			
			</p>
			
			@return der Wert von QSGVGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				> getQSGVGeschwKlasse() {
				return _qSGVGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Busse und Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von QBPAGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				> getQBPAGeschwKlasse() {
				return _qBPAGeschwKlasse;
			}
		
		
			/**
			Grenze der Geschwindigkeitsklasse für LVo.
			<p>
			&lt;absatz&gt;
										Der Werte beschreibt die Grenzen
										der Geschwindigkeitsklasse.
										Folgende Regeln müssen dabei eingehalten
										werden:
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										1. Es gilt für alle Klassen untere Grenze
										&amp;kleiner; Wert &amp;kleinerGleich; obere
										Grenze.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										2. Die Reihenfolge der Klassen
										ist immer von der kleinsten
										Geschwindigkeitsklasse zur größten.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										3. Die unterste Grenze der ersten Klasse ist
										immer 0 km&#47;h.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										4. Die letzte Klasse ist immer nach oben
										unbegrenzt.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										5. Die Struktur muss immer alle
										Grenzen für eine Fahrzeugklasse enthalten.
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von VGrenzLVo.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGrenzGeschwindigkeit
				> getVGrenzLVo() {
				return _vGrenzLVo;
			}
		
		
			/**
			Grenze der Geschwindigkeitsklasse für SGV.
			<p>
			&lt;absatz&gt;
										Der Werte beschreibt die Grenzen
										der Geschwindigkeitsklasse.
										Folgende Regeln müssen dabei eingehalten
										werden:
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										1. Es gilt für alle Klassen untere Grenze
										&amp;kleiner; Wert &amp;kleinerGleich; obere
										Grenze.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										2. Die Reihenfolge der Klassen
										ist immer von der kleinsten
										Geschwindigkeitsklasse zur größten.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										3. Die unterste Grenze der ersten Klasse ist
										immer 0 km&#47;h.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										4. Die letzte Klasse ist immer nach oben
										unbegrenzt.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										5. Die Struktur muss immer alle
										Grenzen für eine Fahrzeugklasse enthalten.
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von VGrenzSGV.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGrenzGeschwindigkeit
				> getVGrenzSGV() {
				return _vGrenzSGV;
			}
		
		
			/**
			Grenze der Geschwindigkeitsklasse für BPA.
			<p>
			&lt;absatz&gt;
										Der Werte beschreibt die Grenzen
										der Geschwindigkeitsklasse.
										Folgende Regeln müssen dabei eingehalten
										werden:
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										1. Es gilt für alle Klassen untere Grenze
										&amp;kleiner; Wert &amp;kleinerGleich; obere
										Grenze.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										2. Die Reihenfolge der Klassen
										ist immer von der kleinsten
										Geschwindigkeitsklasse zur größten.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										3. Die unterste Grenze der ersten Klasse ist
										immer 0 km&#47;h.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										4. Die letzte Klasse ist immer nach oben
										unbegrenzt.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										5. Die Struktur muss immer alle
										Grenzen für eine Fahrzeugklasse enthalten.
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von VGrenzBPA.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGrenzGeschwindigkeit
				> getVGrenzBPA() {
				return _vGrenzBPA;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getT() != null) {
		                if (getT().isZustand()) {
		                    datum.getUnscaledValue("T").setText(getT().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("T").set(getT().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQKfzNk() != null) {
		                if (getQKfzNk().isZustand()) {
		                    datum.getUnscaledValue("qKfzNk").setText(getQKfzNk().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qKfzNk").set(getQKfzNk().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQKrad() != null) {
		                if (getQKrad().isZustand()) {
		                    datum.getUnscaledValue("qKrad").setText(getQKrad().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qKrad").set(getQKrad().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQPkw() != null) {
		                if (getQPkw().isZustand()) {
		                    datum.getUnscaledValue("qPkw").setText(getQPkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qPkw").set(getQPkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQLfw() != null) {
		                if (getQLfw().isZustand()) {
		                    datum.getUnscaledValue("qLfw").setText(getQLfw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qLfw").set(getQLfw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQPkwA() != null) {
		                if (getQPkwA().isZustand()) {
		                    datum.getUnscaledValue("qPkwA").setText(getQPkwA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qPkwA").set(getQPkwA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQLkw() != null) {
		                if (getQLkw().isZustand()) {
		                    datum.getUnscaledValue("qLkw").setText(getQLkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qLkw").set(getQLkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQLkwA() != null) {
		                if (getQLkwA().isZustand()) {
		                    datum.getUnscaledValue("qLkwA").setText(getQLkwA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qLkwA").set(getQLkwA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQSattelKfz() != null) {
		                if (getQSattelKfz().isZustand()) {
		                    datum.getUnscaledValue("qSattelKfz").setText(getQSattelKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qSattelKfz").set(getQSattelKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQBus() != null) {
		                if (getQBus().isZustand()) {
		                    datum.getUnscaledValue("qBus").setText(getQBus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qBus").set(getQBus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQSGV() != null) {
		                if (getQSGV().isZustand()) {
		                    datum.getUnscaledValue("qSGV").setText(getQSGV().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qSGV").set(getQSGV().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnteilSGV() != null) {
		                if (getAnteilSGV().isZustand()) {
		                    datum.getUnscaledValue("anteilSGV").setText(getAnteilSGV().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("anteilSGV").set(getAnteilSGV().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVLVo() != null) {
		                if (getVLVo().isZustand()) {
		                    datum.getUnscaledValue("vLVo").setText(getVLVo().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vLVo").set(getVLVo().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVSGV() != null) {
		                if (getVSGV().isZustand()) {
		                    datum.getUnscaledValue("vSGV").setText(getVSGV().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vSGV").set(getVSGV().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVBPA() != null) {
		                if (getVBPA().isZustand()) {
		                    datum.getUnscaledValue("vBPA").setText(getVBPA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vBPA").set(getVBPA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSLVo() != null) {
		                if (getSLVo().isZustand()) {
		                    datum.getUnscaledValue("sLVo").setText(getSLVo().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("sLVo").set(getSLVo().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSSGV() != null) {
		                if (getSSGV().isZustand()) {
		                    datum.getUnscaledValue("sSGV").setText(getSSGV().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("sSGV").set(getSSGV().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSBPA() != null) {
		                if (getSBPA().isZustand()) {
		                    datum.getUnscaledValue("sBPA").setText(getSBPA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("sBPA").set(getSBPA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV85LVo() != null) {
		                if (getV85LVo().isZustand()) {
		                    datum.getUnscaledValue("v85LVo").setText(getV85LVo().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v85LVo").set(getV85LVo().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV85SGV() != null) {
		                if (getV85SGV().isZustand()) {
		                    datum.getUnscaledValue("v85SGV").setText(getV85SGV().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v85SGV").set(getV85SGV().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV85BPA() != null) {
		                if (getV85BPA().isZustand()) {
		                    datum.getUnscaledValue("v85BPA").setText(getV85BPA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v85BPA").set(getV85BPA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV15LVo() != null) {
		                if (getV15LVo().isZustand()) {
		                    datum.getUnscaledValue("v15LVo").setText(getV15LVo().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v15LVo").set(getV15LVo().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV15SGV() != null) {
		                if (getV15SGV().isZustand()) {
		                    datum.getUnscaledValue("v15SGV").setText(getV15SGV().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v15SGV").set(getV15SGV().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV15BPA() != null) {
		                if (getV15BPA().isZustand()) {
		                    datum.getUnscaledValue("v15BPA").setText(getV15BPA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v15BPA").set(getV15BPA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQLVoGeschwKlasse() != null) {
						final Data.NumberArray arrayQLVoGeschwKlasse = datum.
							getUnscaledArray
							("qLVoGeschwKlasse");
						arrayQLVoGeschwKlasse.setLength(getQLVoGeschwKlasse().size());
						for (int i = 0; i < arrayQLVoGeschwKlasse.getLength(); ++i) {
							arrayQLVoGeschwKlasse.getValue(i).set(getQLVoGeschwKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getQSGVGeschwKlasse() != null) {
						final Data.NumberArray arrayQSGVGeschwKlasse = datum.
							getUnscaledArray
							("qSGVGeschwKlasse");
						arrayQSGVGeschwKlasse.setLength(getQSGVGeschwKlasse().size());
						for (int i = 0; i < arrayQSGVGeschwKlasse.getLength(); ++i) {
							arrayQSGVGeschwKlasse.getValue(i).set(getQSGVGeschwKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getQBPAGeschwKlasse() != null) {
						final Data.NumberArray arrayQBPAGeschwKlasse = datum.
							getUnscaledArray
							("qBPAGeschwKlasse");
						arrayQBPAGeschwKlasse.setLength(getQBPAGeschwKlasse().size());
						for (int i = 0; i < arrayQBPAGeschwKlasse.getLength(); ++i) {
							arrayQBPAGeschwKlasse.getValue(i).set(getQBPAGeschwKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getVGrenzLVo() != null) {
						final Data.NumberArray arrayVGrenzLVo = datum.
							getUnscaledArray
							("vGrenzLVo");
						arrayVGrenzLVo.setLength(getVGrenzLVo().size());
						for (int i = 0; i < arrayVGrenzLVo.getLength(); ++i) {
							arrayVGrenzLVo.getValue(i).set(getVGrenzLVo().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getVGrenzSGV() != null) {
						final Data.NumberArray arrayVGrenzSGV = datum.
							getUnscaledArray
							("vGrenzSGV");
						arrayVGrenzSGV.setLength(getVGrenzSGV().size());
						for (int i = 0; i < arrayVGrenzSGV.getLength(); ++i) {
							arrayVGrenzSGV.getValue(i).set(getVGrenzSGV().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getVGrenzBPA() != null) {
						final Data.NumberArray arrayVGrenzBPA = datum.
							getUnscaledArray
							("vGrenzBPA");
						arrayVGrenzBPA.setLength(getVGrenzBPA().size());
						for (int i = 0; i < arrayVGrenzBPA.getLength(); ++i) {
							arrayVGrenzBPA.getValue(i).set(getVGrenzBPA().get(i).getValue());
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("T").isState()) {
								setT(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerStunden1Bis
								.getZustand(daten.getScaledValue("T").getText()));
							} else {
							setT(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerStunden1Bis
							(daten.
								getUnscaledValue
							("T").
									longValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qKfzNk").isState()) {
								setQKfzNk(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
								.getZustand(daten.getScaledValue("qKfzNk").getText()));
							} else {
							setQKfzNk(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
							(daten.
								getUnscaledValue
							("qKfzNk").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qKrad").isState()) {
								setQKrad(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
								.getZustand(daten.getScaledValue("qKrad").getText()));
							} else {
							setQKrad(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
							(daten.
								getUnscaledValue
							("qKrad").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qPkw").isState()) {
								setQPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
								.getZustand(daten.getScaledValue("qPkw").getText()));
							} else {
							setQPkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
							(daten.
								getUnscaledValue
							("qPkw").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qLfw").isState()) {
								setQLfw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
								.getZustand(daten.getScaledValue("qLfw").getText()));
							} else {
							setQLfw(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
							(daten.
								getUnscaledValue
							("qLfw").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qPkwA").isState()) {
								setQPkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
								.getZustand(daten.getScaledValue("qPkwA").getText()));
							} else {
							setQPkwA(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
							(daten.
								getUnscaledValue
							("qPkwA").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qLkw").isState()) {
								setQLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
								.getZustand(daten.getScaledValue("qLkw").getText()));
							} else {
							setQLkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
							(daten.
								getUnscaledValue
							("qLkw").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qLkwA").isState()) {
								setQLkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
								.getZustand(daten.getScaledValue("qLkwA").getText()));
							} else {
							setQLkwA(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
							(daten.
								getUnscaledValue
							("qLkwA").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qSattelKfz").isState()) {
								setQSattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
								.getZustand(daten.getScaledValue("qSattelKfz").getText()));
							} else {
							setQSattelKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
							(daten.
								getUnscaledValue
							("qSattelKfz").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qBus").isState()) {
								setQBus(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
								.getZustand(daten.getScaledValue("qBus").getText()));
							} else {
							setQBus(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
							(daten.
								getUnscaledValue
							("qBus").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qSGV").isState()) {
								setQSGV(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
								.getZustand(daten.getScaledValue("qSGV").getText()));
							} else {
							setQSGV(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
							(daten.
								getUnscaledValue
							("qSGV").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("anteilSGV").isState()) {
								setAnteilSGV(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
								.getZustand(daten.getScaledValue("anteilSGV").getText()));
							} else {
							setAnteilSGV(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
							(daten.
								getUnscaledValue
							("anteilSGV").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vLVo").isState()) {
								setVLVo(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("vLVo").getText()));
							} else {
							setVLVo(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("vLVo").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vSGV").isState()) {
								setVSGV(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("vSGV").getText()));
							} else {
							setVSGV(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("vSGV").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vBPA").isState()) {
								setVBPA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("vBPA").getText()));
							} else {
							setVBPA(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("vBPA").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sLVo").isState()) {
								setSLVo(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("sLVo").getText()));
							} else {
							setSLVo(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("sLVo").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sSGV").isState()) {
								setSSGV(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("sSGV").getText()));
							} else {
							setSSGV(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("sSGV").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sBPA").isState()) {
								setSBPA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("sBPA").getText()));
							} else {
							setSBPA(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("sBPA").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v85LVo").isState()) {
								setV85LVo(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("v85LVo").getText()));
							} else {
							setV85LVo(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("v85LVo").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v85SGV").isState()) {
								setV85SGV(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("v85SGV").getText()));
							} else {
							setV85SGV(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("v85SGV").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v85BPA").isState()) {
								setV85BPA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("v85BPA").getText()));
							} else {
							setV85BPA(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("v85BPA").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v15LVo").isState()) {
								setV15LVo(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("v15LVo").getText()));
							} else {
							setV15LVo(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("v15LVo").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v15SGV").isState()) {
								setV15SGV(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("v15SGV").getText()));
							} else {
							setV15SGV(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("v15SGV").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v15BPA").isState()) {
								setV15BPA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("v15BPA").getText()));
							} else {
							setV15BPA(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("v15BPA").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQLVoGeschwKlasse = daten.
							getUnscaledArray
						("qLVoGeschwKlasse");
		
						for (int i = 0; i < arrayQLVoGeschwKlasse.getLength(); ++i) {
		                    if (arrayQLVoGeschwKlasse.getValue(i).isState()) {
		                        getQLVoGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
		                        .getZustand(arrayQLVoGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQLVoGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
		                    (arrayQLVoGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQSGVGeschwKlasse = daten.
							getUnscaledArray
						("qSGVGeschwKlasse");
		
						for (int i = 0; i < arrayQSGVGeschwKlasse.getLength(); ++i) {
		                    if (arrayQSGVGeschwKlasse.getValue(i).isState()) {
		                        getQSGVGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
		                        .getZustand(arrayQSGVGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQSGVGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
		                    (arrayQSGVGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQBPAGeschwKlasse = daten.
							getUnscaledArray
						("qBPAGeschwKlasse");
		
						for (int i = 0; i < arrayQBPAGeschwKlasse.getLength(); ++i) {
		                    if (arrayQBPAGeschwKlasse.getValue(i).isState()) {
		                        getQBPAGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
		                        .getZustand(arrayQBPAGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQBPAGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
		                    (arrayQBPAGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayVGrenzLVo = daten.
							getUnscaledArray
						("vGrenzLVo");
		
						for (int i = 0; i < arrayVGrenzLVo.getLength(); ++i) {
		                    getVGrenzLVo().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGrenzGeschwindigkeit
		                    (arrayVGrenzLVo.
		                    		shortValue
		                    (i)));
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayVGrenzSGV = daten.
							getUnscaledArray
						("vGrenzSGV");
		
						for (int i = 0; i < arrayVGrenzSGV.getLength(); ++i) {
		                    getVGrenzSGV().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGrenzGeschwindigkeit
		                    (arrayVGrenzSGV.
		                    		shortValue
		                    (i)));
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayVGrenzBPA = daten.
							getUnscaledArray
						("vGrenzBPA");
		
						for (int i = 0; i < arrayVGrenzBPA.getLength(); ++i) {
		                    getVGrenzBPA().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGrenzGeschwindigkeit
		                    (arrayVGrenzBPA.
		                    		shortValue
		                    (i)));
		                }
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setT(getT());
							klon.setQKfzNk(getQKfzNk());
							klon.setQKrad(getQKrad());
							klon.setQPkw(getQPkw());
							klon.setQLfw(getQLfw());
							klon.setQPkwA(getQPkwA());
							klon.setQLkw(getQLkw());
							klon.setQLkwA(getQLkwA());
							klon.setQSattelKfz(getQSattelKfz());
							klon.setQBus(getQBus());
							klon.setQSGV(getQSGV());
							klon.setAnteilSGV(getAnteilSGV());
							klon.setVLVo(getVLVo());
							klon.setVSGV(getVSGV());
							klon.setVBPA(getVBPA());
							klon.setSLVo(getSLVo());
							klon.setSSGV(getSSGV());
							klon.setSBPA(getSBPA());
							klon.setV85LVo(getV85LVo());
							klon.setV85SGV(getV85SGV());
							klon.setV85BPA(getV85BPA());
							klon.setV15LVo(getV15LVo());
							klon.setV15SGV(getV15SGV());
							klon.setV15BPA(getV15BPA());
						klon._qLVoGeschwKlasse = getQLVoGeschwKlasse().clone();
						klon._qSGVGeschwKlasse = getQSGVGeschwKlasse().clone();
						klon._qBPAGeschwKlasse = getQBPAGeschwKlasse().clone();
						klon._vGrenzLVo = getVGrenzLVo().clone();
						klon._vGrenzSGV = getVGrenzSGV().clone();
						klon._vGrenzBPA = getVGrenzBPA().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.verkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungFs";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungFs(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
