/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
MSV-Wert (Bemessungsverkehrsstärke) für die Gesamt-Kfz für ein Jahr (1., 30. und 50.
					Spitzenstunde QKfzGesamt) .
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 45
 */
public class OdVerkehrsDatenLangZeitMSV extends AbstractOnlineDatensatz<OdVerkehrsDatenLangZeitMSV.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.AgregationDtvJahr,
				};
			}
	
			/**
			 * Aggregierte Werte: DTV-Jahreswerte.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AgregationDtvJahr = new Aspekte("AggregationDtvJahr", "asp.agregationDtvJahr");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 _01SpitzenStundeQKfzGesamt
				;
				private Feld<	Zeitstempel
				> _01SpitzenStundeQKfzGesamtZeitPunkte = new Feld<	Zeitstempel
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 _30SpitzenStundeQKfzGesamt
				;
				private Feld<	Zeitstempel
				> _30SpitzenStundeQKfzGesamtZeitPunkte = new Feld<	Zeitstempel
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 _50SpitzenStundeQKfzGesamt
				;
				private Feld<	Zeitstempel
				> _50SpitzenStundeQKfzGesamtZeitPunkte = new Feld<	Zeitstempel
				>(0, true);
		
			/**
			Verkehrsstärke QKfzGesamt für die meist belastete Spitzenstunde des Jahres.
			<p>
			
			</p>
			
			@return der Wert von 01SpitzenStundeQKfzGesamt.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 get01SpitzenStundeQKfzGesamt() {
				return _01SpitzenStundeQKfzGesamt;
			}
		
			/**
			Verkehrsstärke QKfzGesamt für die meist belastete Spitzenstunde des Jahres.
			<p>
			
			</p>
			
			@param _01SpitzenStundeQKfzGesamt der neue Wert von 01SpitzenStundeQKfzGesamt.
			*/
			public void set01SpitzenStundeQKfzGesamt(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 _01SpitzenStundeQKfzGesamt) {
				this._01SpitzenStundeQKfzGesamt = _01SpitzenStundeQKfzGesamt;
			}
		
			/**
			Zeitpunkt für die meist belastete Spitzenstunde des Jahres bezogen auf den Wert
									Verkehrsstärke QKfzGesamt.
			<p>
			
			</p>
			
			@return der Wert von 01SpitzenStundeQKfzGesamtZeitPunkte.
			*/
				public Feld<	Zeitstempel
				> get01SpitzenStundeQKfzGesamtZeitPunkte() {
				return _01SpitzenStundeQKfzGesamtZeitPunkte;
			}
		
		
			/**
			Verkehrsstärke QKfzGesamt für die 30. belastete Spitzenstunde des Jahres.
			<p>
			
			</p>
			
			@return der Wert von 30SpitzenStundeQKfzGesamt.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 get30SpitzenStundeQKfzGesamt() {
				return _30SpitzenStundeQKfzGesamt;
			}
		
			/**
			Verkehrsstärke QKfzGesamt für die 30. belastete Spitzenstunde des Jahres.
			<p>
			
			</p>
			
			@param _30SpitzenStundeQKfzGesamt der neue Wert von 30SpitzenStundeQKfzGesamt.
			*/
			public void set30SpitzenStundeQKfzGesamt(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 _30SpitzenStundeQKfzGesamt) {
				this._30SpitzenStundeQKfzGesamt = _30SpitzenStundeQKfzGesamt;
			}
		
			/**
			Zeitpunkt für die 30. belastete Spitzenstunde des Jahres bezogen auf den Wert
									Verkehrsstärke QKfzGesamt.
			<p>
			
			</p>
			
			@return der Wert von 30SpitzenStundeQKfzGesamtZeitPunkte.
			*/
				public Feld<	Zeitstempel
				> get30SpitzenStundeQKfzGesamtZeitPunkte() {
				return _30SpitzenStundeQKfzGesamtZeitPunkte;
			}
		
		
			/**
			Verkehrsstärke QKfzGesamt für die 50. belastete Spitzenstunde des Jahres.
			<p>
			
			</p>
			
			@return der Wert von 50SpitzenStundeQKfzGesamt.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 get50SpitzenStundeQKfzGesamt() {
				return _50SpitzenStundeQKfzGesamt;
			}
		
			/**
			Verkehrsstärke QKfzGesamt für die 50. belastete Spitzenstunde des Jahres.
			<p>
			
			</p>
			
			@param _50SpitzenStundeQKfzGesamt der neue Wert von 50SpitzenStundeQKfzGesamt.
			*/
			public void set50SpitzenStundeQKfzGesamt(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 _50SpitzenStundeQKfzGesamt) {
				this._50SpitzenStundeQKfzGesamt = _50SpitzenStundeQKfzGesamt;
			}
		
			/**
			Zeitpunkt für die 50. belastete Spitzenstunde des Jahres bezogen auf den Wert
									Verkehrsstärke QKfzGesamt.
			<p>
			
			</p>
			
			@return der Wert von 50SpitzenStundeQKfzGesamtZeitPunkte.
			*/
				public Feld<	Zeitstempel
				> get50SpitzenStundeQKfzGesamtZeitPunkte() {
				return _50SpitzenStundeQKfzGesamtZeitPunkte;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (get01SpitzenStundeQKfzGesamt() != null) {
		                if (get01SpitzenStundeQKfzGesamt().isZustand()) {
		                    datum.getUnscaledValue("01SpitzenStundeQKfzGesamt").setText(get01SpitzenStundeQKfzGesamt().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("01SpitzenStundeQKfzGesamt").set(get01SpitzenStundeQKfzGesamt().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						final Data.TimeArray array01SpitzenStundeQKfzGesamtZeitPunkte = datum.getTimeArray("01SpitzenStundeQKfzGesamtZeitPunkte");
						array01SpitzenStundeQKfzGesamtZeitPunkte.setLength(get01SpitzenStundeQKfzGesamtZeitPunkte().size());
						for (int i = 0; i < array01SpitzenStundeQKfzGesamtZeitPunkte.getLength(); ++i) {
							array01SpitzenStundeQKfzGesamtZeitPunkte.getTimeValue(i).setMillis(get01SpitzenStundeQKfzGesamtZeitPunkte().get(i).getTime());
						}
					// GanzzahlAttributTyp
					if (get30SpitzenStundeQKfzGesamt() != null) {
		                if (get30SpitzenStundeQKfzGesamt().isZustand()) {
		                    datum.getUnscaledValue("30SpitzenStundeQKfzGesamt").setText(get30SpitzenStundeQKfzGesamt().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("30SpitzenStundeQKfzGesamt").set(get30SpitzenStundeQKfzGesamt().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						final Data.TimeArray array30SpitzenStundeQKfzGesamtZeitPunkte = datum.getTimeArray("30SpitzenStundeQKfzGesamtZeitPunkte");
						array30SpitzenStundeQKfzGesamtZeitPunkte.setLength(get30SpitzenStundeQKfzGesamtZeitPunkte().size());
						for (int i = 0; i < array30SpitzenStundeQKfzGesamtZeitPunkte.getLength(); ++i) {
							array30SpitzenStundeQKfzGesamtZeitPunkte.getTimeValue(i).setMillis(get30SpitzenStundeQKfzGesamtZeitPunkte().get(i).getTime());
						}
					// GanzzahlAttributTyp
					if (get50SpitzenStundeQKfzGesamt() != null) {
		                if (get50SpitzenStundeQKfzGesamt().isZustand()) {
		                    datum.getUnscaledValue("50SpitzenStundeQKfzGesamt").setText(get50SpitzenStundeQKfzGesamt().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("50SpitzenStundeQKfzGesamt").set(get50SpitzenStundeQKfzGesamt().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						final Data.TimeArray array50SpitzenStundeQKfzGesamtZeitPunkte = datum.getTimeArray("50SpitzenStundeQKfzGesamtZeitPunkte");
						array50SpitzenStundeQKfzGesamtZeitPunkte.setLength(get50SpitzenStundeQKfzGesamtZeitPunkte().size());
						for (int i = 0; i < array50SpitzenStundeQKfzGesamtZeitPunkte.getLength(); ++i) {
							array50SpitzenStundeQKfzGesamtZeitPunkte.getTimeValue(i).setMillis(get50SpitzenStundeQKfzGesamtZeitPunkte().get(i).getTime());
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("01SpitzenStundeQKfzGesamt").isState()) {
								set01SpitzenStundeQKfzGesamt(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
								.getZustand(daten.getScaledValue("01SpitzenStundeQKfzGesamt").getText()));
							} else {
							set01SpitzenStundeQKfzGesamt(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
							(daten.
								getUnscaledValue
							("01SpitzenStundeQKfzGesamt").
									intValue
							()));
							}
					// ZeitstempelAttributTyp
						final Data.Array array01SpitzenStundeQKfzGesamtZeitPunkte = daten.getArray("01SpitzenStundeQKfzGesamtZeitPunkte");
						for (int i = 0; i < array01SpitzenStundeQKfzGesamtZeitPunkte.getLength(); ++i) {
								Zeitstempel
							 atl = new 	Zeitstempel
							 (array01SpitzenStundeQKfzGesamtZeitPunkte.getItem(i).asTimeValue().getMillis());
							get01SpitzenStundeQKfzGesamtZeitPunkte().add(atl);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("30SpitzenStundeQKfzGesamt").isState()) {
								set30SpitzenStundeQKfzGesamt(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
								.getZustand(daten.getScaledValue("30SpitzenStundeQKfzGesamt").getText()));
							} else {
							set30SpitzenStundeQKfzGesamt(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
							(daten.
								getUnscaledValue
							("30SpitzenStundeQKfzGesamt").
									intValue
							()));
							}
					// ZeitstempelAttributTyp
						final Data.Array array30SpitzenStundeQKfzGesamtZeitPunkte = daten.getArray("30SpitzenStundeQKfzGesamtZeitPunkte");
						for (int i = 0; i < array30SpitzenStundeQKfzGesamtZeitPunkte.getLength(); ++i) {
								Zeitstempel
							 atl = new 	Zeitstempel
							 (array30SpitzenStundeQKfzGesamtZeitPunkte.getItem(i).asTimeValue().getMillis());
							get30SpitzenStundeQKfzGesamtZeitPunkte().add(atl);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("50SpitzenStundeQKfzGesamt").isState()) {
								set50SpitzenStundeQKfzGesamt(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
								.getZustand(daten.getScaledValue("50SpitzenStundeQKfzGesamt").getText()));
							} else {
							set50SpitzenStundeQKfzGesamt(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
							(daten.
								getUnscaledValue
							("50SpitzenStundeQKfzGesamt").
									intValue
							()));
							}
					// ZeitstempelAttributTyp
						final Data.Array array50SpitzenStundeQKfzGesamtZeitPunkte = daten.getArray("50SpitzenStundeQKfzGesamtZeitPunkte");
						for (int i = 0; i < array50SpitzenStundeQKfzGesamtZeitPunkte.getLength(); ++i) {
								Zeitstempel
							 atl = new 	Zeitstempel
							 (array50SpitzenStundeQKfzGesamtZeitPunkte.getItem(i).asTimeValue().getMillis());
							get50SpitzenStundeQKfzGesamtZeitPunkte().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.set01SpitzenStundeQKfzGesamt(get01SpitzenStundeQKfzGesamt());
						klon._01SpitzenStundeQKfzGesamtZeitPunkte = get01SpitzenStundeQKfzGesamtZeitPunkte().clone();
							klon.set30SpitzenStundeQKfzGesamt(get30SpitzenStundeQKfzGesamt());
						klon._30SpitzenStundeQKfzGesamtZeitPunkte = get30SpitzenStundeQKfzGesamtZeitPunkte().clone();
							klon.set50SpitzenStundeQKfzGesamt(get50SpitzenStundeQKfzGesamt());
						klon._50SpitzenStundeQKfzGesamtZeitPunkte = get50SpitzenStundeQKfzGesamtZeitPunkte().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.verkehrsDatenLangZeitMSV";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdVerkehrsDatenLangZeitMSV(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
