/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parametersatz zur Steuerung des Abragemoduls für die
					LVE- und AXL-Daten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 24
 */
public class PdAbfrageModul extends AbstractParameterDatensatz<PdAbfrageModul.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerStunden1Bis
				 _lveAbfrageZyklus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten1Bis
				 _lveAbfrageOffset
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerStunden1Bis
				 _axlAbfrageZyklus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten1Bis
				 _axlAbfrageOffset
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Globales Abrufintervall in Stunden. Legt fest,
									wie oft Pufferabfrage für LVE stattfindet.
			<p>
			
			</p>
			
			@return der Wert von LveAbfrageZyklus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerStunden1Bis
				 getLveAbfrageZyklus() {
				return _lveAbfrageZyklus;
			}
		
			/**
			Globales Abrufintervall in Stunden. Legt fest,
									wie oft Pufferabfrage für LVE stattfindet.
			<p>
			
			</p>
			
			@param _lveAbfrageZyklus der neue Wert von LveAbfrageZyklus.
			*/
			public void setLveAbfrageZyklus(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerStunden1Bis
			 _lveAbfrageZyklus) {
				this._lveAbfrageZyklus = _lveAbfrageZyklus;
			}
		
			/**
			Globaler Abfrage-Offset in Minuten. Legt fest,
									wie viele Minuten nach einer vollen Stunde ein
									Abfrageauftrag für LVE-Daten für alle Stationen
									generiert wird.
			<p>
			
			</p>
			
			@return der Wert von LveAbfrageOffset.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten1Bis
				 getLveAbfrageOffset() {
				return _lveAbfrageOffset;
			}
		
			/**
			Globaler Abfrage-Offset in Minuten. Legt fest,
									wie viele Minuten nach einer vollen Stunde ein
									Abfrageauftrag für LVE-Daten für alle Stationen
									generiert wird.
			<p>
			
			</p>
			
			@param _lveAbfrageOffset der neue Wert von LveAbfrageOffset.
			*/
			public void setLveAbfrageOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten1Bis
			 _lveAbfrageOffset) {
				this._lveAbfrageOffset = _lveAbfrageOffset;
			}
		
			/**
			Globales Abrufintervall in Stunden. Legt fest,
									wie oft Pufferabfrage für Achslastdaten
									stattfindet.
			<p>
			
			</p>
			
			@return der Wert von AxlAbfrageZyklus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerStunden1Bis
				 getAxlAbfrageZyklus() {
				return _axlAbfrageZyklus;
			}
		
			/**
			Globales Abrufintervall in Stunden. Legt fest,
									wie oft Pufferabfrage für Achslastdaten
									stattfindet.
			<p>
			
			</p>
			
			@param _axlAbfrageZyklus der neue Wert von AxlAbfrageZyklus.
			*/
			public void setAxlAbfrageZyklus(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerStunden1Bis
			 _axlAbfrageZyklus) {
				this._axlAbfrageZyklus = _axlAbfrageZyklus;
			}
		
			/**
			Globaler Abfrage-Offset in Minuten. Legt fest,
									wie viele Minuten nach einer vollen Stunde ein
									Abfrageauftrag für Achslastdaten für alle
									Stationen generiert wird.
			<p>
			
			</p>
			
			@return der Wert von AxlAbfrageOffset.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten1Bis
				 getAxlAbfrageOffset() {
				return _axlAbfrageOffset;
			}
		
			/**
			Globaler Abfrage-Offset in Minuten. Legt fest,
									wie viele Minuten nach einer vollen Stunde ein
									Abfrageauftrag für Achslastdaten für alle
									Stationen generiert wird.
			<p>
			
			</p>
			
			@param _axlAbfrageOffset der neue Wert von AxlAbfrageOffset.
			*/
			public void setAxlAbfrageOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten1Bis
			 _axlAbfrageOffset) {
				this._axlAbfrageOffset = _axlAbfrageOffset;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getLveAbfrageZyklus() != null) {
		                if (getLveAbfrageZyklus().isZustand()) {
		                    datum.getUnscaledValue("LveAbfrageZyklus").setText(getLveAbfrageZyklus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LveAbfrageZyklus").set(getLveAbfrageZyklus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLveAbfrageOffset() != null) {
		                if (getLveAbfrageOffset().isZustand()) {
		                    datum.getUnscaledValue("LveAbfrageOffset").setText(getLveAbfrageOffset().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LveAbfrageOffset").set(getLveAbfrageOffset().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAxlAbfrageZyklus() != null) {
		                if (getAxlAbfrageZyklus().isZustand()) {
		                    datum.getUnscaledValue("AxlAbfrageZyklus").setText(getAxlAbfrageZyklus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AxlAbfrageZyklus").set(getAxlAbfrageZyklus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAxlAbfrageOffset() != null) {
		                if (getAxlAbfrageOffset().isZustand()) {
		                    datum.getUnscaledValue("AxlAbfrageOffset").setText(getAxlAbfrageOffset().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AxlAbfrageOffset").set(getAxlAbfrageOffset().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LveAbfrageZyklus").isState()) {
								setLveAbfrageZyklus(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerStunden1Bis
								.getZustand(daten.getScaledValue("LveAbfrageZyklus").getText()));
							} else {
							setLveAbfrageZyklus(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerStunden1Bis
							(daten.
								getUnscaledValue
							("LveAbfrageZyklus").
									longValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LveAbfrageOffset").isState()) {
								setLveAbfrageOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten1Bis
								.getZustand(daten.getScaledValue("LveAbfrageOffset").getText()));
							} else {
							setLveAbfrageOffset(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten1Bis
							(daten.
								getUnscaledValue
							("LveAbfrageOffset").
									longValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AxlAbfrageZyklus").isState()) {
								setAxlAbfrageZyklus(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerStunden1Bis
								.getZustand(daten.getScaledValue("AxlAbfrageZyklus").getText()));
							} else {
							setAxlAbfrageZyklus(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerStunden1Bis
							(daten.
								getUnscaledValue
							("AxlAbfrageZyklus").
									longValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AxlAbfrageOffset").isState()) {
								setAxlAbfrageOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten1Bis
								.getZustand(daten.getScaledValue("AxlAbfrageOffset").getText()));
							} else {
							setAxlAbfrageOffset(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten1Bis
							(daten.
								getUnscaledValue
							("AxlAbfrageOffset").
									longValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setLveAbfrageZyklus(getLveAbfrageZyklus());
							klon.setLveAbfrageOffset(getLveAbfrageOffset());
							klon.setAxlAbfrageZyklus(getAxlAbfrageZyklus());
							klon.setAxlAbfrageOffset(getAxlAbfrageOffset());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.abfrageModul";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdAbfrageModul(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
