/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Globale Modellparameter für die Constraintberechnung
					eines Teilnetzes.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 24
 */
public class PdConstraintModell extends AbstractParameterDatensatz<PdConstraintModell.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private 	RelativerZeitstempel
				 _loesungszeit
				;
				private 	RelativerZeitstempel
				 _zyklusZeitMessung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _anzVorgehaltenerZeitZyklen
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _anzBerechnungsZyklus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _anzErgebnisZyklen
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _anzRelaxationsSchritteTypB
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 _intervallVergroesserungSchritt1
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 _wachstumsRate
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Maximalzeit, die der Lösungsroutine zur
									Verfügung steht.
			<p>
			
			</p>
			
			@return der Wert von Loesungszeit.
			*/
				public 	RelativerZeitstempel
				 getLoesungszeit() {
				return _loesungszeit;
			}
		
			/**
			Maximalzeit, die der Lösungsroutine zur
									Verfügung steht.
			<p>
			
			</p>
			
			@param _loesungszeit der neue Wert von Loesungszeit.
			*/
			public void setLoesungszeit(	RelativerZeitstempel
			 _loesungszeit) {
				this._loesungszeit = _loesungszeit;
			}
		
			/**
			Zykluszeit der Messung.
			<p>
			
			</p>
			
			@return der Wert von ZyklusZeitMessung.
			*/
				public 	RelativerZeitstempel
				 getZyklusZeitMessung() {
				return _zyklusZeitMessung;
			}
		
			/**
			Zykluszeit der Messung.
			<p>
			
			</p>
			
			@param _zyklusZeitMessung der neue Wert von ZyklusZeitMessung.
			*/
			public void setZyklusZeitMessung(	RelativerZeitstempel
			 _zyklusZeitMessung) {
				this._zyklusZeitMessung = _zyklusZeitMessung;
			}
		
			/**
			Anzahl parallel vorgehaltener Zeitzyklen.
			<p>
			
			</p>
			
			@return der Wert von AnzVorgehaltenerZeitZyklen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getAnzVorgehaltenerZeitZyklen() {
				return _anzVorgehaltenerZeitZyklen;
			}
		
			/**
			Anzahl parallel vorgehaltener Zeitzyklen.
			<p>
			
			</p>
			
			@param _anzVorgehaltenerZeitZyklen der neue Wert von AnzVorgehaltenerZeitZyklen.
			*/
			public void setAnzVorgehaltenerZeitZyklen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _anzVorgehaltenerZeitZyklen) {
				this._anzVorgehaltenerZeitZyklen = _anzVorgehaltenerZeitZyklen;
			}
		
			/**
			Berechnungszyklus (muss kleiner als Anzahl der
									parallel vorgehaltenen Zeitzyklen sein).
			<p>
			
			</p>
			
			@return der Wert von AnzBerechnungsZyklus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getAnzBerechnungsZyklus() {
				return _anzBerechnungsZyklus;
			}
		
			/**
			Berechnungszyklus (muss kleiner als Anzahl der
									parallel vorgehaltenen Zeitzyklen sein).
			<p>
			
			</p>
			
			@param _anzBerechnungsZyklus der neue Wert von AnzBerechnungsZyklus.
			*/
			public void setAnzBerechnungsZyklus(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _anzBerechnungsZyklus) {
				this._anzBerechnungsZyklus = _anzBerechnungsZyklus;
			}
		
			/**
			Zahl der ausgelesenen Ergebniszyklen (aktueller
									und vorhergehende Zyklen, muss kleiner oder
									gleich der Berechnungszyklen sein).
			<p>
			
			</p>
			
			@return der Wert von AnzErgebnisZyklen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getAnzErgebnisZyklen() {
				return _anzErgebnisZyklen;
			}
		
			/**
			Zahl der ausgelesenen Ergebniszyklen (aktueller
									und vorhergehende Zyklen, muss kleiner oder
									gleich der Berechnungszyklen sein).
			<p>
			
			</p>
			
			@param _anzErgebnisZyklen der neue Wert von AnzErgebnisZyklen.
			*/
			public void setAnzErgebnisZyklen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _anzErgebnisZyklen) {
				this._anzErgebnisZyklen = _anzErgebnisZyklen;
			}
		
			/**
			Anzahl der erlaubten Relaxationsschritte vom Typ
									B .
			<p>
			
			</p>
			
			@return der Wert von AnzRelaxationsSchritteTypB.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getAnzRelaxationsSchritteTypB() {
				return _anzRelaxationsSchritteTypB;
			}
		
			/**
			Anzahl der erlaubten Relaxationsschritte vom Typ
									B .
			<p>
			
			</p>
			
			@param _anzRelaxationsSchritteTypB der neue Wert von AnzRelaxationsSchritteTypB.
			*/
			public void setAnzRelaxationsSchritteTypB(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _anzRelaxationsSchritteTypB) {
				this._anzRelaxationsSchritteTypB = _anzRelaxationsSchritteTypB;
			}
		
			/**
			Intervallvergrößerung der Dichte beim 1.
									Relaxationsversuch vom Typ B.
			<p>
			
			</p>
			
			@return der Wert von IntervallVergroesserungSchritt1.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 getIntervallVergroesserungSchritt1() {
				return _intervallVergroesserungSchritt1;
			}
		
			/**
			Intervallvergrößerung der Dichte beim 1.
									Relaxationsversuch vom Typ B.
			<p>
			
			</p>
			
			@param _intervallVergroesserungSchritt1 der neue Wert von IntervallVergroesserungSchritt1.
			*/
			public void setIntervallVergroesserungSchritt1(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 _intervallVergroesserungSchritt1) {
				this._intervallVergroesserungSchritt1 = _intervallVergroesserungSchritt1;
			}
		
			/**
			Wachstumsrate bei der Intervallvergrößerung der
									Dichte beim 1. Relaxationsversuch vom Typ B.
			<p>
			
			</p>
			
			@return der Wert von WachstumsRate.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 getWachstumsRate() {
				return _wachstumsRate;
			}
		
			/**
			Wachstumsrate bei der Intervallvergrößerung der
									Dichte beim 1. Relaxationsversuch vom Typ B.
			<p>
			
			</p>
			
			@param _wachstumsRate der neue Wert von WachstumsRate.
			*/
			public void setWachstumsRate(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _wachstumsRate) {
				this._wachstumsRate = _wachstumsRate;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeitstempelAttributTyp
						datum.getTimeValue("Lösungszeit").setMillis(getLoesungszeit().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("ZyklusZeitMessung").setMillis(getZyklusZeitMessung().getTime());
					// GanzzahlAttributTyp
					if (getAnzVorgehaltenerZeitZyklen() != null) {
		                if (getAnzVorgehaltenerZeitZyklen().isZustand()) {
		                    datum.getUnscaledValue("AnzVorgehaltenerZeitZyklen").setText(getAnzVorgehaltenerZeitZyklen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnzVorgehaltenerZeitZyklen").set(getAnzVorgehaltenerZeitZyklen().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnzBerechnungsZyklus() != null) {
		                if (getAnzBerechnungsZyklus().isZustand()) {
		                    datum.getUnscaledValue("AnzBerechnungsZyklus").setText(getAnzBerechnungsZyklus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnzBerechnungsZyklus").set(getAnzBerechnungsZyklus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnzErgebnisZyklen() != null) {
		                if (getAnzErgebnisZyklen().isZustand()) {
		                    datum.getUnscaledValue("AnzErgebnisZyklen").setText(getAnzErgebnisZyklen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnzErgebnisZyklen").set(getAnzErgebnisZyklen().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnzRelaxationsSchritteTypB() != null) {
		                if (getAnzRelaxationsSchritteTypB().isZustand()) {
		                    datum.getUnscaledValue("AnzRelaxationsSchritteTypB").setText(getAnzRelaxationsSchritteTypB().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnzRelaxationsSchritteTypB").set(getAnzRelaxationsSchritteTypB().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getIntervallVergroesserungSchritt1() != null) {
		                if (getIntervallVergroesserungSchritt1().isZustand()) {
		                    datum.getUnscaledValue("IntervallVergrößerungSchritt1").setText(getIntervallVergroesserungSchritt1().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("IntervallVergrößerungSchritt1").set(getIntervallVergroesserungSchritt1().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getWachstumsRate() != null) {
		                if (getWachstumsRate().isZustand()) {
		                    datum.getUnscaledValue("WachstumsRate").setText(getWachstumsRate().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("WachstumsRate").set(getWachstumsRate().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeitstempelAttributTyp
						setLoesungszeit(new
							RelativerZeitstempel
							(daten.getTimeValue("Lösungszeit").getMillis()));
					// ZeitstempelAttributTyp
						setZyklusZeitMessung(new
							RelativerZeitstempel
							(daten.getTimeValue("ZyklusZeitMessung").getMillis()));
					// GanzzahlAttributTyp
							setAnzVorgehaltenerZeitZyklen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("AnzVorgehaltenerZeitZyklen").
									longValue
							()));
					// GanzzahlAttributTyp
							setAnzBerechnungsZyklus(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("AnzBerechnungsZyklus").
									longValue
							()));
					// GanzzahlAttributTyp
							setAnzErgebnisZyklen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("AnzErgebnisZyklen").
									longValue
							()));
					// GanzzahlAttributTyp
							setAnzRelaxationsSchritteTypB(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("AnzRelaxationsSchritteTypB").
									longValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("IntervallVergrößerungSchritt1").isState()) {
								setIntervallVergroesserungSchritt1(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
								.getZustand(daten.getScaledValue("IntervallVergrößerungSchritt1").getText()));
							} else {
							setIntervallVergroesserungSchritt1(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
							(daten.
								getUnscaledValue
							("IntervallVergrößerungSchritt1").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("WachstumsRate").isState()) {
								setWachstumsRate(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
								.getZustand(daten.getScaledValue("WachstumsRate").getText()));
							} else {
							setWachstumsRate(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							(daten.
								getUnscaledValue
							("WachstumsRate").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setLoesungszeit(getLoesungszeit());
							klon.setZyklusZeitMessung(getZyklusZeitMessung());
							klon.setAnzVorgehaltenerZeitZyklen(getAnzVorgehaltenerZeitZyklen());
							klon.setAnzBerechnungsZyklus(getAnzBerechnungsZyklus());
							klon.setAnzErgebnisZyklen(getAnzErgebnisZyklen());
							klon.setAnzRelaxationsSchritteTypB(getAnzRelaxationsSchritteTypB());
							klon.setIntervallVergroesserungSchritt1(getIntervallVergroesserungSchritt1());
							klon.setWachstumsRate(getWachstumsRate());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.constraintModell";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdConstraintModell(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
