/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter der MessStellenGruppe für die
					Langzeitfehlererkennung von Verkehrsdaten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 29
 */
public class PdParameterMessStellenGruppe extends AbstractParameterDatensatz<PdParameterMessStellenGruppe.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttKurzzeitIntervallAnteilStunde
				 _vergleichsIntervallKurzZeit
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
				 _maxAbweichungVorgaengerKurzZeit
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
				 _maxAbweichungMessStellenGruppeKurzZeit
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStundenIntervallAnteileTag
				 _vergleichsIntervallLangZeit
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
				 _maxAbweichungVorgaengerLangZeit
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
				 _maxAbweichungMessStellenGruppeLangZeit
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Kurzzeit-Vergleichsintervall für die
									Langzeitfehlererkennung von Verkehrsdaten.
			<p>
			
			</p>
			
			@return der Wert von VergleichsIntervallKurzZeit.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttKurzzeitIntervallAnteilStunde
				 getVergleichsIntervallKurzZeit() {
				return _vergleichsIntervallKurzZeit;
			}
		
			/**
			Kurzzeit-Vergleichsintervall für die
									Langzeitfehlererkennung von Verkehrsdaten.
			<p>
			
			</p>
			
			@param _vergleichsIntervallKurzZeit der neue Wert von VergleichsIntervallKurzZeit.
			*/
			public void setVergleichsIntervallKurzZeit(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttKurzzeitIntervallAnteilStunde
			 _vergleichsIntervallKurzZeit) {
				this._vergleichsIntervallKurzZeit = _vergleichsIntervallKurzZeit;
			}
		
			/**
			Maximal zulässige Toleranz für die Abweichung
									von Messwerten beim Vergleich mit dem Vorgänger
									beim Kurzzeitintervall für die
									Langzeitfehlererkennung von Verkehrsdaten.
			<p>
			
			</p>
			
			@return der Wert von MaxAbweichungVorgaengerKurzZeit.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
				 getMaxAbweichungVorgaengerKurzZeit() {
				return _maxAbweichungVorgaengerKurzZeit;
			}
		
			/**
			Maximal zulässige Toleranz für die Abweichung
									von Messwerten beim Vergleich mit dem Vorgänger
									beim Kurzzeitintervall für die
									Langzeitfehlererkennung von Verkehrsdaten.
			<p>
			
			</p>
			
			@param _maxAbweichungVorgaengerKurzZeit der neue Wert von MaxAbweichungVorgaengerKurzZeit.
			*/
			public void setMaxAbweichungVorgaengerKurzZeit(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
			 _maxAbweichungVorgaengerKurzZeit) {
				this._maxAbweichungVorgaengerKurzZeit = _maxAbweichungVorgaengerKurzZeit;
			}
		
			/**
			Maximal zulässige Toleranz für die Abweichung
									von Messwerten beim Vergleich mit den Werten der
									MessStellenGruppe beim Kurzzeitintervall für die
									Langzeitfehlererkennung von Verkehrsdaten.
			<p>
			
			</p>
			
			@return der Wert von MaxAbweichungMessStellenGruppeKurzZeit.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
				 getMaxAbweichungMessStellenGruppeKurzZeit() {
				return _maxAbweichungMessStellenGruppeKurzZeit;
			}
		
			/**
			Maximal zulässige Toleranz für die Abweichung
									von Messwerten beim Vergleich mit den Werten der
									MessStellenGruppe beim Kurzzeitintervall für die
									Langzeitfehlererkennung von Verkehrsdaten.
			<p>
			
			</p>
			
			@param _maxAbweichungMessStellenGruppeKurzZeit der neue Wert von MaxAbweichungMessStellenGruppeKurzZeit.
			*/
			public void setMaxAbweichungMessStellenGruppeKurzZeit(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
			 _maxAbweichungMessStellenGruppeKurzZeit) {
				this._maxAbweichungMessStellenGruppeKurzZeit = _maxAbweichungMessStellenGruppeKurzZeit;
			}
		
			/**
			Langzeit-Vergleichsintervall für die
									Langzeitfehlererkennung von Verkehrsdaten.
			<p>
			
			</p>
			
			@return der Wert von VergleichsIntervallLangZeit.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStundenIntervallAnteileTag
				 getVergleichsIntervallLangZeit() {
				return _vergleichsIntervallLangZeit;
			}
		
			/**
			Langzeit-Vergleichsintervall für die
									Langzeitfehlererkennung von Verkehrsdaten.
			<p>
			
			</p>
			
			@param _vergleichsIntervallLangZeit der neue Wert von VergleichsIntervallLangZeit.
			*/
			public void setVergleichsIntervallLangZeit(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStundenIntervallAnteileTag
			 _vergleichsIntervallLangZeit) {
				this._vergleichsIntervallLangZeit = _vergleichsIntervallLangZeit;
			}
		
			/**
			Maximal zulässige Toleranz für die Abweichung
									von Messwerten beim Vergleich mit dem Vorgänger
									beim Langzeitintervall für die
									Langzeitfehlererkennung von Verkehrsdaten.
			<p>
			
			</p>
			
			@return der Wert von MaxAbweichungVorgaengerLangZeit.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
				 getMaxAbweichungVorgaengerLangZeit() {
				return _maxAbweichungVorgaengerLangZeit;
			}
		
			/**
			Maximal zulässige Toleranz für die Abweichung
									von Messwerten beim Vergleich mit dem Vorgänger
									beim Langzeitintervall für die
									Langzeitfehlererkennung von Verkehrsdaten.
			<p>
			
			</p>
			
			@param _maxAbweichungVorgaengerLangZeit der neue Wert von MaxAbweichungVorgaengerLangZeit.
			*/
			public void setMaxAbweichungVorgaengerLangZeit(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
			 _maxAbweichungVorgaengerLangZeit) {
				this._maxAbweichungVorgaengerLangZeit = _maxAbweichungVorgaengerLangZeit;
			}
		
			/**
			Maximal zulässige Toleranz für die Abweichung
									von Messwerten beim Vergleich mit den Werten der
									MessStellenGruppe beim Langzeitintervall für die
									Langzeitfehlererkennung von Verkehrsdaten.
			<p>
			
			</p>
			
			@return der Wert von MaxAbweichungMessStellenGruppeLangZeit.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
				 getMaxAbweichungMessStellenGruppeLangZeit() {
				return _maxAbweichungMessStellenGruppeLangZeit;
			}
		
			/**
			Maximal zulässige Toleranz für die Abweichung
									von Messwerten beim Vergleich mit den Werten der
									MessStellenGruppe beim Langzeitintervall für die
									Langzeitfehlererkennung von Verkehrsdaten.
			<p>
			
			</p>
			
			@param _maxAbweichungMessStellenGruppeLangZeit der neue Wert von MaxAbweichungMessStellenGruppeLangZeit.
			*/
			public void setMaxAbweichungMessStellenGruppeLangZeit(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
			 _maxAbweichungMessStellenGruppeLangZeit) {
				this._maxAbweichungMessStellenGruppeLangZeit = _maxAbweichungMessStellenGruppeLangZeit;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getVergleichsIntervallKurzZeit() != null) {
		                if (getVergleichsIntervallKurzZeit().isZustand()) {
		                    datum.getUnscaledValue("VergleichsIntervallKurzZeit").setText(getVergleichsIntervallKurzZeit().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VergleichsIntervallKurzZeit").set(getVergleichsIntervallKurzZeit().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxAbweichungVorgaengerKurzZeit() != null) {
		                if (getMaxAbweichungVorgaengerKurzZeit().isZustand()) {
		                    datum.getUnscaledValue("maxAbweichungVorgängerKurzZeit").setText(getMaxAbweichungVorgaengerKurzZeit().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("maxAbweichungVorgängerKurzZeit").set(getMaxAbweichungVorgaengerKurzZeit().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxAbweichungMessStellenGruppeKurzZeit() != null) {
		                if (getMaxAbweichungMessStellenGruppeKurzZeit().isZustand()) {
		                    datum.getUnscaledValue("maxAbweichungMessStellenGruppeKurzZeit").setText(getMaxAbweichungMessStellenGruppeKurzZeit().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("maxAbweichungMessStellenGruppeKurzZeit").set(getMaxAbweichungMessStellenGruppeKurzZeit().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVergleichsIntervallLangZeit() != null) {
		                if (getVergleichsIntervallLangZeit().isZustand()) {
		                    datum.getUnscaledValue("VergleichsIntervallLangZeit").setText(getVergleichsIntervallLangZeit().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VergleichsIntervallLangZeit").set(getVergleichsIntervallLangZeit().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxAbweichungVorgaengerLangZeit() != null) {
		                if (getMaxAbweichungVorgaengerLangZeit().isZustand()) {
		                    datum.getUnscaledValue("maxAbweichungVorgängerLangZeit").setText(getMaxAbweichungVorgaengerLangZeit().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("maxAbweichungVorgängerLangZeit").set(getMaxAbweichungVorgaengerLangZeit().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxAbweichungMessStellenGruppeLangZeit() != null) {
		                if (getMaxAbweichungMessStellenGruppeLangZeit().isZustand()) {
		                    datum.getUnscaledValue("maxAbweichungMessStellenGruppeLangZeit").setText(getMaxAbweichungMessStellenGruppeLangZeit().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("maxAbweichungMessStellenGruppeLangZeit").set(getMaxAbweichungMessStellenGruppeLangZeit().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VergleichsIntervallKurzZeit").isState()) {
								setVergleichsIntervallKurzZeit(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttKurzzeitIntervallAnteilStunde
								.getZustand(daten.getScaledValue("VergleichsIntervallKurzZeit").getText()));
							} else {
							setVergleichsIntervallKurzZeit(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttKurzzeitIntervallAnteilStunde
							(daten.
								getUnscaledValue
							("VergleichsIntervallKurzZeit").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("maxAbweichungVorgängerKurzZeit").isState()) {
								setMaxAbweichungVorgaengerKurzZeit(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
								.getZustand(daten.getScaledValue("maxAbweichungVorgängerKurzZeit").getText()));
							} else {
							setMaxAbweichungVorgaengerKurzZeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
							(daten.
								getUnscaledValue
							("maxAbweichungVorgängerKurzZeit").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("maxAbweichungMessStellenGruppeKurzZeit").isState()) {
								setMaxAbweichungMessStellenGruppeKurzZeit(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
								.getZustand(daten.getScaledValue("maxAbweichungMessStellenGruppeKurzZeit").getText()));
							} else {
							setMaxAbweichungMessStellenGruppeKurzZeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
							(daten.
								getUnscaledValue
							("maxAbweichungMessStellenGruppeKurzZeit").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VergleichsIntervallLangZeit").isState()) {
								setVergleichsIntervallLangZeit(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStundenIntervallAnteileTag
								.getZustand(daten.getScaledValue("VergleichsIntervallLangZeit").getText()));
							} else {
							setVergleichsIntervallLangZeit(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStundenIntervallAnteileTag
							(daten.
								getUnscaledValue
							("VergleichsIntervallLangZeit").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("maxAbweichungVorgängerLangZeit").isState()) {
								setMaxAbweichungVorgaengerLangZeit(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
								.getZustand(daten.getScaledValue("maxAbweichungVorgängerLangZeit").getText()));
							} else {
							setMaxAbweichungVorgaengerLangZeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
							(daten.
								getUnscaledValue
							("maxAbweichungVorgängerLangZeit").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("maxAbweichungMessStellenGruppeLangZeit").isState()) {
								setMaxAbweichungMessStellenGruppeLangZeit(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
								.getZustand(daten.getScaledValue("maxAbweichungMessStellenGruppeLangZeit").getText()));
							} else {
							setMaxAbweichungMessStellenGruppeLangZeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
							(daten.
								getUnscaledValue
							("maxAbweichungMessStellenGruppeLangZeit").
									intValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setVergleichsIntervallKurzZeit(getVergleichsIntervallKurzZeit());
							klon.setMaxAbweichungVorgaengerKurzZeit(getMaxAbweichungVorgaengerKurzZeit());
							klon.setMaxAbweichungMessStellenGruppeKurzZeit(getMaxAbweichungMessStellenGruppeKurzZeit());
							klon.setVergleichsIntervallLangZeit(getVergleichsIntervallLangZeit());
							klon.setMaxAbweichungVorgaengerLangZeit(getMaxAbweichungVorgaengerLangZeit());
							klon.setMaxAbweichungMessStellenGruppeLangZeit(getMaxAbweichungMessStellenGruppeLangZeit());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.parameterMessStellenGruppe";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdParameterMessStellenGruppe(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
