/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Aktuelle Eigenschaften eines Situationsobjekts.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 33
 */
public class PdSituationsEigenschaften extends AbstractParameterDatensatz<PdSituationsEigenschaften.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private 	Zeitstempel
				 _startZeit
				;
				@Defaultwert(wert = "0 ms")
				private 	RelativerZeitstempel
				 _dauer
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment
				> _strassenSegment = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 _startOffset
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 _endOffset
				;
				@Defaultwert(wert = "nicht ermittelbar")
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 _laenge
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Startzeitpunkt der Situation (Staubeginn,
									Baustellenbeginn, etc.).
			<p>
			
			</p>
			
			@return der Wert von StartZeit.
			*/
				public 	Zeitstempel
				 getStartZeit() {
				return _startZeit;
			}
		
			/**
			Startzeitpunkt der Situation (Staubeginn,
									Baustellenbeginn, etc.).
			<p>
			
			</p>
			
			@param _startZeit der neue Wert von StartZeit.
			*/
			public void setStartZeit(	Zeitstempel
			 _startZeit) {
				this._startZeit = _startZeit;
			}
		
			/**
			Dauer des Situation (sofern bekannt). Eintrag
									von 0 ms bedeutet unbekannte (unendliche) Dauer.
			<p>
			
			</p>
			
			@return der Wert von Dauer.
			*/
				public 	RelativerZeitstempel
				 getDauer() {
				return _dauer;
			}
		
			/**
			Dauer des Situation (sofern bekannt). Eintrag
									von 0 ms bedeutet unbekannte (unendliche) Dauer.
			<p>
			
			</p>
			
			@param _dauer der neue Wert von Dauer.
			*/
			public void setDauer(	RelativerZeitstempel
			 _dauer) {
				this._dauer = _dauer;
			}
		
			/**
			Referenzen auf alle Straßensegmente, über die
									sich die Situation ausbreitet.
			<p>
			
			</p>
			
			@return der Wert von StrassenSegment.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment
				> getStrassenSegment() {
				return _strassenSegment;
			}
		
		
			/**
			Position des Situationsanfangs im ersten
									Straßensegment.
			<p>
			
			</p>
			
			@return der Wert von StartOffset.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 getStartOffset() {
				return _startOffset;
			}
		
			/**
			Position des Situationsanfangs im ersten
									Straßensegment.
			<p>
			
			</p>
			
			@param _startOffset der neue Wert von StartOffset.
			*/
			public void setStartOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _startOffset) {
				this._startOffset = _startOffset;
			}
		
			/**
			Position des Situationsendes im letzten
									Straßensegment.
			<p>
			
			</p>
			
			@return der Wert von EndOffset.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 getEndOffset() {
				return _endOffset;
			}
		
			/**
			Position des Situationsendes im letzten
									Straßensegment.
			<p>
			
			</p>
			
			@param _endOffset der neue Wert von EndOffset.
			*/
			public void setEndOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _endOffset) {
				this._endOffset = _endOffset;
			}
		
			/**
			Länge der Situation über alle StraßenSegmente unter Berücksichtigung der Offsets.
			<p>
			Länge der Situation über alle StraßenSegmente unter Berücksichtigung der Offsets.
									Für Anzeige der Länge, z. B. in der Kartendarstellung ohne nochmalige Berechnung der Länge durch
									den Datenempfänger.
									Durch den Default-Wert ist dieses Attribut abwärtskompatibel (keine Exception beim Versenden,
									wenn nicht initialisiert).
			</p>
			
			@return der Wert von Laenge.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 getLaenge() {
				return _laenge;
			}
		
			/**
			Länge der Situation über alle StraßenSegmente unter Berücksichtigung der Offsets.
			<p>
			Länge der Situation über alle StraßenSegmente unter Berücksichtigung der Offsets.
									Für Anzeige der Länge, z. B. in der Kartendarstellung ohne nochmalige Berechnung der Länge durch
									den Datenempfänger.
									Durch den Default-Wert ist dieses Attribut abwärtskompatibel (keine Exception beim Versenden,
									wenn nicht initialisiert).
			</p>
			
			@param _laenge der neue Wert von Laenge.
			*/
			public void setLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _laenge) {
				this._laenge = _laenge;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeitstempelAttributTyp
						datum.getTimeValue("StartZeit").setMillis(getStartZeit().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("Dauer").setMillis(getDauer().getTime());
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayStrassenSegment = datum.getReferenceArray("StraßenSegment");
						arrayStrassenSegment.setLength(getStrassenSegment().size());
						for (int i = 0; i < arrayStrassenSegment.getLength(); ++i) {
							final Object soStrassenSegment = getStrassenSegment().get(i);
							final SystemObject tmpStrassenSegment;
							if (soStrassenSegment instanceof SystemObject) {
								tmpStrassenSegment = (SystemObject)soStrassenSegment;
							} else if(soStrassenSegment instanceof SystemObjekt){
								tmpStrassenSegment = ((SystemObjekt)soStrassenSegment).getSystemObject();
							} else{
								tmpStrassenSegment = null;
							}
							arrayStrassenSegment.getReferenceValue(i).setSystemObject(tmpStrassenSegment);
						}
					// GanzzahlAttributTyp
					if (getStartOffset() != null) {
		                if (getStartOffset().isZustand()) {
		                    datum.getUnscaledValue("StartOffset").setText(getStartOffset().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("StartOffset").set(getStartOffset().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getEndOffset() != null) {
		                if (getEndOffset().isZustand()) {
		                    datum.getUnscaledValue("EndOffset").setText(getEndOffset().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EndOffset").set(getEndOffset().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLaenge() != null) {
		                if (getLaenge().isZustand()) {
		                    datum.getUnscaledValue("Länge").setText(getLaenge().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Länge").set(getLaenge().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeitstempelAttributTyp
						setStartZeit(new
							Zeitstempel
							(daten.getTimeValue("StartZeit").getMillis()));
					// ZeitstempelAttributTyp
						setDauer(new
							RelativerZeitstempel
							(daten.getTimeValue("Dauer").getMillis()));
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayStrassenSegment = daten.getReferenceArray("StraßenSegment");
						for (int i = 0; i < arrayStrassenSegment.getLength(); ++i) {
							final long idStrassenSegment = daten.getReferenceArray("StraßenSegment").getReferenceValue(i).getId();
							final SystemObjekt tmpStrassenSegment;
							if (idStrassenSegment == 0) {
								tmpStrassenSegment = null;
							} else {
								final SystemObject soStrassenSegment = factory.getDav().getDataModel().getObject(idStrassenSegment);
								if (soStrassenSegment == null) {
										tmpStrassenSegment = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.StrassenSegmentUngueltig(idStrassenSegment);
								} else {
									tmpStrassenSegment = factory.getModellobjekt(soStrassenSegment);
								}
							}
								getStrassenSegment().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment
								) tmpStrassenSegment);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("StartOffset").isState()) {
								setStartOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
								.getZustand(daten.getScaledValue("StartOffset").getText()));
							} else {
							setStartOffset(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							(daten.
								getUnscaledValue
							("StartOffset").
									longValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("EndOffset").isState()) {
								setEndOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
								.getZustand(daten.getScaledValue("EndOffset").getText()));
							} else {
							setEndOffset(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							(daten.
								getUnscaledValue
							("EndOffset").
									longValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Länge").isState()) {
								setLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
								.getZustand(daten.getScaledValue("Länge").getText()));
							} else {
							setLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							(daten.
								getUnscaledValue
							("Länge").
									longValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setStartZeit(getStartZeit());
							klon.setDauer(getDauer());
						klon._strassenSegment = getStrassenSegment().clone();
							klon.setStartOffset(getStartOffset());
							klon.setEndOffset(getEndOffset());
							klon.setLaenge(getLaenge());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.situationsEigenschaften";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdSituationsEigenschaften(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
