/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Modellparameter für die Stauverlaufsprognose.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 24
 */
public class PdStauPrognoseModell extends AbstractParameterDatensatz<PdStauPrognoseModell.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private 	RelativerZeitstempel
				 _prognoseHorizont
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _aktualisierungsIntervall
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 _faktorQ0
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 _laengePkw
				;
				private 	RelativerZeitstempel
				 _daempfungsZeit
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Prognosehorizont der Stauverlaufsprognose.
			<p>
			
			</p>
			
			@return der Wert von PrognoseHorizont.
			*/
				public 	RelativerZeitstempel
				 getPrognoseHorizont() {
				return _prognoseHorizont;
			}
		
			/**
			Prognosehorizont der Stauverlaufsprognose.
			<p>
			
			</p>
			
			@param _prognoseHorizont der neue Wert von PrognoseHorizont.
			*/
			public void setPrognoseHorizont(	RelativerZeitstempel
			 _prognoseHorizont) {
				this._prognoseHorizont = _prognoseHorizont;
			}
		
			/**
			Anzahl der Prognoseiterationen je Zyklus der
									Stauobjektbestimmung.
			<p>
			
			</p>
			
			@return der Wert von AktualisierungsIntervall.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getAktualisierungsIntervall() {
				return _aktualisierungsIntervall;
			}
		
			/**
			Anzahl der Prognoseiterationen je Zyklus der
									Stauobjektbestimmung.
			<p>
			
			</p>
			
			@param _aktualisierungsIntervall der neue Wert von AktualisierungsIntervall.
			*/
			public void setAktualisierungsIntervall(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _aktualisierungsIntervall) {
				this._aktualisierungsIntervall = _aktualisierungsIntervall;
			}
		
			/**
			Faktor für die Anpassung von Q0 aus dem
									Fundamentaldiagramm.
			<p>
			
			</p>
			
			@return der Wert von FaktorQ0.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 getFaktorQ0() {
				return _faktorQ0;
			}
		
			/**
			Faktor für die Anpassung von Q0 aus dem
									Fundamentaldiagramm.
			<p>
			
			</p>
			
			@param _faktorQ0 der neue Wert von FaktorQ0.
			*/
			public void setFaktorQ0(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _faktorQ0) {
				this._faktorQ0 = _faktorQ0;
			}
		
			/**
			Strecke, die ein Pkw im Stau beansprucht.
			<p>
			
			</p>
			
			@return der Wert von LaengePkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 getLaengePkw() {
				return _laengePkw;
			}
		
			/**
			Strecke, die ein Pkw im Stau beansprucht.
			<p>
			
			</p>
			
			@param _laengePkw der neue Wert von LaengePkw.
			*/
			public void setLaengePkw(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _laengePkw) {
				this._laengePkw = _laengePkw;
			}
		
			/**
			Zeit, die bei der Bestimmung der Verkehrsstärke
									von Anschlussstellen im Stau fü die lineare
									Dämpfung vom aktuellen Messwert zur
									Prognoseganglinie verwendet wird.
			<p>
			
			</p>
			
			@return der Wert von DaempfungsZeit.
			*/
				public 	RelativerZeitstempel
				 getDaempfungsZeit() {
				return _daempfungsZeit;
			}
		
			/**
			Zeit, die bei der Bestimmung der Verkehrsstärke
									von Anschlussstellen im Stau fü die lineare
									Dämpfung vom aktuellen Messwert zur
									Prognoseganglinie verwendet wird.
			<p>
			
			</p>
			
			@param _daempfungsZeit der neue Wert von DaempfungsZeit.
			*/
			public void setDaempfungsZeit(	RelativerZeitstempel
			 _daempfungsZeit) {
				this._daempfungsZeit = _daempfungsZeit;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeitstempelAttributTyp
						datum.getTimeValue("PrognoseHorizont").setMillis(getPrognoseHorizont().getTime());
					// GanzzahlAttributTyp
					if (getAktualisierungsIntervall() != null) {
		                if (getAktualisierungsIntervall().isZustand()) {
		                    datum.getUnscaledValue("AktualisierungsIntervall").setText(getAktualisierungsIntervall().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AktualisierungsIntervall").set(getAktualisierungsIntervall().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFaktorQ0() != null) {
		                if (getFaktorQ0().isZustand()) {
		                    datum.getUnscaledValue("FaktorQ0").setText(getFaktorQ0().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FaktorQ0").set(getFaktorQ0().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLaengePkw() != null) {
		                if (getLaengePkw().isZustand()) {
		                    datum.getUnscaledValue("LängePkw").setText(getLaengePkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LängePkw").set(getLaengePkw().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("DämpfungsZeit").setMillis(getDaempfungsZeit().getTime());
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeitstempelAttributTyp
						setPrognoseHorizont(new
							RelativerZeitstempel
							(daten.getTimeValue("PrognoseHorizont").getMillis()));
					// GanzzahlAttributTyp
							setAktualisierungsIntervall(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("AktualisierungsIntervall").
									longValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FaktorQ0").isState()) {
								setFaktorQ0(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
								.getZustand(daten.getScaledValue("FaktorQ0").getText()));
							} else {
							setFaktorQ0(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							(daten.
								getUnscaledValue
							("FaktorQ0").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LängePkw").isState()) {
								setLaengePkw(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
								.getZustand(daten.getScaledValue("LängePkw").getText()));
							} else {
							setLaengePkw(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							(daten.
								getUnscaledValue
							("LängePkw").
									longValue
							()));
							}
					// ZeitstempelAttributTyp
						setDaempfungsZeit(new
							RelativerZeitstempel
							(daten.getTimeValue("DämpfungsZeit").getMillis()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setPrognoseHorizont(getPrognoseHorizont());
							klon.setAktualisierungsIntervall(getAktualisierungsIntervall());
							klon.setFaktorQ0(getFaktorQ0());
							klon.setLaengePkw(getLaengePkw());
							klon.setDaempfungsZeit(getDaempfungsZeit());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.stauPrognoseModell";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdStauPrognoseModell(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
