/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für Analysedaten bei Kurzzeitdaten
					Verkehr.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 24
 */
public class PdVerkehrsDatenKurzZeitAnalyseFs extends AbstractParameterDatensatz<PdVerkehrsDatenKurzZeitAnalyseFs.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGrenzMaxFahrzeugDichte
				 _kKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGrenzMaxFahrzeugDichte
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGrenzMaxFahrzeugDichte
				 _kLkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGrenzMaxFahrzeugDichte
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGrenzMaxFahrzeugDichte
				 _kPkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGrenzMaxFahrzeugDichte
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGrenzMaxBemessungsFahrzeugDichte
				 _kB
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGrenzMaxBemessungsFahrzeugDichte
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlAequivalenzFaktorLkw
				 _fl
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlAequivalenzFaktorLkw
				()
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Parametersatz für die Analysewertberechnung von
									kKfz.
			<p>
			
			</p>
			
			@return der Wert von KKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGrenzMaxFahrzeugDichte
				 getKKfz() {
				return _kKfz;
			}
		
			/**
			Parametersatz für die Analysewertberechnung von
									kKfz.
			<p>
			
			</p>
			
			@param _kKfz der neue Wert von KKfz.
			*/
			public void setKKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGrenzMaxFahrzeugDichte
			 _kKfz) {
				this._kKfz = _kKfz;
			}
		
			/**
			Parametersatz für die Analysewertberechnung von
									kLkw.
			<p>
			
			</p>
			
			@return der Wert von KLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGrenzMaxFahrzeugDichte
				 getKLkw() {
				return _kLkw;
			}
		
			/**
			Parametersatz für die Analysewertberechnung von
									kLkw.
			<p>
			
			</p>
			
			@param _kLkw der neue Wert von KLkw.
			*/
			public void setKLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGrenzMaxFahrzeugDichte
			 _kLkw) {
				this._kLkw = _kLkw;
			}
		
			/**
			Parametersatz für die Analysewertberechnung von
									kPkw.
			<p>
			
			</p>
			
			@return der Wert von KPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGrenzMaxFahrzeugDichte
				 getKPkw() {
				return _kPkw;
			}
		
			/**
			Parametersatz für die Analysewertberechnung von
									kPkw.
			<p>
			
			</p>
			
			@param _kPkw der neue Wert von KPkw.
			*/
			public void setKPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGrenzMaxFahrzeugDichte
			 _kPkw) {
				this._kPkw = _kPkw;
			}
		
			/**
			Parametersatz für die Analysewertberechnung von
									kB.
			<p>
			
			</p>
			
			@return der Wert von KB.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGrenzMaxBemessungsFahrzeugDichte
				 getKB() {
				return _kB;
			}
		
			/**
			Parametersatz für die Analysewertberechnung von
									kB.
			<p>
			
			</p>
			
			@param _kB der neue Wert von KB.
			*/
			public void setKB(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGrenzMaxBemessungsFahrzeugDichte
			 _kB) {
				this._kB = _kB;
			}
		
			/**
			Parametersatz für die Analysewertberechnung des
									Aquivalenzfaktors für Lkw.
			<p>
			
			</p>
			
			@return der Wert von Fl.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlAequivalenzFaktorLkw
				 getFl() {
				return _fl;
			}
		
			/**
			Parametersatz für die Analysewertberechnung des
									Aquivalenzfaktors für Lkw.
			<p>
			
			</p>
			
			@param _fl der neue Wert von Fl.
			*/
			public void setFl(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlAequivalenzFaktorLkw
			 _fl) {
				this._fl = _fl;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// AttributListenDefinition
						getKKfz().bean2Atl(datum.getItem("kKfz"), factory);
					// AttributListenDefinition
						getKLkw().bean2Atl(datum.getItem("kLkw"), factory);
					// AttributListenDefinition
						getKPkw().bean2Atl(datum.getItem("kPkw"), factory);
					// AttributListenDefinition
						getKB().bean2Atl(datum.getItem("kB"), factory);
					// AttributListenDefinition
						getFl().bean2Atl(datum.getItem("fl"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// AttributListenDefinition
						getKKfz().atl2Bean(daten.getItem("kKfz"), factory);
					// AttributListenDefinition
						getKLkw().atl2Bean(daten.getItem("kLkw"), factory);
					// AttributListenDefinition
						getKPkw().atl2Bean(daten.getItem("kPkw"), factory);
					// AttributListenDefinition
						getKB().atl2Bean(daten.getItem("kB"), factory);
					// AttributListenDefinition
						getFl().atl2Bean(daten.getItem("fl"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon._kKfz = getKKfz().clone();
							klon._kLkw = getKLkw().clone();
							klon._kPkw = getKPkw().clone();
							klon._kB = getKB().clone();
							klon._fl = getFl().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.verkehrsDatenKurzZeitAnalyseFs";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdVerkehrsDatenKurzZeitAnalyseFs(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
