/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für PL-Prüfung logisch bei Kurzzeitdaten
					Verkehr.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 24
 */
public class PdVerkehrsDatenKurzZeitIntervallPlausibilitaetsPruefungLogisch extends AbstractParameterDatensatz<PdVerkehrsDatenKurzZeitIntervallPlausibilitaetsPruefungLogisch.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _vKfzGrenz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 _bGrenz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttOptionenPlausibilitaetsPruefungLogischVerkehr
				 _optionen
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qKfzBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qLkwBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qPkwBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _vKfzBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _vLkwBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _vPkwBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _vgKfzBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxProzent
				 _belegungBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxProzent
				()
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Grenzgeschwindigkeit für PL-Prüfung FG1 Verkehr. Ist dieser
									Wert überschritten, muss b kleiner bGrenz sein,
									sonst ist b implausibel.
			<p>
			
			</p>
			
			@return der Wert von VKfzGrenz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getVKfzGrenz() {
				return _vKfzGrenz;
			}
		
			/**
			Grenzgeschwindigkeit für PL-Prüfung FG1 Verkehr. Ist dieser
									Wert überschritten, muss b kleiner bGrenz sein,
									sonst ist b implausibel.
			<p>
			
			</p>
			
			@param _vKfzGrenz der neue Wert von VKfzGrenz.
			*/
			public void setVKfzGrenz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vKfzGrenz) {
				this._vKfzGrenz = _vKfzGrenz;
			}
		
			/**
			Ist vKfz größer als vKfzGrenz, so muss b kleiner
									bGrenz sein, sonst ist b implausibel.
			<p>
			
			</p>
			
			@return der Wert von BGrenz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 getBGrenz() {
				return _bGrenz;
			}
		
			/**
			Ist vKfz größer als vKfzGrenz, so muss b kleiner
									bGrenz sein, sonst ist b implausibel.
			<p>
			
			</p>
			
			@param _bGrenz der neue Wert von BGrenz.
			*/
			public void setBGrenz(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _bGrenz) {
				this._bGrenz = _bGrenz;
			}
		
			/**
			Legt das Verhalten für den Umgang mit geprüften
									Werten nach der Wertebereichsprüfung fest.
			<p>
			
			</p>
			
			@return der Wert von Optionen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttOptionenPlausibilitaetsPruefungLogischVerkehr
				 getOptionen() {
				return _optionen;
			}
		
			/**
			Legt das Verhalten für den Umgang mit geprüften
									Werten nach der Wertebereichsprüfung fest.
			<p>
			
			</p>
			
			@param _optionen der neue Wert von Optionen.
			*/
			public void setOptionen(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttOptionenPlausibilitaetsPruefungLogischVerkehr
			 _optionen) {
				this._optionen = _optionen;
			}
		
			/**
			Wertebereichsgrenzen für qKfz bei der logischen
									Plausibilitätsprüfung (Stundenwerte).
			<p>
			
			</p>
			
			@return der Wert von QKfzBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQKfzBereich() {
				return _qKfzBereich;
			}
		
			/**
			Wertebereichsgrenzen für qKfz bei der logischen
									Plausibilitätsprüfung (Stundenwerte).
			<p>
			
			</p>
			
			@param _qKfzBereich der neue Wert von QKfzBereich.
			*/
			public void setQKfzBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qKfzBereich) {
				this._qKfzBereich = _qKfzBereich;
			}
		
			/**
			Wertebereichsgrenzen für qLkw bei der logischen
									Plausibilitätsprüfung (Stundenwerte).
			<p>
			
			</p>
			
			@return der Wert von QLkwBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQLkwBereich() {
				return _qLkwBereich;
			}
		
			/**
			Wertebereichsgrenzen für qLkw bei der logischen
									Plausibilitätsprüfung (Stundenwerte).
			<p>
			
			</p>
			
			@param _qLkwBereich der neue Wert von QLkwBereich.
			*/
			public void setQLkwBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qLkwBereich) {
				this._qLkwBereich = _qLkwBereich;
			}
		
			/**
			Wertebereichsgrenzen für qPkw bei der logischen
									Plausibilitätsprüfung (Stundenwerte).
			<p>
			
			</p>
			
			@return der Wert von QPkwBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQPkwBereich() {
				return _qPkwBereich;
			}
		
			/**
			Wertebereichsgrenzen für qPkw bei der logischen
									Plausibilitätsprüfung (Stundenwerte).
			<p>
			
			</p>
			
			@param _qPkwBereich der neue Wert von QPkwBereich.
			*/
			public void setQPkwBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qPkwBereich) {
				this._qPkwBereich = _qPkwBereich;
			}
		
			/**
			Wertebereichsgrenzen für vKfz bei der logischen
									Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@return der Wert von VKfzBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getVKfzBereich() {
				return _vKfzBereich;
			}
		
			/**
			Wertebereichsgrenzen für vKfz bei der logischen
									Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@param _vKfzBereich der neue Wert von VKfzBereich.
			*/
			public void setVKfzBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _vKfzBereich) {
				this._vKfzBereich = _vKfzBereich;
			}
		
			/**
			Wertebereichsgrenzen für vLkwbei der logischen
									Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@return der Wert von VLkwBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getVLkwBereich() {
				return _vLkwBereich;
			}
		
			/**
			Wertebereichsgrenzen für vLkwbei der logischen
									Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@param _vLkwBereich der neue Wert von VLkwBereich.
			*/
			public void setVLkwBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _vLkwBereich) {
				this._vLkwBereich = _vLkwBereich;
			}
		
			/**
			Wertebereichsgrenzen für vPkw bei der logischen
									Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@return der Wert von VPkwBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getVPkwBereich() {
				return _vPkwBereich;
			}
		
			/**
			Wertebereichsgrenzen für vPkw bei der logischen
									Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@param _vPkwBereich der neue Wert von VPkwBereich.
			*/
			public void setVPkwBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _vPkwBereich) {
				this._vPkwBereich = _vPkwBereich;
			}
		
			/**
			Wertebereichsgrenzen für vgKfz bei der logischen
									Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@return der Wert von VgKfzBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getVgKfzBereich() {
				return _vgKfzBereich;
			}
		
			/**
			Wertebereichsgrenzen für vgKfz bei der logischen
									Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@param _vgKfzBereich der neue Wert von VgKfzBereich.
			*/
			public void setVgKfzBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _vgKfzBereich) {
				this._vgKfzBereich = _vgKfzBereich;
			}
		
			/**
			Wertebereichsgrenzen für b (Belegung) bei der
									logischen Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@return der Wert von BelegungBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxProzent
				 getBelegungBereich() {
				return _belegungBereich;
			}
		
			/**
			Wertebereichsgrenzen für b (Belegung) bei der
									logischen Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@param _belegungBereich der neue Wert von BelegungBereich.
			*/
			public void setBelegungBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxProzent
			 _belegungBereich) {
				this._belegungBereich = _belegungBereich;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getVKfzGrenz() != null) {
		                if (getVKfzGrenz().isZustand()) {
		                    datum.getUnscaledValue("vKfzGrenz").setText(getVKfzGrenz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vKfzGrenz").set(getVKfzGrenz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBGrenz() != null) {
		                if (getBGrenz().isZustand()) {
		                    datum.getUnscaledValue("bGrenz").setText(getBGrenz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("bGrenz").set(getBGrenz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getOptionen() != null) {
		                if (getOptionen().isZustand()) {
		                    datum.getUnscaledValue("Optionen").setText(getOptionen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Optionen").set(getOptionen().getValue());
		                }
					}
					// AttributListenDefinition
						getQKfzBereich().bean2Atl(datum.getItem("qKfzBereich"), factory);
					// AttributListenDefinition
						getQLkwBereich().bean2Atl(datum.getItem("qLkwBereich"), factory);
					// AttributListenDefinition
						getQPkwBereich().bean2Atl(datum.getItem("qPkwBereich"), factory);
					// AttributListenDefinition
						getVKfzBereich().bean2Atl(datum.getItem("vKfzBereich"), factory);
					// AttributListenDefinition
						getVLkwBereich().bean2Atl(datum.getItem("vLkwBereich"), factory);
					// AttributListenDefinition
						getVPkwBereich().bean2Atl(datum.getItem("vPkwBereich"), factory);
					// AttributListenDefinition
						getVgKfzBereich().bean2Atl(datum.getItem("vgKfzBereich"), factory);
					// AttributListenDefinition
						getBelegungBereich().bean2Atl(datum.getItem("BelegungBereich"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vKfzGrenz").isState()) {
								setVKfzGrenz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("vKfzGrenz").getText()));
							} else {
							setVKfzGrenz(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("vKfzGrenz").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("bGrenz").isState()) {
								setBGrenz(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
								.getZustand(daten.getScaledValue("bGrenz").getText()));
							} else {
							setBGrenz(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							(daten.
								getUnscaledValue
							("bGrenz").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Optionen").isState()) {
								setOptionen(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttOptionenPlausibilitaetsPruefungLogischVerkehr
								.getZustand(daten.getScaledValue("Optionen").getText()));
							} else {
							setOptionen(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttOptionenPlausibilitaetsPruefungLogischVerkehr
							(daten.
								getUnscaledValue
							("Optionen").
									byteValue
							()));
							}
					// AttributListenDefinition
						getQKfzBereich().atl2Bean(daten.getItem("qKfzBereich"), factory);
					// AttributListenDefinition
						getQLkwBereich().atl2Bean(daten.getItem("qLkwBereich"), factory);
					// AttributListenDefinition
						getQPkwBereich().atl2Bean(daten.getItem("qPkwBereich"), factory);
					// AttributListenDefinition
						getVKfzBereich().atl2Bean(daten.getItem("vKfzBereich"), factory);
					// AttributListenDefinition
						getVLkwBereich().atl2Bean(daten.getItem("vLkwBereich"), factory);
					// AttributListenDefinition
						getVPkwBereich().atl2Bean(daten.getItem("vPkwBereich"), factory);
					// AttributListenDefinition
						getVgKfzBereich().atl2Bean(daten.getItem("vgKfzBereich"), factory);
					// AttributListenDefinition
						getBelegungBereich().atl2Bean(daten.getItem("BelegungBereich"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setVKfzGrenz(getVKfzGrenz());
							klon.setBGrenz(getBGrenz());
							klon.setOptionen(getOptionen());
							klon._qKfzBereich = getQKfzBereich().clone();
							klon._qLkwBereich = getQLkwBereich().clone();
							klon._qPkwBereich = getQPkwBereich().clone();
							klon._vKfzBereich = getVKfzBereich().clone();
							klon._vLkwBereich = getVLkwBereich().clone();
							klon._vPkwBereich = getVPkwBereich().clone();
							klon._vgKfzBereich = getVgKfzBereich().clone();
							klon._belegungBereich = getBelegungBereich().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.verkehrsDatenKurzZeitIntervallPlausibilitätsPrüfungLogisch";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdVerkehrsDatenKurzZeitIntervallPlausibilitaetsPruefungLogisch(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
