/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für zeitlich"träge" trendextrapolierte
					Verkehrsprognosedaten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 34
 */
public class PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseTraegeMq extends AbstractParameterDatensatz<PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseTraegeMq.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 _qKfzStart
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _vKfzStart
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 _qLkwStart
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _vLkwStart
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 _qPkwStart
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _vPkwStart
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 _aLkwStart
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 _kKfzStart
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 _kLkwStart
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 _kPkwStart
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
				 _qBStart
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsFahrzeugDichte
				 _kBStart
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 _qKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 _vKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 _qLkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 _vLkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 _qPkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 _vPkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 _aLkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 _kKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 _kLkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 _kPkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 _qB
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 _kB
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				()
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@return der Wert von QKfzStart.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 getQKfzStart() {
				return _qKfzStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@param _qKfzStart der neue Wert von QKfzStart.
			*/
			public void setQKfzStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 _qKfzStart) {
				this._qKfzStart = _qKfzStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@return der Wert von VKfzStart.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getVKfzStart() {
				return _vKfzStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@param _vKfzStart der neue Wert von VKfzStart.
			*/
			public void setVKfzStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vKfzStart) {
				this._vKfzStart = _vKfzStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@return der Wert von QLkwStart.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 getQLkwStart() {
				return _qLkwStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@param _qLkwStart der neue Wert von QLkwStart.
			*/
			public void setQLkwStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 _qLkwStart) {
				this._qLkwStart = _qLkwStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@return der Wert von VLkwStart.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getVLkwStart() {
				return _vLkwStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@param _vLkwStart der neue Wert von VLkwStart.
			*/
			public void setVLkwStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vLkwStart) {
				this._vLkwStart = _vLkwStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@return der Wert von QPkwStart.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 getQPkwStart() {
				return _qPkwStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@param _qPkwStart der neue Wert von QPkwStart.
			*/
			public void setQPkwStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 _qPkwStart) {
				this._qPkwStart = _qPkwStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@return der Wert von VPkwStart.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getVPkwStart() {
				return _vPkwStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@param _vPkwStart der neue Wert von VPkwStart.
			*/
			public void setVPkwStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vPkwStart) {
				this._vPkwStart = _vPkwStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@return der Wert von ALkwStart.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 getALkwStart() {
				return _aLkwStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@param _aLkwStart der neue Wert von ALkwStart.
			*/
			public void setALkwStart(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _aLkwStart) {
				this._aLkwStart = _aLkwStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@return der Wert von KKfzStart.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 getKKfzStart() {
				return _kKfzStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@param _kKfzStart der neue Wert von KKfzStart.
			*/
			public void setKKfzStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 _kKfzStart) {
				this._kKfzStart = _kKfzStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@return der Wert von KLkwStart.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 getKLkwStart() {
				return _kLkwStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@param _kLkwStart der neue Wert von KLkwStart.
			*/
			public void setKLkwStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 _kLkwStart) {
				this._kLkwStart = _kLkwStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@return der Wert von KPkwStart.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 getKPkwStart() {
				return _kPkwStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@param _kPkwStart der neue Wert von KPkwStart.
			*/
			public void setKPkwStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 _kPkwStart) {
				this._kPkwStart = _kPkwStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@return der Wert von QBStart.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
				 getQBStart() {
				return _qBStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@param _qBStart der neue Wert von QBStart.
			*/
			public void setQBStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
			 _qBStart) {
				this._qBStart = _qBStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@return der Wert von KBStart.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsFahrzeugDichte
				 getKBStart() {
				return _kBStart;
			}
		
			/**
			Startwert für die Glättung.
			<p>
			
			</p>
			
			@param _kBStart der neue Wert von KBStart.
			*/
			public void setKBStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsFahrzeugDichte
			 _kBStart) {
				this._kBStart = _kBStart;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@return der Wert von QKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 getQKfz() {
				return _qKfz;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@param _qKfz der neue Wert von QKfz.
			*/
			public void setQKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
			 _qKfz) {
				this._qKfz = _qKfz;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@return der Wert von VKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 getVKfz() {
				return _vKfz;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@param _vKfz der neue Wert von VKfz.
			*/
			public void setVKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
			 _vKfz) {
				this._vKfz = _vKfz;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@return der Wert von QLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 getQLkw() {
				return _qLkw;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@param _qLkw der neue Wert von QLkw.
			*/
			public void setQLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
			 _qLkw) {
				this._qLkw = _qLkw;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@return der Wert von VLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 getVLkw() {
				return _vLkw;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@param _vLkw der neue Wert von VLkw.
			*/
			public void setVLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
			 _vLkw) {
				this._vLkw = _vLkw;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@return der Wert von QPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 getQPkw() {
				return _qPkw;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@param _qPkw der neue Wert von QPkw.
			*/
			public void setQPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
			 _qPkw) {
				this._qPkw = _qPkw;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@return der Wert von VPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 getVPkw() {
				return _vPkw;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@param _vPkw der neue Wert von VPkw.
			*/
			public void setVPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
			 _vPkw) {
				this._vPkw = _vPkw;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@return der Wert von ALkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 getALkw() {
				return _aLkw;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@param _aLkw der neue Wert von ALkw.
			*/
			public void setALkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
			 _aLkw) {
				this._aLkw = _aLkw;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@return der Wert von KKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 getKKfz() {
				return _kKfz;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@param _kKfz der neue Wert von KKfz.
			*/
			public void setKKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
			 _kKfz) {
				this._kKfz = _kKfz;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@return der Wert von KLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 getKLkw() {
				return _kLkw;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@param _kLkw der neue Wert von KLkw.
			*/
			public void setKLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
			 _kLkw) {
				this._kLkw = _kLkw;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@return der Wert von KPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 getKPkw() {
				return _kPkw;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@param _kPkw der neue Wert von KPkw.
			*/
			public void setKPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
			 _kPkw) {
				this._kPkw = _kPkw;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@return der Wert von QB.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 getQB() {
				return _qB;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@param _qB der neue Wert von QB.
			*/
			public void setQB(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
			 _qB) {
				this._qB = _qB;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@return der Wert von KB.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
				 getKB() {
				return _kB;
			}
		
			/**
			Parameterwerte für die Berechnung von
									geglätteten und trendextrapolierten Werten.
			<p>
			
			</p>
			
			@param _kB der neue Wert von KB.
			*/
			public void setKB(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlTrendExtraPolation
			 _kB) {
				this._kB = _kB;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getQKfzStart() != null) {
		                if (getQKfzStart().isZustand()) {
		                    datum.getUnscaledValue("QKfzStart").setText(getQKfzStart().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("QKfzStart").set(getQKfzStart().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVKfzStart() != null) {
		                if (getVKfzStart().isZustand()) {
		                    datum.getUnscaledValue("VKfzStart").setText(getVKfzStart().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VKfzStart").set(getVKfzStart().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQLkwStart() != null) {
		                if (getQLkwStart().isZustand()) {
		                    datum.getUnscaledValue("QLkwStart").setText(getQLkwStart().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("QLkwStart").set(getQLkwStart().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVLkwStart() != null) {
		                if (getVLkwStart().isZustand()) {
		                    datum.getUnscaledValue("VLkwStart").setText(getVLkwStart().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VLkwStart").set(getVLkwStart().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQPkwStart() != null) {
		                if (getQPkwStart().isZustand()) {
		                    datum.getUnscaledValue("QPkwStart").setText(getQPkwStart().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("QPkwStart").set(getQPkwStart().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVPkwStart() != null) {
		                if (getVPkwStart().isZustand()) {
		                    datum.getUnscaledValue("VPkwStart").setText(getVPkwStart().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VPkwStart").set(getVPkwStart().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getALkwStart() != null) {
		                if (getALkwStart().isZustand()) {
		                    datum.getUnscaledValue("ALkwStart").setText(getALkwStart().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ALkwStart").set(getALkwStart().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKKfzStart() != null) {
		                if (getKKfzStart().isZustand()) {
		                    datum.getUnscaledValue("KKfzStart").setText(getKKfzStart().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KKfzStart").set(getKKfzStart().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKLkwStart() != null) {
		                if (getKLkwStart().isZustand()) {
		                    datum.getUnscaledValue("KLkwStart").setText(getKLkwStart().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KLkwStart").set(getKLkwStart().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKPkwStart() != null) {
		                if (getKPkwStart().isZustand()) {
		                    datum.getUnscaledValue("KPkwStart").setText(getKPkwStart().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KPkwStart").set(getKPkwStart().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQBStart() != null) {
		                if (getQBStart().isZustand()) {
		                    datum.getUnscaledValue("QBStart").setText(getQBStart().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("QBStart").set(getQBStart().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKBStart() != null) {
		                if (getKBStart().isZustand()) {
		                    datum.getUnscaledValue("KBStart").setText(getKBStart().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KBStart").set(getKBStart().getValue());
		                }
					}
					// AttributListenDefinition
						getQKfz().bean2Atl(datum.getItem("QKfz"), factory);
					// AttributListenDefinition
						getVKfz().bean2Atl(datum.getItem("VKfz"), factory);
					// AttributListenDefinition
						getQLkw().bean2Atl(datum.getItem("QLkw"), factory);
					// AttributListenDefinition
						getVLkw().bean2Atl(datum.getItem("VLkw"), factory);
					// AttributListenDefinition
						getQPkw().bean2Atl(datum.getItem("QPkw"), factory);
					// AttributListenDefinition
						getVPkw().bean2Atl(datum.getItem("VPkw"), factory);
					// AttributListenDefinition
						getALkw().bean2Atl(datum.getItem("ALkw"), factory);
					// AttributListenDefinition
						getKKfz().bean2Atl(datum.getItem("KKfz"), factory);
					// AttributListenDefinition
						getKLkw().bean2Atl(datum.getItem("KLkw"), factory);
					// AttributListenDefinition
						getKPkw().bean2Atl(datum.getItem("KPkw"), factory);
					// AttributListenDefinition
						getQB().bean2Atl(datum.getItem("QB"), factory);
					// AttributListenDefinition
						getKB().bean2Atl(datum.getItem("KB"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("QKfzStart").isState()) {
								setQKfzStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
								.getZustand(daten.getScaledValue("QKfzStart").getText()));
							} else {
							setQKfzStart(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
							(daten.
								getUnscaledValue
							("QKfzStart").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VKfzStart").isState()) {
								setVKfzStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("VKfzStart").getText()));
							} else {
							setVKfzStart(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("VKfzStart").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("QLkwStart").isState()) {
								setQLkwStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
								.getZustand(daten.getScaledValue("QLkwStart").getText()));
							} else {
							setQLkwStart(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
							(daten.
								getUnscaledValue
							("QLkwStart").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VLkwStart").isState()) {
								setVLkwStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("VLkwStart").getText()));
							} else {
							setVLkwStart(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("VLkwStart").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("QPkwStart").isState()) {
								setQPkwStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
								.getZustand(daten.getScaledValue("QPkwStart").getText()));
							} else {
							setQPkwStart(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
							(daten.
								getUnscaledValue
							("QPkwStart").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VPkwStart").isState()) {
								setVPkwStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("VPkwStart").getText()));
							} else {
							setVPkwStart(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("VPkwStart").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ALkwStart").isState()) {
								setALkwStart(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
								.getZustand(daten.getScaledValue("ALkwStart").getText()));
							} else {
							setALkwStart(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							(daten.
								getUnscaledValue
							("ALkwStart").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("KKfzStart").isState()) {
								setKKfzStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
								.getZustand(daten.getScaledValue("KKfzStart").getText()));
							} else {
							setKKfzStart(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
							(daten.
								getUnscaledValue
							("KKfzStart").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("KLkwStart").isState()) {
								setKLkwStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
								.getZustand(daten.getScaledValue("KLkwStart").getText()));
							} else {
							setKLkwStart(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
							(daten.
								getUnscaledValue
							("KLkwStart").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("KPkwStart").isState()) {
								setKPkwStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
								.getZustand(daten.getScaledValue("KPkwStart").getText()));
							} else {
							setKPkwStart(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
							(daten.
								getUnscaledValue
							("KPkwStart").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("QBStart").isState()) {
								setQBStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
								.getZustand(daten.getScaledValue("QBStart").getText()));
							} else {
							setQBStart(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
							(daten.
								getUnscaledValue
							("QBStart").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("KBStart").isState()) {
								setKBStart(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsFahrzeugDichte
								.getZustand(daten.getScaledValue("KBStart").getText()));
							} else {
							setKBStart(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsFahrzeugDichte
							(daten.
								getUnscaledValue
							("KBStart").
									shortValue
							()));
							}
					// AttributListenDefinition
						getQKfz().atl2Bean(daten.getItem("QKfz"), factory);
					// AttributListenDefinition
						getVKfz().atl2Bean(daten.getItem("VKfz"), factory);
					// AttributListenDefinition
						getQLkw().atl2Bean(daten.getItem("QLkw"), factory);
					// AttributListenDefinition
						getVLkw().atl2Bean(daten.getItem("VLkw"), factory);
					// AttributListenDefinition
						getQPkw().atl2Bean(daten.getItem("QPkw"), factory);
					// AttributListenDefinition
						getVPkw().atl2Bean(daten.getItem("VPkw"), factory);
					// AttributListenDefinition
						getALkw().atl2Bean(daten.getItem("ALkw"), factory);
					// AttributListenDefinition
						getKKfz().atl2Bean(daten.getItem("KKfz"), factory);
					// AttributListenDefinition
						getKLkw().atl2Bean(daten.getItem("KLkw"), factory);
					// AttributListenDefinition
						getKPkw().atl2Bean(daten.getItem("KPkw"), factory);
					// AttributListenDefinition
						getQB().atl2Bean(daten.getItem("QB"), factory);
					// AttributListenDefinition
						getKB().atl2Bean(daten.getItem("KB"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setQKfzStart(getQKfzStart());
							klon.setVKfzStart(getVKfzStart());
							klon.setQLkwStart(getQLkwStart());
							klon.setVLkwStart(getVLkwStart());
							klon.setQPkwStart(getQPkwStart());
							klon.setVPkwStart(getVPkwStart());
							klon.setALkwStart(getALkwStart());
							klon.setKKfzStart(getKKfzStart());
							klon.setKLkwStart(getKLkwStart());
							klon.setKPkwStart(getKPkwStart());
							klon.setQBStart(getQBStart());
							klon.setKBStart(getKBStart());
							klon._qKfz = getQKfz().clone();
							klon._vKfz = getVKfz().clone();
							klon._qLkw = getQLkw().clone();
							klon._vLkw = getVLkw().clone();
							klon._qPkw = getQPkw().clone();
							klon._vPkw = getVPkw().clone();
							klon._aLkw = getALkw().clone();
							klon._kKfz = getKKfz().clone();
							klon._kLkw = getKLkw().clone();
							klon._kPkw = getKPkw().clone();
							klon._qB = getQB().clone();
							klon._kB = getKB().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.verkehrsDatenKurzZeitTrendExtraPolationPrognoseTrägeMq";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseTraegeMq(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
