/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
BenutzerMeldungsAnteil.
<p>
Notwender Anteil der Benutzermeldung
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class AtlBenutzerMeldungsAnteil implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _zeitstempel
			;
			private String
			 _meldungsText
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			()
			;
	
		/**
		Zeitstempel der InformationsMeldung.
		<p>
		
		</p>
		
		@return der Wert von Zeitstempel.
		*/
			public 	Zeitstempel
			 getZeitstempel() {
			return _zeitstempel;
		}
	
		/**
		Zeitstempel der InformationsMeldung.
		<p>
		
		</p>
		
		@param _zeitstempel der neue Wert von Zeitstempel.
		*/
		public void setZeitstempel(	Zeitstempel
		 _zeitstempel) {
			this._zeitstempel = _zeitstempel;
		}
	
		/**
		Text der Meldung.
		<p>
		
		</p>
		
		@return der Wert von MeldungsText.
		*/
			public String
			 getMeldungsText() {
			return _meldungsText;
		}
	
		/**
		Text der Meldung.
		<p>
		
		</p>
		
		@param _meldungsText der neue Wert von MeldungsText.
		*/
		public void setMeldungsText(String
		 _meldungsText) {
			if (_meldungsText.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._meldungsText = _meldungsText;
		}
	
		/**
		Urlasserinformation.
		<p>
		
		</p>
		
		@return der Wert von Urlasser.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 getUrlasser() {
			return _urlasser;
		}
	
		/**
		Urlasserinformation.
		<p>
		
		</p>
		
		@param _urlasser der neue Wert von Urlasser.
		*/
		public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
		 _urlasser) {
			this._urlasser = _urlasser;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Zeitstempel").setMillis(getZeitstempel().getTime());
				// ZeichenkettenAttributTyp
				if (getMeldungsText() != null) {
					datum.getTextValue("MeldungsText").setText(getMeldungsText());
				}
				// AttributListenDefinition
					getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setZeitstempel(new
						Zeitstempel
						(daten.getTimeValue("Zeitstempel").getMillis()));
				// ZeichenkettenAttributTyp
					setMeldungsText(daten.getTextValue("MeldungsText").getText());
				// AttributListenDefinition
					getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBenutzerMeldungsAnteil clone() {
		AtlBenutzerMeldungsAnteil klon = new AtlBenutzerMeldungsAnteil();
		
						klon.setZeitstempel(getZeitstempel());
						klon.setMeldungsText(getMeldungsText());
						klon._urlasser = getUrlasser().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
