/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Aktion.
<p>
Mit dieser Attributliste wird spezifiziert, welche Aktion durchgefuehrt wird, wenn die Filterbedingung erfuellt ist. Die Attributliste
					ist als Feld ausgelegt und somit koennen mehere Aktionen angegeben werden.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class AtlBetriebsMeldungsVerwaltungAktion implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttVewBetrAktion
			 _aktion
			;
			private Feld<String
			> _parameter = new Feld<String
			>(0, true);
	
		/**
		Mit diesem Attribut wird eine Aktion spezifiziert.
		<p>
		
		</p>
		
		@return der Wert von Aktion.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttVewBetrAktion
			 getAktion() {
			return _aktion;
		}
	
		/**
		Mit diesem Attribut wird eine Aktion spezifiziert.
		<p>
		
		</p>
		
		@param _aktion der neue Wert von Aktion.
		*/
		public void setAktion(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttVewBetrAktion
		 _aktion) {
			this._aktion = _aktion;
		}
	
		/**
		Mit diesem Attribut werden Parameter fuer die durchzufuehrende Aktion spezifiziert. Das Attribut ist als Feld ausgelegt und somit
								koennen mehere Werte angegeben werden.
		<p>
		
		</p>
		
		@return der Wert von Parameter.
		*/
			public Feld<String
			> getParameter() {
			return _parameter;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getAktion() != null) {
	                if (getAktion().isZustand()) {
	                    datum.getUnscaledValue("Aktion").setText(getAktion().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Aktion").set(getAktion().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getParameter() != null) {
					final Data.TextArray arrayParameter = datum.getTextArray("Parameter");
					arrayParameter.setLength(getParameter().size());
					for (int i = 0; i < arrayParameter.getLength(); ++i) {
						arrayParameter.getTextValue(i).setText(getParameter().get(i));
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Aktion").isState()) {
							setAktion(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttVewBetrAktion
							.getZustand(daten.getScaledValue("Aktion").getText()));
						} else {
						setAktion(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttVewBetrAktion
						(daten.
							getUnscaledValue
						("Aktion").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					final Data.TextArray arrayParameter = daten.getTextArray("Parameter");
					for (int i = 0; i < arrayParameter.getLength(); ++i) {
						getParameter().add(arrayParameter.getText(i));
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBetriebsMeldungsVerwaltungAktion clone() {
		AtlBetriebsMeldungsVerwaltungAktion klon = new AtlBetriebsMeldungsVerwaltungAktion();
		
						klon.setAktion(getAktion());
					klon._parameter = getParameter().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
