/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
InformationsMeldungsAnteil.
<p>
Notwender Anteil der Informationsmeldung
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class AtlInformationsMeldungsAnteil implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _zeitstempel
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsTyp
			 _meldungsTyp
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
			 _meldungsKlasse
			;
			private Feld<	Object
			> _referenz = new Feld<	Object
			>(1, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsStatus
			 _meldungsStatus
			;
			private String
			 _meldungsText
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			()
			;
	
		/**
		Zeitstempel der InformationsMeldung.
		<p>
		
		</p>
		
		@return der Wert von Zeitstempel.
		*/
			public 	Zeitstempel
			 getZeitstempel() {
			return _zeitstempel;
		}
	
		/**
		Zeitstempel der InformationsMeldung.
		<p>
		
		</p>
		
		@param _zeitstempel der neue Wert von Zeitstempel.
		*/
		public void setZeitstempel(	Zeitstempel
		 _zeitstempel) {
			this._zeitstempel = _zeitstempel;
		}
	
		/**
		Klassifizierung der Meldungen in unterschiedliche Typen.
		<p>
		
		</p>
		
		@return der Wert von MeldungsTyp.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsTyp
			 getMeldungsTyp() {
			return _meldungsTyp;
		}
	
		/**
		Klassifizierung der Meldungen in unterschiedliche Typen.
		<p>
		
		</p>
		
		@param _meldungsTyp der neue Wert von MeldungsTyp.
		*/
		public void setMeldungsTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsTyp
		 _meldungsTyp) {
			this._meldungsTyp = _meldungsTyp;
		}
	
		/**
		Hiermit ist die Klassifizierung einer Meldung in "Fatal", "Fehler", "Warnung", "Information" möglich.
		<p>
		
		</p>
		
		@return der Wert von MeldungsKlasse.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
			 getMeldungsKlasse() {
			return _meldungsKlasse;
		}
	
		/**
		Hiermit ist die Klassifizierung einer Meldung in "Fatal", "Fehler", "Warnung", "Information" möglich.
		<p>
		
		</p>
		
		@param _meldungsKlasse der neue Wert von MeldungsKlasse.
		*/
		public void setMeldungsKlasse(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
		 _meldungsKlasse) {
			this._meldungsKlasse = _meldungsKlasse;
		}
	
		/**
		Optionale Referenz auf ein Konfigurationsobjekt.
		<p>
		
		</p>
		
		@return der Wert von Referenz.
		*/
			public Feld<	Object
			> getReferenz() {
			return _referenz;
		}
	
	
		/**
		Flag das angibt ob es sich um eine Gutmeldung handelt.
		<p>
		
		</p>
		
		@return der Wert von MeldungsStatus.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsStatus
			 getMeldungsStatus() {
			return _meldungsStatus;
		}
	
		/**
		Flag das angibt ob es sich um eine Gutmeldung handelt.
		<p>
		
		</p>
		
		@param _meldungsStatus der neue Wert von MeldungsStatus.
		*/
		public void setMeldungsStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsStatus
		 _meldungsStatus) {
			this._meldungsStatus = _meldungsStatus;
		}
	
		/**
		Text der Meldung.
		<p>
		
		</p>
		
		@return der Wert von MeldungsText.
		*/
			public String
			 getMeldungsText() {
			return _meldungsText;
		}
	
		/**
		Text der Meldung.
		<p>
		
		</p>
		
		@param _meldungsText der neue Wert von MeldungsText.
		*/
		public void setMeldungsText(String
		 _meldungsText) {
			if (_meldungsText.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._meldungsText = _meldungsText;
		}
	
		/**
		Urlasserinformation.
		<p>
		
		</p>
		
		@return der Wert von Urlasser.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 getUrlasser() {
			return _urlasser;
		}
	
		/**
		Urlasserinformation.
		<p>
		
		</p>
		
		@param _urlasser der neue Wert von Urlasser.
		*/
		public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
		 _urlasser) {
			this._urlasser = _urlasser;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Zeitstempel").setMillis(getZeitstempel().getTime());
				// GanzzahlAttributTyp
				if (getMeldungsTyp() != null) {
	                if (getMeldungsTyp().isZustand()) {
	                    datum.getUnscaledValue("MeldungsTyp").setText(getMeldungsTyp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("MeldungsTyp").set(getMeldungsTyp().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getMeldungsKlasse() != null) {
	                if (getMeldungsKlasse().isZustand()) {
	                    datum.getUnscaledValue("MeldungsKlasse").setText(getMeldungsKlasse().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("MeldungsKlasse").set(getMeldungsKlasse().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayReferenz = datum.getReferenceArray("Referenz");
					arrayReferenz.setLength(getReferenz().size());
					for (int i = 0; i < arrayReferenz.getLength(); ++i) {
						final Object soReferenz = getReferenz().get(i);
						final SystemObject tmpReferenz;
						if (soReferenz instanceof SystemObject) {
							tmpReferenz = (SystemObject)soReferenz;
						} else if(soReferenz instanceof SystemObjekt){
							tmpReferenz = ((SystemObjekt)soReferenz).getSystemObject();
						} else{
							tmpReferenz = null;
						}
						arrayReferenz.getReferenceValue(i).setSystemObject(tmpReferenz);
					}
				// GanzzahlAttributTyp
				if (getMeldungsStatus() != null) {
	                if (getMeldungsStatus().isZustand()) {
	                    datum.getUnscaledValue("MeldungsStatus").setText(getMeldungsStatus().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("MeldungsStatus").set(getMeldungsStatus().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getMeldungsText() != null) {
					datum.getTextValue("MeldungsText").setText(getMeldungsText());
				}
				// AttributListenDefinition
					getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setZeitstempel(new
						Zeitstempel
						(daten.getTimeValue("Zeitstempel").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("MeldungsTyp").isState()) {
							setMeldungsTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsTyp
							.getZustand(daten.getScaledValue("MeldungsTyp").getText()));
						} else {
						setMeldungsTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsTyp
						(daten.
							getUnscaledValue
						("MeldungsTyp").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("MeldungsKlasse").isState()) {
							setMeldungsKlasse(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
							.getZustand(daten.getScaledValue("MeldungsKlasse").getText()));
						} else {
						setMeldungsKlasse(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
						(daten.
							getUnscaledValue
						("MeldungsKlasse").
								byteValue
						()));
						}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayReferenz = daten.getReferenceArray("Referenz");
					for (int i = 0; i < arrayReferenz.getLength(); ++i) {
						final long idReferenz = daten.getReferenceArray("Referenz").getReferenceValue(i).getId();
						final SystemObjekt tmpReferenz;
						if (idReferenz == 0) {
							tmpReferenz = null;
						} else {
							final SystemObject soReferenz = factory.getDav().getDataModel().getObject(idReferenz);
							if (soReferenz == null) {
									tmpReferenz = new BaseUngueltigesSystemObjekt(idReferenz);
							} else {
								tmpReferenz = factory.getModellobjekt(soReferenz);
							}
						}
							getReferenz().add((	Object
							) tmpReferenz);
					}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("MeldungsStatus").isState()) {
							setMeldungsStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsStatus
							.getZustand(daten.getScaledValue("MeldungsStatus").getText()));
						} else {
						setMeldungsStatus(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsStatus
						(daten.
							getUnscaledValue
						("MeldungsStatus").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setMeldungsText(daten.getTextValue("MeldungsText").getText());
				// AttributListenDefinition
					getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlInformationsMeldungsAnteil clone() {
		AtlInformationsMeldungsAnteil klon = new AtlInformationsMeldungsAnteil();
		
						klon.setZeitstempel(getZeitstempel());
						klon.setMeldungsTyp(getMeldungsTyp());
						klon.setMeldungsKlasse(getMeldungsKlasse());
					klon._referenz = getReferenz().clone();
						klon.setMeldungsStatus(getMeldungsStatus());
						klon.setMeldungsText(getMeldungsText());
						klon._urlasser = getUrlasser().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
