/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition einer Operation für den Filter.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class AttVewBetrOperation extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttVewBetrOperation ZUSTAND_0_WERT_IST_GLEICH = new AttVewBetrOperation("Wert ist gleich", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVewBetrOperation ZUSTAND_1_WERT_IST_KLEINER = new AttVewBetrOperation("Wert ist kleiner", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVewBetrOperation ZUSTAND_2_WERT_IST_GROESSER = new AttVewBetrOperation("Wert ist größer", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVewBetrOperation ZUSTAND_3_WERT_IST_KLEINER_ODER_GLEICH = new AttVewBetrOperation("Wert ist kleiner oder gleich", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVewBetrOperation ZUSTAND_4_WERT_IST_GROESSER_ODER_GLEICH = new AttVewBetrOperation("Wert ist größer oder gleich", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVewBetrOperation ZUSTAND_5_TEXT_GLEICH = new AttVewBetrOperation("Text gleich", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVewBetrOperation ZUSTAND_6_TEXT_ENTHAELT = new AttVewBetrOperation("Text enthält", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVewBetrOperation ZUSTAND_7_TEXT_BEGINNT_MIT = new AttVewBetrOperation("Text beginnt mit", 		Byte
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVewBetrOperation ZUSTAND_8_TEXT_ENDET_MIT = new AttVewBetrOperation("Text endet mit", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVewBetrOperation ZUSTAND_9_KEIN_OPERATOR = new AttVewBetrOperation("kein Operator", 		Byte
	.valueOf("9"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttVewBetrOperation getZustand(final 		Byte
	 value) {
		for (AttVewBetrOperation e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttVewBetrOperation getZustand(final String value) {
		for (AttVewBetrOperation e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttVewBetrOperation> getZustaende() {
		List<AttVewBetrOperation> list = new ArrayList<AttVewBetrOperation>();
		list.add(ZUSTAND_0_WERT_IST_GLEICH);
		list.add(ZUSTAND_1_WERT_IST_KLEINER);
		list.add(ZUSTAND_2_WERT_IST_GROESSER);
		list.add(ZUSTAND_3_WERT_IST_KLEINER_ODER_GLEICH);
		list.add(ZUSTAND_4_WERT_IST_GROESSER_ODER_GLEICH);
		list.add(ZUSTAND_5_TEXT_GLEICH);
		list.add(ZUSTAND_6_TEXT_ENTHAELT);
		list.add(ZUSTAND_7_TEXT_BEGINNT_MIT);
		list.add(ZUSTAND_8_TEXT_ENDET_MIT);
		list.add(ZUSTAND_9_KEIN_OPERATOR);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut VewBetrOperation.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttVewBetrOperation(final 		Byte
	 value) {
		super(value);
	}
	
	private AttVewBetrOperation(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
