/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parametrierbare Eigenschaften einer Melddung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class PdMeldung extends AbstractParameterDatensatz<PdMeldung.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Zustand,
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Zustand.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Zustand = new Aspekte("Zustand", "asp.zustand");
			
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttWichtigkeit
				 _wichtigkeit
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttStatus
				 _status
				;
				private 	Zeitstempel
				 _wiedervorlage
				;
				private String
				 _ergaenzungstext
				= new String
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlInformationsMeldungsAnteil
				> _informationsMeldungsAnteil = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlInformationsMeldungsAnteil
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlBenutzerMeldungsAnteil
				> _benutzerMeldungsAnteil = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlBenutzerMeldungsAnteil
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
		
			/**
			Dringlichkeit einer Meldung.
			<p>
			&lt;absatz&gt;
										hiermit ist eine Unterscheidung nach der Dringlichkeit der Meldung möglich.
										Ein Wert zwischen 10(sehr Dringend) und 0 (keine Dringlichkeit) ist möglich
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von Wichtigkeit.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttWichtigkeit
				 getWichtigkeit() {
				return _wichtigkeit;
			}
		
			/**
			Dringlichkeit einer Meldung.
			<p>
			&lt;absatz&gt;
										hiermit ist eine Unterscheidung nach der Dringlichkeit der Meldung möglich.
										Ein Wert zwischen 10(sehr Dringend) und 0 (keine Dringlichkeit) ist möglich
									&lt;&#47;absatz&gt;
			</p>
			
			@param _wichtigkeit der neue Wert von Wichtigkeit.
			*/
			public void setWichtigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttWichtigkeit
			 _wichtigkeit) {
				this._wichtigkeit = _wichtigkeit;
			}
		
			/**
			Status der Meldung.
			<p>
			&lt;absatz&gt;
										"neu", "in Bearbeitung", "Wiedervorlage", "erledigt
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von Status.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttStatus
				 getStatus() {
				return _status;
			}
		
			/**
			Status der Meldung.
			<p>
			&lt;absatz&gt;
										"neu", "in Bearbeitung", "Wiedervorlage", "erledigt
									&lt;&#47;absatz&gt;
			</p>
			
			@param _status der neue Wert von Status.
			*/
			public void setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttStatus
			 _status) {
				this._status = _status;
			}
		
			/**
			Zeitpunkt an dem die Meldung erneut vorgelegt (verschickt) werden soll.
			<p>
			
			</p>
			
			@return der Wert von Wiedervorlage.
			*/
				public 	Zeitstempel
				 getWiedervorlage() {
				return _wiedervorlage;
			}
		
			/**
			Zeitpunkt an dem die Meldung erneut vorgelegt (verschickt) werden soll.
			<p>
			
			</p>
			
			@param _wiedervorlage der neue Wert von Wiedervorlage.
			*/
			public void setWiedervorlage(	Zeitstempel
			 _wiedervorlage) {
				this._wiedervorlage = _wiedervorlage;
			}
		
			/**
			Ergänzender Text zur Meldung.
			<p>
			
			</p>
			
			@return der Wert von Ergaenzungstext.
			*/
				public String
				 getErgaenzungstext() {
				return _ergaenzungstext;
			}
		
			/**
			Ergänzender Text zur Meldung.
			<p>
			
			</p>
			
			@param _ergaenzungstext der neue Wert von Ergaenzungstext.
			*/
			public void setErgaenzungstext(String
			 _ergaenzungstext) {
				if (_ergaenzungstext.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._ergaenzungstext = _ergaenzungstext;
			}
		
			/**
			InformationsMeldungsAnteil.
			<p>
			Notwender Anteil der Informationsmeldung
			</p>
			
			@return der Wert von InformationsMeldungsAnteil.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlInformationsMeldungsAnteil
				> getInformationsMeldungsAnteil() {
				return _informationsMeldungsAnteil;
			}
		
		
			/**
			BenutzerMeldungsAnteil.
			<p>
			Notwender Anteil der Benutzermeldung
			</p>
			
			@return der Wert von BenutzerMeldungsAnteil.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlBenutzerMeldungsAnteil
				> getBenutzerMeldungsAnteil() {
				return _benutzerMeldungsAnteil;
			}
		
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getWichtigkeit() != null) {
		                if (getWichtigkeit().isZustand()) {
		                    datum.getUnscaledValue("Wichtigkeit").setText(getWichtigkeit().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Wichtigkeit").set(getWichtigkeit().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getStatus() != null) {
		                if (getStatus().isZustand()) {
		                    datum.getUnscaledValue("Status").setText(getStatus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Status").set(getStatus().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("Wiedervorlage").setMillis(getWiedervorlage().getTime());
					// ZeichenkettenAttributTyp
					if (getErgaenzungstext() != null) {
						datum.getTextValue("Ergänzungstext").setText(getErgaenzungstext());
					}
					// AttributListenDefinition
						final Data.Array arrayInformationsMeldungsAnteil = datum.getArray("InformationsMeldungsAnteil");
						arrayInformationsMeldungsAnteil.setLength(getInformationsMeldungsAnteil().size());
						for (int i = 0; i < arrayInformationsMeldungsAnteil.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlInformationsMeldungsAnteil
							 atl = getInformationsMeldungsAnteil().get(i);
							atl.bean2Atl(arrayInformationsMeldungsAnteil.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayBenutzerMeldungsAnteil = datum.getArray("BenutzerMeldungsAnteil");
						arrayBenutzerMeldungsAnteil.setLength(getBenutzerMeldungsAnteil().size());
						for (int i = 0; i < arrayBenutzerMeldungsAnteil.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlBenutzerMeldungsAnteil
							 atl = getBenutzerMeldungsAnteil().get(i);
							atl.bean2Atl(arrayBenutzerMeldungsAnteil.getItem(i), factory);
		
						}
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Wichtigkeit").isState()) {
								setWichtigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttWichtigkeit
								.getZustand(daten.getScaledValue("Wichtigkeit").getText()));
							} else {
							setWichtigkeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttWichtigkeit
							(daten.
								getUnscaledValue
							("Wichtigkeit").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Status").isState()) {
								setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttStatus
								.getZustand(daten.getScaledValue("Status").getText()));
							} else {
							setStatus(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttStatus
							(daten.
								getUnscaledValue
							("Status").
									byteValue
							()));
							}
					// ZeitstempelAttributTyp
						setWiedervorlage(new
							Zeitstempel
							(daten.getTimeValue("Wiedervorlage").getMillis()));
					// ZeichenkettenAttributTyp
						setErgaenzungstext(daten.getTextValue("Ergänzungstext").getText());
					// AttributListenDefinition
						final Data.Array arrayInformationsMeldungsAnteil = daten.getArray("InformationsMeldungsAnteil");
						for (int i = 0; i < arrayInformationsMeldungsAnteil.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlInformationsMeldungsAnteil
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlInformationsMeldungsAnteil
							 ();
							atl.atl2Bean(arrayInformationsMeldungsAnteil.getItem(i), factory);
							getInformationsMeldungsAnteil().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayBenutzerMeldungsAnteil = daten.getArray("BenutzerMeldungsAnteil");
						for (int i = 0; i < arrayBenutzerMeldungsAnteil.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlBenutzerMeldungsAnteil
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlBenutzerMeldungsAnteil
							 ();
							atl.atl2Bean(arrayBenutzerMeldungsAnteil.getItem(i), factory);
							getBenutzerMeldungsAnteil().add(atl);
						}
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setWichtigkeit(getWichtigkeit());
							klon.setStatus(getStatus());
							klon.setWiedervorlage(getWiedervorlage());
							klon.setErgaenzungstext(getErgaenzungstext());
						klon._informationsMeldungsAnteil = getInformationsMeldungsAnteil().clone();
						klon._benutzerMeldungsAnteil = getBenutzerMeldungsAnteil().clone();
							klon._urlasser = getUrlasser().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.meldung";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdMeldung(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
