/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewengstellenglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beinhaltet die Parameter für die EngstellenVerwaltung.
<p>
&lt;absatz&gt;Beinhaltet die Parameter für die EngstellenVerwaltung.&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class PdEngstellenVerwaltungParameter extends AbstractParameterDatensatz<PdEngstellenVerwaltungParameter.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewengstellenglobal.attribute.AttVerkehrsStaerkeMinute
				 _maxVerkehrsStaerkeGesperrteFahrStreifen
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
				 _faktorMaxVerkehrsStaerkeStromabwaerts
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 _maxLaengeStauUeberBaustellenEnde
				;
				private 	RelativerZeitstempel
				 _wartezeitMeldungNachRaeumungUnfall
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
		
			/**
			Maximale VerkehrsStärke auf einem gesperrtem FahrStreifen.
			<p>
			&lt;absatz&gt;Gesperrt gemeldete Fahrstreifen dürfen eine parametrierbare Verkehrsstärke (z.B. 3 Fz&#47;min) nicht überschreiten.  Wenn diese Prüfunge verletzt wurde, dann muss eine entsprechende Meldung generiert werden.&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von MaxVerkehrsStaerkeGesperrteFahrStreifen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewengstellenglobal.attribute.AttVerkehrsStaerkeMinute
				 getMaxVerkehrsStaerkeGesperrteFahrStreifen() {
				return _maxVerkehrsStaerkeGesperrteFahrStreifen;
			}
		
			/**
			Maximale VerkehrsStärke auf einem gesperrtem FahrStreifen.
			<p>
			&lt;absatz&gt;Gesperrt gemeldete Fahrstreifen dürfen eine parametrierbare Verkehrsstärke (z.B. 3 Fz&#47;min) nicht überschreiten.  Wenn diese Prüfunge verletzt wurde, dann muss eine entsprechende Meldung generiert werden.&lt;&#47;absatz&gt;
			</p>
			
			@param _maxVerkehrsStaerkeGesperrteFahrStreifen der neue Wert von MaxVerkehrsStaerkeGesperrteFahrStreifen.
			*/
			public void setMaxVerkehrsStaerkeGesperrteFahrStreifen(de.bsvrz.sys.funclib.bitctrl.modell.tmvewengstellenglobal.attribute.AttVerkehrsStaerkeMinute
			 _maxVerkehrsStaerkeGesperrteFahrStreifen) {
				this._maxVerkehrsStaerkeGesperrteFahrStreifen = _maxVerkehrsStaerkeGesperrteFahrStreifen;
			}
		
			/**
			Faktor um den die angegebene Engpasskapazität stromabwärts maximal überschritten werden darf. Bei einer höheren VerkehrsStärke wird eine BetriebsMeldung erzeugt.
			<p>
			&lt;absatz&gt;Die angegebene Engpasskapazität wird mit dem Verkehrsfluss stromabwärts hinter der Baustelle verglichen. Die dort gemessene Verkehrstärke darf die Engpasskapazität maximal um einen parametrierbaren Faktor überschreiten. Dabei darf die Ermittlung nicht über Anschlussstellen oder Kreuze hinausgehen. Wenn diese Prüfunge verletzt wurde, dann muss eine entsprechende Meldung generiert werden.&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von FaktorMaxVerkehrsStaerkeStromabwaerts.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
				 getFaktorMaxVerkehrsStaerkeStromabwaerts() {
				return _faktorMaxVerkehrsStaerkeStromabwaerts;
			}
		
			/**
			Faktor um den die angegebene Engpasskapazität stromabwärts maximal überschritten werden darf. Bei einer höheren VerkehrsStärke wird eine BetriebsMeldung erzeugt.
			<p>
			&lt;absatz&gt;Die angegebene Engpasskapazität wird mit dem Verkehrsfluss stromabwärts hinter der Baustelle verglichen. Die dort gemessene Verkehrstärke darf die Engpasskapazität maximal um einen parametrierbaren Faktor überschreiten. Dabei darf die Ermittlung nicht über Anschlussstellen oder Kreuze hinausgehen. Wenn diese Prüfunge verletzt wurde, dann muss eine entsprechende Meldung generiert werden.&lt;&#47;absatz&gt;
			</p>
			
			@param _faktorMaxVerkehrsStaerkeStromabwaerts der neue Wert von FaktorMaxVerkehrsStaerkeStromabwaerts.
			*/
			public void setFaktorMaxVerkehrsStaerkeStromabwaerts(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 _faktorMaxVerkehrsStaerkeStromabwaerts) {
				this._faktorMaxVerkehrsStaerkeStromabwaerts = _faktorMaxVerkehrsStaerkeStromabwaerts;
			}
		
			/**
			Erkannte Staus dürfen stromabwärts nicht über eine parametrierbare Länge über das Baustellenende hinausgehen.
			<p>
			&lt;absatz&gt;Erkannte Staus dürfen stromabwärts nicht über eine parametrierbare Länge über das Baustellenende hinausgehen. Wenn diese Prüfunge verletzt wurde, dann muss eine entsprechende Meldung generiert werden.&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von MaxLaengeStauUeberBaustellenEnde.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 getMaxLaengeStauUeberBaustellenEnde() {
				return _maxLaengeStauUeberBaustellenEnde;
			}
		
			/**
			Erkannte Staus dürfen stromabwärts nicht über eine parametrierbare Länge über das Baustellenende hinausgehen.
			<p>
			&lt;absatz&gt;Erkannte Staus dürfen stromabwärts nicht über eine parametrierbare Länge über das Baustellenende hinausgehen. Wenn diese Prüfunge verletzt wurde, dann muss eine entsprechende Meldung generiert werden.&lt;&#47;absatz&gt;
			</p>
			
			@param _maxLaengeStauUeberBaustellenEnde der neue Wert von MaxLaengeStauUeberBaustellenEnde.
			*/
			public void setMaxLaengeStauUeberBaustellenEnde(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _maxLaengeStauUeberBaustellenEnde) {
				this._maxLaengeStauUeberBaustellenEnde = _maxLaengeStauUeberBaustellenEnde;
			}
		
			/**
			Zeitdauer, nach der für noch nicht zurückgenommene Unfälle Meldungen generiert werden.
			<p>
			&lt;absatz&gt;Wenn die geschätzte Zeit bis zur Räumung der Unfallstelle (verkehrliche Gültigkeit) plus versorgte Wartezeit verstrichen ist, werden für noch nicht zurückgenommene Unfälle Meldungen generiert, die den Benutzer zu einer Überprüfung der eingegebenen Engstelle veranlassen sollen.&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von WartezeitMeldungNachRaeumungUnfall.
			*/
				public 	RelativerZeitstempel
				 getWartezeitMeldungNachRaeumungUnfall() {
				return _wartezeitMeldungNachRaeumungUnfall;
			}
		
			/**
			Zeitdauer, nach der für noch nicht zurückgenommene Unfälle Meldungen generiert werden.
			<p>
			&lt;absatz&gt;Wenn die geschätzte Zeit bis zur Räumung der Unfallstelle (verkehrliche Gültigkeit) plus versorgte Wartezeit verstrichen ist, werden für noch nicht zurückgenommene Unfälle Meldungen generiert, die den Benutzer zu einer Überprüfung der eingegebenen Engstelle veranlassen sollen.&lt;&#47;absatz&gt;
			</p>
			
			@param _wartezeitMeldungNachRaeumungUnfall der neue Wert von WartezeitMeldungNachRaeumungUnfall.
			*/
			public void setWartezeitMeldungNachRaeumungUnfall(	RelativerZeitstempel
			 _wartezeitMeldungNachRaeumungUnfall) {
				this._wartezeitMeldungNachRaeumungUnfall = _wartezeitMeldungNachRaeumungUnfall;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getMaxVerkehrsStaerkeGesperrteFahrStreifen() != null) {
		                if (getMaxVerkehrsStaerkeGesperrteFahrStreifen().isZustand()) {
		                    datum.getUnscaledValue("MaxVerkehrsStärkeGesperrteFahrStreifen").setText(getMaxVerkehrsStaerkeGesperrteFahrStreifen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxVerkehrsStärkeGesperrteFahrStreifen").set(getMaxVerkehrsStaerkeGesperrteFahrStreifen().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFaktorMaxVerkehrsStaerkeStromabwaerts() != null) {
		                if (getFaktorMaxVerkehrsStaerkeStromabwaerts().isZustand()) {
		                    datum.getUnscaledValue("FaktorMaxVerkehrsStärkeStromabwärts").setText(getFaktorMaxVerkehrsStaerkeStromabwaerts().toString());
		                } else {
							datum.
							getScaledValue
		                	("FaktorMaxVerkehrsStärkeStromabwärts").set(getFaktorMaxVerkehrsStaerkeStromabwaerts().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxLaengeStauUeberBaustellenEnde() != null) {
		                if (getMaxLaengeStauUeberBaustellenEnde().isZustand()) {
		                    datum.getUnscaledValue("MaxLängeStauÜberBaustellenEnde").setText(getMaxLaengeStauUeberBaustellenEnde().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxLängeStauÜberBaustellenEnde").set(getMaxLaengeStauUeberBaustellenEnde().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("WartezeitMeldungNachRäumungUnfall").setMillis(getWartezeitMeldungNachRaeumungUnfall().getTime());
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxVerkehrsStärkeGesperrteFahrStreifen").isState()) {
								setMaxVerkehrsStaerkeGesperrteFahrStreifen(de.bsvrz.sys.funclib.bitctrl.modell.tmvewengstellenglobal.attribute.AttVerkehrsStaerkeMinute
								.getZustand(daten.getScaledValue("MaxVerkehrsStärkeGesperrteFahrStreifen").getText()));
							} else {
							setMaxVerkehrsStaerkeGesperrteFahrStreifen(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewengstellenglobal.attribute.AttVerkehrsStaerkeMinute
							(daten.
								getUnscaledValue
							("MaxVerkehrsStärkeGesperrteFahrStreifen").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							setFaktorMaxVerkehrsStaerkeStromabwaerts(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
							(daten.
								getScaledValue
							("FaktorMaxVerkehrsStärkeStromabwärts").
								doubleValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxLängeStauÜberBaustellenEnde").isState()) {
								setMaxLaengeStauUeberBaustellenEnde(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
								.getZustand(daten.getScaledValue("MaxLängeStauÜberBaustellenEnde").getText()));
							} else {
							setMaxLaengeStauUeberBaustellenEnde(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							(daten.
								getUnscaledValue
							("MaxLängeStauÜberBaustellenEnde").
									longValue
							()));
							}
					// ZeitstempelAttributTyp
						setWartezeitMeldungNachRaeumungUnfall(new
							RelativerZeitstempel
							(daten.getTimeValue("WartezeitMeldungNachRäumungUnfall").getMillis()));
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setMaxVerkehrsStaerkeGesperrteFahrStreifen(getMaxVerkehrsStaerkeGesperrteFahrStreifen());
							klon.setFaktorMaxVerkehrsStaerkeStromabwaerts(getFaktorMaxVerkehrsStaerkeStromabwaerts());
							klon.setMaxLaengeStauUeberBaustellenEnde(getMaxLaengeStauUeberBaustellenEnde());
							klon.setWartezeitMeldungNachRaeumungUnfall(getWartezeitMeldungNachRaeumungUnfall());
							klon._urlasser = getUrlasser().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.engstellenVerwaltungParameter";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdEngstellenVerwaltungParameter(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
