/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert einen Alias.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class AtlAliase implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _name
			= new String
			()
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			 _objekttyp
			;
	
		/**
		Name.
		<p>
		
		</p>
		
		@return der Wert von Name.
		*/
			public String
			 getName() {
			return _name;
		}
	
		/**
		Name.
		<p>
		
		</p>
		
		@param _name der neue Wert von Name.
		*/
		public void setName(String
		 _name) {
			if (_name.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._name = _name;
		}
	
		/**
		Objekttyp.
		<p>
		
		</p>
		
		@return der Wert von Objekttyp.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			 getObjekttyp() {
			return _objekttyp;
		}
	
		/**
		Objekttyp.
		<p>
		
		</p>
		
		@param _objekttyp der neue Wert von Objekttyp.
		*/
		public void setObjekttyp(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
		 _objekttyp) {
			this._objekttyp = _objekttyp;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getName() != null) {
					datum.getTextValue("Name").setText(getName());
				}
				// ObjektReferenzAttributTyp
					final Object soObjekttyp = getObjekttyp();
					final SystemObject tmpObjekttyp;
						if (soObjekttyp instanceof SystemObject) {
							tmpObjekttyp = (SystemObject)soObjekttyp;
						} else if(soObjekttyp instanceof SystemObjekt){
							tmpObjekttyp = ((SystemObjekt)soObjekttyp).getSystemObject();
						} else{
							tmpObjekttyp = null;
						}
					datum.getReferenceValue("Objekttyp").setSystemObject(tmpObjekttyp);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setName(daten.getTextValue("Name").getText());
				// ObjektReferenzAttributTyp
					final long idObjekttyp = daten.getReferenceValue("Objekttyp").getId();
					final SystemObjekt tmpObjekttyp;
					if (idObjekttyp == 0) {
						tmpObjekttyp = null;
					} else {
						final SystemObject soObjekttyp = factory.getDav().getDataModel().getObject(idObjekttyp);
						if (soObjekttyp == null) {
								tmpObjekttyp = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.TypUngueltig(idObjekttyp);
						} else {
							tmpObjekttyp = factory.getModellobjekt(soObjekttyp);
						}
					}
					setObjekttyp((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
					) tmpObjekttyp);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAliase clone() {
		AtlAliase klon = new AtlAliase();
		
						klon.setName(getName());
						klon.setObjekttyp(getObjekttyp());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
