/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert eine Aspekt-Bindung von ungebundenen Aspekten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AtlAspektBindung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _alias
			= new String
			()
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			 _aspekt
			;
	
		/**
		Alias.
		<p>
		
		</p>
		
		@return der Wert von Alias.
		*/
			public String
			 getAlias() {
			return _alias;
		}
	
		/**
		Alias.
		<p>
		
		</p>
		
		@param _alias der neue Wert von Alias.
		*/
		public void setAlias(String
		 _alias) {
			if (_alias.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._alias = _alias;
		}
	
		/**
		Aspekt.
		<p>
		
		</p>
		
		@return der Wert von Aspekt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			 getAspekt() {
			return _aspekt;
		}
	
		/**
		Aspekt.
		<p>
		
		</p>
		
		@param _aspekt der neue Wert von Aspekt.
		*/
		public void setAspekt(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
		 _aspekt) {
			this._aspekt = _aspekt;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getAlias() != null) {
					datum.getTextValue("Alias").setText(getAlias());
				}
				// ObjektReferenzAttributTyp
					final Object soAspekt = getAspekt();
					final SystemObject tmpAspekt;
						if (soAspekt instanceof SystemObject) {
							tmpAspekt = (SystemObject)soAspekt;
						} else if(soAspekt instanceof SystemObjekt){
							tmpAspekt = ((SystemObjekt)soAspekt).getSystemObject();
						} else{
							tmpAspekt = null;
						}
					datum.getReferenceValue("Aspekt").setSystemObject(tmpAspekt);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setAlias(daten.getTextValue("Alias").getText());
				// ObjektReferenzAttributTyp
					final long idAspekt = daten.getReferenceValue("Aspekt").getId();
					final SystemObjekt tmpAspekt;
					if (idAspekt == 0) {
						tmpAspekt = null;
					} else {
						final SystemObject soAspekt = factory.getDav().getDataModel().getObject(idAspekt);
						if (soAspekt == null) {
								tmpAspekt = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektUngueltig(idAspekt);
						} else {
							tmpAspekt = factory.getModellobjekt(soAspekt);
						}
					}
					setAspekt((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
					) tmpAspekt);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAspektBindung clone() {
		AtlAspektBindung klon = new AtlAspektBindung();
		
						klon.setAlias(getAlias());
						klon.setAspekt(getAspekt());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
