/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert ein Alias mit zugehörigen Pseudoobjekten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AtlPseudoObjektDefinition implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _alias
			= new String
			()
			;
			private Feld<	Object
			> _objekte = new Feld<	Object
			>(0, true);
	
		/**
		Alias.
		<p>
		
		</p>
		
		@return der Wert von Alias.
		*/
			public String
			 getAlias() {
			return _alias;
		}
	
		/**
		Alias.
		<p>
		
		</p>
		
		@param _alias der neue Wert von Alias.
		*/
		public void setAlias(String
		 _alias) {
			if (_alias.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._alias = _alias;
		}
	
		/**
		Objekte, undefiniert für leere Platzhalter bei unvollständigen Pseudoobjekten.
		<p>
		
		</p>
		
		@return der Wert von Objekte.
		*/
			public Feld<	Object
			> getObjekte() {
			return _objekte;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getAlias() != null) {
					datum.getTextValue("Alias").setText(getAlias());
				}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayObjekte = datum.getReferenceArray("Objekte");
					arrayObjekte.setLength(getObjekte().size());
					for (int i = 0; i < arrayObjekte.getLength(); ++i) {
						final Object soObjekte = getObjekte().get(i);
						final SystemObject tmpObjekte;
						if (soObjekte instanceof SystemObject) {
							tmpObjekte = (SystemObject)soObjekte;
						} else if(soObjekte instanceof SystemObjekt){
							tmpObjekte = ((SystemObjekt)soObjekte).getSystemObject();
						} else{
							tmpObjekte = null;
						}
						arrayObjekte.getReferenceValue(i).setSystemObject(tmpObjekte);
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setAlias(daten.getTextValue("Alias").getText());
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayObjekte = daten.getReferenceArray("Objekte");
					for (int i = 0; i < arrayObjekte.getLength(); ++i) {
						final long idObjekte = daten.getReferenceArray("Objekte").getReferenceValue(i).getId();
						final SystemObjekt tmpObjekte;
						if (idObjekte == 0) {
							tmpObjekte = null;
						} else {
							final SystemObject soObjekte = factory.getDav().getDataModel().getObject(idObjekte);
							if (soObjekte == null) {
									tmpObjekte = new BaseUngueltigesSystemObjekt(idObjekte);
							} else {
								tmpObjekte = factory.getModellobjekt(soObjekte);
							}
						}
							getObjekte().add((	Object
							) tmpObjekte);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlPseudoObjektDefinition clone() {
		AtlPseudoObjektDefinition klon = new AtlPseudoObjektDefinition();
		
						klon.setAlias(getAlias());
					klon._objekte = getObjekte().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
