/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Standardwerte eines Skripts.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class AtlPuaSkriptStandardWerte implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	Object
			> _objekte = new Feld<	Object
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlAliase
			> _aliase = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlAliase
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlPseudoObjektDefinition
			> _pseudoObjekte = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlPseudoObjektDefinition
			>(0, true);
			private Feld<String
			> _aspekte = new Feld<String
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlAspektBindung
			> _bindungen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlAspektBindung
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlZeitbereich
			> _zeitbereiche = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlZeitbereich
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AttProtokollart
			 _protokollart
			;
			@Defaultwert(wert = "pro Zeile")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AttUnveraendertKennzeichnung
			 _unveraendertkennzeichnung
			;
	
		/**
		Objekte.
		<p>
		
		</p>
		
		@return der Wert von Objekte.
		*/
			public Feld<	Object
			> getObjekte() {
			return _objekte;
		}
	
	
		/**
		Aliase.
		<p>
		
		</p>
		
		@return der Wert von Aliase.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlAliase
			> getAliase() {
			return _aliase;
		}
	
	
		/**
		Pseudoobjekte.
		<p>
		
		</p>
		
		@return der Wert von PseudoObjekte.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlPseudoObjektDefinition
			> getPseudoObjekte() {
			return _pseudoObjekte;
		}
	
	
		/**
		Aspekte.
		<p>
		
		</p>
		
		@return der Wert von Aspekte.
		*/
			public Feld<String
			> getAspekte() {
			return _aspekte;
		}
	
	
		/**
		Aspekt-Bindungen.
		<p>
		
		</p>
		
		@return der Wert von Bindungen.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlAspektBindung
			> getBindungen() {
			return _bindungen;
		}
	
	
		/**
		Zeitbereiche.
		<p>
		
		</p>
		
		@return der Wert von Zeitbereiche.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlZeitbereich
			> getZeitbereiche() {
			return _zeitbereiche;
		}
	
	
		/**
		Protokollart.
		<p>
		
		</p>
		
		@return der Wert von Protokollart.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AttProtokollart
			 getProtokollart() {
			return _protokollart;
		}
	
		/**
		Protokollart.
		<p>
		
		</p>
		
		@param _protokollart der neue Wert von Protokollart.
		*/
		public void setProtokollart(de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AttProtokollart
		 _protokollart) {
			this._protokollart = _protokollart;
		}
	
		/**
		Bei Zustandsprotokollen ob Unverändert-Markierungen pro Zeile oder pro Zelle übertragen werden.
		<p>
		
		</p>
		
		@return der Wert von Unveraendertkennzeichnung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AttUnveraendertKennzeichnung
			 getUnveraendertkennzeichnung() {
			return _unveraendertkennzeichnung;
		}
	
		/**
		Bei Zustandsprotokollen ob Unverändert-Markierungen pro Zeile oder pro Zelle übertragen werden.
		<p>
		
		</p>
		
		@param _unveraendertkennzeichnung der neue Wert von Unveraendertkennzeichnung.
		*/
		public void setUnveraendertkennzeichnung(de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AttUnveraendertKennzeichnung
		 _unveraendertkennzeichnung) {
			this._unveraendertkennzeichnung = _unveraendertkennzeichnung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayObjekte = datum.getReferenceArray("Objekte");
					arrayObjekte.setLength(getObjekte().size());
					for (int i = 0; i < arrayObjekte.getLength(); ++i) {
						final Object soObjekte = getObjekte().get(i);
						final SystemObject tmpObjekte;
						if (soObjekte instanceof SystemObject) {
							tmpObjekte = (SystemObject)soObjekte;
						} else if(soObjekte instanceof SystemObjekt){
							tmpObjekte = ((SystemObjekt)soObjekte).getSystemObject();
						} else{
							tmpObjekte = null;
						}
						arrayObjekte.getReferenceValue(i).setSystemObject(tmpObjekte);
					}
				// AttributListenDefinition
					final Data.Array arrayAliase = datum.getArray("Aliase");
					arrayAliase.setLength(getAliase().size());
					for (int i = 0; i < arrayAliase.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlAliase
						 atl = getAliase().get(i);
						atl.bean2Atl(arrayAliase.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayPseudoObjekte = datum.getArray("PseudoObjekte");
					arrayPseudoObjekte.setLength(getPseudoObjekte().size());
					for (int i = 0; i < arrayPseudoObjekte.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlPseudoObjektDefinition
						 atl = getPseudoObjekte().get(i);
						atl.bean2Atl(arrayPseudoObjekte.getItem(i), factory);
	
					}
				// ZeichenkettenAttributTyp
				if (getAspekte() != null) {
					final Data.TextArray arrayAspekte = datum.getTextArray("Aspekte");
					arrayAspekte.setLength(getAspekte().size());
					for (int i = 0; i < arrayAspekte.getLength(); ++i) {
						arrayAspekte.getTextValue(i).setText(getAspekte().get(i));
					}
				}
				// AttributListenDefinition
					final Data.Array arrayBindungen = datum.getArray("Bindungen");
					arrayBindungen.setLength(getBindungen().size());
					for (int i = 0; i < arrayBindungen.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlAspektBindung
						 atl = getBindungen().get(i);
						atl.bean2Atl(arrayBindungen.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayZeitbereiche = datum.getArray("Zeitbereiche");
					arrayZeitbereiche.setLength(getZeitbereiche().size());
					for (int i = 0; i < arrayZeitbereiche.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlZeitbereich
						 atl = getZeitbereiche().get(i);
						atl.bean2Atl(arrayZeitbereiche.getItem(i), factory);
	
					}
				// GanzzahlAttributTyp
				if (getProtokollart() != null) {
	                if (getProtokollart().isZustand()) {
	                    datum.getUnscaledValue("Protokollart").setText(getProtokollart().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Protokollart").set(getProtokollart().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getUnveraendertkennzeichnung() != null) {
	                if (getUnveraendertkennzeichnung().isZustand()) {
	                    datum.getUnscaledValue("Unverändertkennzeichnung").setText(getUnveraendertkennzeichnung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Unverändertkennzeichnung").set(getUnveraendertkennzeichnung().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayObjekte = daten.getReferenceArray("Objekte");
					for (int i = 0; i < arrayObjekte.getLength(); ++i) {
						final long idObjekte = daten.getReferenceArray("Objekte").getReferenceValue(i).getId();
						final SystemObjekt tmpObjekte;
						if (idObjekte == 0) {
							tmpObjekte = null;
						} else {
							final SystemObject soObjekte = factory.getDav().getDataModel().getObject(idObjekte);
							if (soObjekte == null) {
									tmpObjekte = new BaseUngueltigesSystemObjekt(idObjekte);
							} else {
								tmpObjekte = factory.getModellobjekt(soObjekte);
							}
						}
							getObjekte().add((	Object
							) tmpObjekte);
					}
				// AttributListenDefinition
					final Data.Array arrayAliase = daten.getArray("Aliase");
					for (int i = 0; i < arrayAliase.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlAliase
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlAliase
						 ();
						atl.atl2Bean(arrayAliase.getItem(i), factory);
						getAliase().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayPseudoObjekte = daten.getArray("PseudoObjekte");
					for (int i = 0; i < arrayPseudoObjekte.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlPseudoObjektDefinition
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlPseudoObjektDefinition
						 ();
						atl.atl2Bean(arrayPseudoObjekte.getItem(i), factory);
						getPseudoObjekte().add(atl);
					}
				// ZeichenkettenAttributTyp
					final Data.TextArray arrayAspekte = daten.getTextArray("Aspekte");
					for (int i = 0; i < arrayAspekte.getLength(); ++i) {
						getAspekte().add(arrayAspekte.getText(i));
					}
				// AttributListenDefinition
					final Data.Array arrayBindungen = daten.getArray("Bindungen");
					for (int i = 0; i < arrayBindungen.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlAspektBindung
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlAspektBindung
						 ();
						atl.atl2Bean(arrayBindungen.getItem(i), factory);
						getBindungen().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayZeitbereiche = daten.getArray("Zeitbereiche");
					for (int i = 0; i < arrayZeitbereiche.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlZeitbereich
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlZeitbereich
						 ();
						atl.atl2Bean(arrayZeitbereiche.getItem(i), factory);
						getZeitbereiche().add(atl);
					}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Protokollart").isState()) {
							setProtokollart(de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AttProtokollart
							.getZustand(daten.getScaledValue("Protokollart").getText()));
						} else {
						setProtokollart(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AttProtokollart
						(daten.
							getUnscaledValue
						("Protokollart").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Unverändertkennzeichnung").isState()) {
							setUnveraendertkennzeichnung(de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AttUnveraendertKennzeichnung
							.getZustand(daten.getScaledValue("Unverändertkennzeichnung").getText()));
						} else {
						setUnveraendertkennzeichnung(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AttUnveraendertKennzeichnung
						(daten.
							getUnscaledValue
						("Unverändertkennzeichnung").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlPuaSkriptStandardWerte clone() {
		AtlPuaSkriptStandardWerte klon = new AtlPuaSkriptStandardWerte();
		
					klon._objekte = getObjekte().clone();
					klon._aliase = getAliase().clone();
					klon._pseudoObjekte = getPseudoObjekte().clone();
					klon._aspekte = getAspekte().clone();
					klon._bindungen = getBindungen().clone();
					klon._zeitbereiche = getZeitbereiche().clone();
						klon.setProtokollart(getProtokollart());
						klon.setUnveraendertkennzeichnung(getUnveraendertkennzeichnung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
