/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Wichtige Parameter der Anfrage.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class AtlSkriptErweiterteinformation implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Object
			 _absender
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _anfrageId
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AttPuaSkriptOperationsCode
			 _operationsCode
			;
			private String
			 _quellcode
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlPuaSkriptStandardWerte
			> _standardwerte = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlPuaSkriptStandardWerte
			>(1, true);
	
		/**
		Referenz auf den Absender des Datensatzes.
		<p>
		Die anfragende Applikation traegt in diesem Attribut das vom Datenverteiler dynamisch erzeugte Applikations-Objekt ein
		</p>
		
		@return der Wert von Absender.
		*/
			public 	Object
			 getAbsender() {
			return _absender;
		}
	
		/**
		Referenz auf den Absender des Datensatzes.
		<p>
		Die anfragende Applikation traegt in diesem Attribut das vom Datenverteiler dynamisch erzeugte Applikations-Objekt ein
		</p>
		
		@param _absender der neue Wert von Absender.
		*/
		public void setAbsender(	Object
		 _absender) {
			this._absender = _absender;
		}
	
		/**
		Identifikationsnummer der Anfrage.
		<p>
		
		</p>
		
		@return der Wert von AnfrageId.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getAnfrageId() {
			return _anfrageId;
		}
	
		/**
		Identifikationsnummer der Anfrage.
		<p>
		
		</p>
		
		@param _anfrageId der neue Wert von AnfrageId.
		*/
		public void setAnfrageId(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _anfrageId) {
			this._anfrageId = _anfrageId;
		}
	
		/**
		Typ der Anfrage &#47; Antwort.
		<p>
		
		</p>
		
		@return der Wert von OperationsCode.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AttPuaSkriptOperationsCode
			 getOperationsCode() {
			return _operationsCode;
		}
	
		/**
		Typ der Anfrage &#47; Antwort.
		<p>
		
		</p>
		
		@param _operationsCode der neue Wert von OperationsCode.
		*/
		public void setOperationsCode(de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AttPuaSkriptOperationsCode
		 _operationsCode) {
			this._operationsCode = _operationsCode;
		}
	
		/**
		Quellcode des Skripts.
		<p>
		
		</p>
		
		@return der Wert von Quellcode.
		*/
			public String
			 getQuellcode() {
			return _quellcode;
		}
	
		/**
		Quellcode des Skripts.
		<p>
		
		</p>
		
		@param _quellcode der neue Wert von Quellcode.
		*/
		public void setQuellcode(String
		 _quellcode) {
			if (_quellcode.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._quellcode = _quellcode;
		}
	
		/**
		Standardwerte des Skripts.
		<p>
		
		</p>
		
		@return der Wert von Standardwerte.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlPuaSkriptStandardWerte
			> getStandardwerte() {
			return _standardwerte;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soAbsender = getAbsender();
					final SystemObject tmpAbsender;
						if (soAbsender instanceof SystemObject) {
							tmpAbsender = (SystemObject)soAbsender;
						} else if(soAbsender instanceof SystemObjekt){
							tmpAbsender = ((SystemObjekt)soAbsender).getSystemObject();
						} else{
							tmpAbsender = null;
						}
					datum.getReferenceValue("Absender").setSystemObject(tmpAbsender);
				// GanzzahlAttributTyp
				if (getAnfrageId() != null) {
	                if (getAnfrageId().isZustand()) {
	                    datum.getUnscaledValue("AnfrageId").setText(getAnfrageId().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AnfrageId").set(getAnfrageId().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getOperationsCode() != null) {
	                if (getOperationsCode().isZustand()) {
	                    datum.getUnscaledValue("OperationsCode").setText(getOperationsCode().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("OperationsCode").set(getOperationsCode().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getQuellcode() != null) {
					datum.getTextValue("Quellcode").setText(getQuellcode());
				}
				// AttributListenDefinition
					final Data.Array arrayStandardwerte = datum.getArray("Standardwerte");
					arrayStandardwerte.setLength(getStandardwerte().size());
					for (int i = 0; i < arrayStandardwerte.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlPuaSkriptStandardWerte
						 atl = getStandardwerte().get(i);
						atl.bean2Atl(arrayStandardwerte.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idAbsender = daten.getReferenceValue("Absender").getId();
					final SystemObjekt tmpAbsender;
					if (idAbsender == 0) {
						tmpAbsender = null;
					} else {
						final SystemObject soAbsender = factory.getDav().getDataModel().getObject(idAbsender);
						if (soAbsender == null) {
								tmpAbsender = new BaseUngueltigesSystemObjekt(idAbsender);
						} else {
							tmpAbsender = factory.getModellobjekt(soAbsender);
						}
					}
					setAbsender((	Object
					) tmpAbsender);
				// GanzzahlAttributTyp
						setAnfrageId(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("AnfrageId").
								longValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("OperationsCode").isState()) {
							setOperationsCode(de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AttPuaSkriptOperationsCode
							.getZustand(daten.getScaledValue("OperationsCode").getText()));
						} else {
						setOperationsCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AttPuaSkriptOperationsCode
						(daten.
							getUnscaledValue
						("OperationsCode").
								shortValue
						()));
						}
				// ZeichenkettenAttributTyp
					setQuellcode(daten.getTextValue("Quellcode").getText());
				// AttributListenDefinition
					final Data.Array arrayStandardwerte = daten.getArray("Standardwerte");
					for (int i = 0; i < arrayStandardwerte.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlPuaSkriptStandardWerte
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlPuaSkriptStandardWerte
						 ();
						atl.atl2Bean(arrayStandardwerte.getItem(i), factory);
						getStandardwerte().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlSkriptErweiterteinformation clone() {
		AtlSkriptErweiterteinformation klon = new AtlSkriptErweiterteinformation();
		
						klon.setAbsender(getAbsender());
						klon.setAnfrageId(getAnfrageId());
						klon.setOperationsCode(getOperationsCode());
						klon.setQuellcode(getQuellcode());
					klon._standardwerte = getStandardwerte().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
