/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Grundlegende Informationen ueber das Skript.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlSkriptGrundinformation implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _name
			= new String
			()
			;
			private String
			 _beschreibung
			= new String
			()
			;
			private String
			 _autor
			= new String
			()
			;
			private String
			 _status
			= new String
			()
			;
			private String
			 _datum
			= new String
			()
			;
	
		/**
		Name des Skripts.
		<p>
		
		</p>
		
		@return der Wert von Name.
		*/
			public String
			 getName() {
			return _name;
		}
	
		/**
		Name des Skripts.
		<p>
		
		</p>
		
		@param _name der neue Wert von Name.
		*/
		public void setName(String
		 _name) {
			if (_name.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._name = _name;
		}
	
		/**
		Beschreibung des Skripts.
		<p>
		
		</p>
		
		@return der Wert von Beschreibung.
		*/
			public String
			 getBeschreibung() {
			return _beschreibung;
		}
	
		/**
		Beschreibung des Skripts.
		<p>
		
		</p>
		
		@param _beschreibung der neue Wert von Beschreibung.
		*/
		public void setBeschreibung(String
		 _beschreibung) {
			if (_beschreibung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._beschreibung = _beschreibung;
		}
	
		/**
		Urheber.
		<p>
		
		</p>
		
		@return der Wert von Autor.
		*/
			public String
			 getAutor() {
			return _autor;
		}
	
		/**
		Urheber.
		<p>
		
		</p>
		
		@param _autor der neue Wert von Autor.
		*/
		public void setAutor(String
		 _autor) {
			if (_autor.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._autor = _autor;
		}
	
		/**
		Status.
		<p>
		
		</p>
		
		@return der Wert von Status.
		*/
			public String
			 getStatus() {
			return _status;
		}
	
		/**
		Status.
		<p>
		
		</p>
		
		@param _status der neue Wert von Status.
		*/
		public void setStatus(String
		 _status) {
			if (_status.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._status = _status;
		}
	
		/**
		Erstellungsdatum.
		<p>
		
		</p>
		
		@return der Wert von Datum.
		*/
			public String
			 getDatum() {
			return _datum;
		}
	
		/**
		Erstellungsdatum.
		<p>
		
		</p>
		
		@param _datum der neue Wert von Datum.
		*/
		public void setDatum(String
		 _datum) {
			if (_datum.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._datum = _datum;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getName() != null) {
					datum.getTextValue("Name").setText(getName());
				}
				// ZeichenkettenAttributTyp
				if (getBeschreibung() != null) {
					datum.getTextValue("Beschreibung").setText(getBeschreibung());
				}
				// ZeichenkettenAttributTyp
				if (getAutor() != null) {
					datum.getTextValue("Autor").setText(getAutor());
				}
				// ZeichenkettenAttributTyp
				if (getStatus() != null) {
					datum.getTextValue("Status").setText(getStatus());
				}
				// ZeichenkettenAttributTyp
				if (getDatum() != null) {
					datum.getTextValue("Datum").setText(getDatum());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setName(daten.getTextValue("Name").getText());
				// ZeichenkettenAttributTyp
					setBeschreibung(daten.getTextValue("Beschreibung").getText());
				// ZeichenkettenAttributTyp
					setAutor(daten.getTextValue("Autor").getText());
				// ZeichenkettenAttributTyp
					setStatus(daten.getTextValue("Status").getText());
				// ZeichenkettenAttributTyp
					setDatum(daten.getTextValue("Datum").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlSkriptGrundinformation clone() {
		AtlSkriptGrundinformation klon = new AtlSkriptGrundinformation();
		
						klon.setName(getName());
						klon.setBeschreibung(getBeschreibung());
						klon.setAutor(getAutor());
						klon.setStatus(getStatus());
						klon.setDatum(getDatum());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
