/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Variable Elemente eines Skripts (Tripel aus Objekttyp, Attributgruppe und Aspekt).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlSkriptMetainformation implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlSkriptVariableElemente
			> _variableElemente = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlSkriptVariableElemente
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlSkriptVersionsHistorie
			> _versionsHistorie = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlSkriptVersionsHistorie
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlSkriptGrundinformation
			 _grundinformation
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlSkriptGrundinformation
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlSkriptDetailinformation
			 _detailinformation
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlSkriptDetailinformation
			()
			;
	
		/**
		Variable Elemente des Skripts.
		<p>
		
		</p>
		
		@return der Wert von VariableElemente.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlSkriptVariableElemente
			> getVariableElemente() {
			return _variableElemente;
		}
	
	
		/**
		Versionshistorie des Skripts.
		<p>
		
		</p>
		
		@return der Wert von VersionsHistorie.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlSkriptVersionsHistorie
			> getVersionsHistorie() {
			return _versionsHistorie;
		}
	
	
		/**
		Grundlegende Informationen ueber das Skript.
		<p>
		
		</p>
		
		@return der Wert von Grundinformation.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlSkriptGrundinformation
			 getGrundinformation() {
			return _grundinformation;
		}
	
		/**
		Grundlegende Informationen ueber das Skript.
		<p>
		
		</p>
		
		@param _grundinformation der neue Wert von Grundinformation.
		*/
		public void setGrundinformation(de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlSkriptGrundinformation
		 _grundinformation) {
			this._grundinformation = _grundinformation;
		}
	
		/**
		Detailinformationen ueber das Skript.
		<p>
		
		</p>
		
		@return der Wert von Detailinformation.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlSkriptDetailinformation
			 getDetailinformation() {
			return _detailinformation;
		}
	
		/**
		Detailinformationen ueber das Skript.
		<p>
		
		</p>
		
		@param _detailinformation der neue Wert von Detailinformation.
		*/
		public void setDetailinformation(de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlSkriptDetailinformation
		 _detailinformation) {
			this._detailinformation = _detailinformation;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayVariableElemente = datum.getArray("VariableElemente");
					arrayVariableElemente.setLength(getVariableElemente().size());
					for (int i = 0; i < arrayVariableElemente.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlSkriptVariableElemente
						 atl = getVariableElemente().get(i);
						atl.bean2Atl(arrayVariableElemente.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayVersionsHistorie = datum.getArray("VersionsHistorie");
					arrayVersionsHistorie.setLength(getVersionsHistorie().size());
					for (int i = 0; i < arrayVersionsHistorie.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlSkriptVersionsHistorie
						 atl = getVersionsHistorie().get(i);
						atl.bean2Atl(arrayVersionsHistorie.getItem(i), factory);
	
					}
				// AttributListenDefinition
					getGrundinformation().bean2Atl(datum.getItem("Grundinformation"), factory);
				// AttributListenDefinition
					getDetailinformation().bean2Atl(datum.getItem("Detailinformation"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayVariableElemente = daten.getArray("VariableElemente");
					for (int i = 0; i < arrayVariableElemente.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlSkriptVariableElemente
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlSkriptVariableElemente
						 ();
						atl.atl2Bean(arrayVariableElemente.getItem(i), factory);
						getVariableElemente().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayVersionsHistorie = daten.getArray("VersionsHistorie");
					for (int i = 0; i < arrayVersionsHistorie.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlSkriptVersionsHistorie
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AtlSkriptVersionsHistorie
						 ();
						atl.atl2Bean(arrayVersionsHistorie.getItem(i), factory);
						getVersionsHistorie().add(atl);
					}
				// AttributListenDefinition
					getGrundinformation().atl2Bean(daten.getItem("Grundinformation"), factory);
				// AttributListenDefinition
					getDetailinformation().atl2Bean(daten.getItem("Detailinformation"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlSkriptMetainformation clone() {
		AtlSkriptMetainformation klon = new AtlSkriptMetainformation();
		
					klon._variableElemente = getVariableElemente().clone();
					klon._versionsHistorie = getVersionsHistorie().clone();
						klon._grundinformation = getGrundinformation().clone();
						klon._detailinformation = getDetailinformation().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
