/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Versionshistorie des Skripts.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlSkriptVersionsHistorie implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _version
			;
			private String
			 _aenderungsdatum
			= new String
			()
			;
			private String
			 _beschreibung
			= new String
			()
			;
			private String
			 _urheber
			= new String
			()
			;
	
		/**
		Version des Skripts.
		<p>
		
		</p>
		
		@return der Wert von Version.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getVersion() {
			return _version;
		}
	
		/**
		Version des Skripts.
		<p>
		
		</p>
		
		@param _version der neue Wert von Version.
		*/
		public void setVersion(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _version) {
			this._version = _version;
		}
	
		/**
		Erstellungsdatum dieser Version.
		<p>
		
		</p>
		
		@return der Wert von Aenderungsdatum.
		*/
			public String
			 getAenderungsdatum() {
			return _aenderungsdatum;
		}
	
		/**
		Erstellungsdatum dieser Version.
		<p>
		
		</p>
		
		@param _aenderungsdatum der neue Wert von Aenderungsdatum.
		*/
		public void setAenderungsdatum(String
		 _aenderungsdatum) {
			if (_aenderungsdatum.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._aenderungsdatum = _aenderungsdatum;
		}
	
		/**
		Beschreibung.
		<p>
		
		</p>
		
		@return der Wert von Beschreibung.
		*/
			public String
			 getBeschreibung() {
			return _beschreibung;
		}
	
		/**
		Beschreibung.
		<p>
		
		</p>
		
		@param _beschreibung der neue Wert von Beschreibung.
		*/
		public void setBeschreibung(String
		 _beschreibung) {
			if (_beschreibung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._beschreibung = _beschreibung;
		}
	
		/**
		Name des Autors.
		<p>
		
		</p>
		
		@return der Wert von Urheber.
		*/
			public String
			 getUrheber() {
			return _urheber;
		}
	
		/**
		Name des Autors.
		<p>
		
		</p>
		
		@param _urheber der neue Wert von Urheber.
		*/
		public void setUrheber(String
		 _urheber) {
			if (_urheber.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._urheber = _urheber;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getVersion() != null) {
	                if (getVersion().isZustand()) {
	                    datum.getUnscaledValue("Version").setText(getVersion().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Version").set(getVersion().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getAenderungsdatum() != null) {
					datum.getTextValue("Aenderungsdatum").setText(getAenderungsdatum());
				}
				// ZeichenkettenAttributTyp
				if (getBeschreibung() != null) {
					datum.getTextValue("Beschreibung").setText(getBeschreibung());
				}
				// ZeichenkettenAttributTyp
				if (getUrheber() != null) {
					datum.getTextValue("Urheber").setText(getUrheber());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setVersion(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Version").
								longValue
						()));
				// ZeichenkettenAttributTyp
					setAenderungsdatum(daten.getTextValue("Aenderungsdatum").getText());
				// ZeichenkettenAttributTyp
					setBeschreibung(daten.getTextValue("Beschreibung").getText());
				// ZeichenkettenAttributTyp
					setUrheber(daten.getTextValue("Urheber").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlSkriptVersionsHistorie clone() {
		AtlSkriptVersionsHistorie klon = new AtlSkriptVersionsHistorie();
		
						klon.setVersion(getVersion());
						klon.setAenderungsdatum(getAenderungsdatum());
						klon.setBeschreibung(getBeschreibung());
						klon.setUrheber(getUrheber());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
