/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Stellt einen Zeitbereich dar.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AtlZeitbereich implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _startzeit
			;
			private 	Zeitstempel
			 _endzeit
			;
	
		/**
		Startzeitpunkt des Bereichs.
		<p>
		
		</p>
		
		@return der Wert von Startzeit.
		*/
			public 	Zeitstempel
			 getStartzeit() {
			return _startzeit;
		}
	
		/**
		Startzeitpunkt des Bereichs.
		<p>
		
		</p>
		
		@param _startzeit der neue Wert von Startzeit.
		*/
		public void setStartzeit(	Zeitstempel
		 _startzeit) {
			this._startzeit = _startzeit;
		}
	
		/**
		Endzeitpunkt des Bereichs.
		<p>
		
		</p>
		
		@return der Wert von Endzeit.
		*/
			public 	Zeitstempel
			 getEndzeit() {
			return _endzeit;
		}
	
		/**
		Endzeitpunkt des Bereichs.
		<p>
		
		</p>
		
		@param _endzeit der neue Wert von Endzeit.
		*/
		public void setEndzeit(	Zeitstempel
		 _endzeit) {
			this._endzeit = _endzeit;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Startzeit").setMillis(getStartzeit().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("Endzeit").setMillis(getEndzeit().getTime());
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setStartzeit(new
						Zeitstempel
						(daten.getTimeValue("Startzeit").getMillis()));
				// ZeitstempelAttributTyp
					setEndzeit(new
						Zeitstempel
						(daten.getTimeValue("Endzeit").getMillis()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlZeitbereich clone() {
		AtlZeitbereich klon = new AtlZeitbereich();
		
						klon.setStartzeit(getStartzeit());
						klon.setEndzeit(getEndzeit());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
