/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributtyp, der zur Unterscheidung der verschiedenen Nachrichten bei der Abwicklung von PUA-Anfragen dient.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AttPuaProtokollOperationsCode extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Erstellen eines Protokolls.
	<p>
	
	</p>
	*/
	public static final AttPuaProtokollOperationsCode ZUSTAND_1_PROTOKOLLERSTELLUNG = new AttPuaProtokollOperationsCode("Protokollerstellung", 		Short
	.valueOf("1"));

	/**
	Protokollerstellung abbrechen.
	<p>
	
	</p>
	*/
	public static final AttPuaProtokollOperationsCode ZUSTAND_2_ABBRECHEN = new AttPuaProtokollOperationsCode("Abbrechen", 		Short
	.valueOf("2"));

	/**
	Protokoll loeschen.
	<p>
	
	</p>
	*/
	public static final AttPuaProtokollOperationsCode ZUSTAND_3_PROTOKOLLLOESCHEN = new AttPuaProtokollOperationsCode("ProtokollLoeschen", 		Short
	.valueOf("3"));

	/**
	Liste der gespeicherten Protokolle abrufen.
	<p>
	
	</p>
	*/
	public static final AttPuaProtokollOperationsCode ZUSTAND_4_PROTOKOLLLISTE = new AttPuaProtokollOperationsCode("ProtokollListe", 		Short
	.valueOf("4"));

	/**
	Status der Protokollerstellung.
	<p>
	
	</p>
	*/
	public static final AttPuaProtokollOperationsCode ZUSTAND_5_STATUS = new AttPuaProtokollOperationsCode("Status", 		Short
	.valueOf("5"));

	/**
	Gespeichertes Protokoll abrufen.
	<p>
	
	</p>
	*/
	public static final AttPuaProtokollOperationsCode ZUSTAND_6_PROTOKOLLABRUFEN = new AttPuaProtokollOperationsCode("ProtokollAbrufen", 		Short
	.valueOf("6"));

	/**
	Protokollerstellung anhalten.
	<p>
	
	</p>
	*/
	public static final AttPuaProtokollOperationsCode ZUSTAND_7_PROTOKOLLANHALTEN = new AttPuaProtokollOperationsCode("ProtokollAnhalten", 		Short
	.valueOf("7"));

	/**
	Protokollerstellung wieder aufnehmen.
	<p>
	
	</p>
	*/
	public static final AttPuaProtokollOperationsCode ZUSTAND_8_PROTOKOLLFORTSETZEN = new AttPuaProtokollOperationsCode("ProtokollFortsetzen", 		Short
	.valueOf("8"));

	/**
	Noch nicht abgerufenes Protokoll abrufen.
	<p>
	
	</p>
	*/
	public static final AttPuaProtokollOperationsCode ZUSTAND_9_UNGELESENESPROTOKOLLABRUFEN = new AttPuaProtokollOperationsCode("UngelesenesProtokollAbrufen", 		Short
	.valueOf("9"));

	/**
	Liefert eine Liste mit noch nicht abgerufenen Protokollen zurück.
	<p>
	
	</p>
	*/
	public static final AttPuaProtokollOperationsCode ZUSTAND_10_LISTEUNGELESENEPROTOKOLLE = new AttPuaProtokollOperationsCode("ListeUngeleseneProtokolle", 		Short
	.valueOf("10"));

	/**
	Liefert zurück ob PuA läuft und das Archivsystem verfügbar ist.
	<p>
	
	</p>
	*/
	public static final AttPuaProtokollOperationsCode ZUSTAND_11_PUAARSSTATUS = new AttPuaProtokollOperationsCode("PuaArsStatus", 		Short
	.valueOf("11"));

	/**
	Dient zur Anmeldung bzw. zum Versand von Protokoll-Fertigmeldungen.
	<p>
	
	</p>
	*/
	public static final AttPuaProtokollOperationsCode ZUSTAND_12_PROTOKOLLFERTIGMELDUNG = new AttPuaProtokollOperationsCode("ProtokollFertigmeldung", 		Short
	.valueOf("12"));

	/**
	Diese Nachricht dient der Uebertragung einer Fehlermeldung.
	<p>
	
	</p>
	*/
	public static final AttPuaProtokollOperationsCode ZUSTAND_100_FEHLER = new AttPuaProtokollOperationsCode("Fehler", 		Short
	.valueOf("100"));

	/**
	Eine positive Quittungsmeldung.
	<p>
	
	</p>
	*/
	public static final AttPuaProtokollOperationsCode ZUSTAND_200_QUITTUNG = new AttPuaProtokollOperationsCode("Quittung", 		Short
	.valueOf("200"));

	/**
	Zur Auflistung aller protokollbezogenen Anfragen, die sich aktuell in der Warteschlange oder in Bearbeitung befinden.
	<p>
	
	</p>
	*/
	public static final AttPuaProtokollOperationsCode ZUSTAND_13_LISTEANFRAGE = new AttPuaProtokollOperationsCode("ListeAnfrage", 		Short
	.valueOf("13"));

	/**
	Wird zur Flusskontrolle verwendet indem der Client dem Server die Anzahl der gewünschten Datensätze mitteilt (bis zu welcher Datensatznummer PuA Daten senden soll).
	<p>
	
	</p>
	*/
	public static final AttPuaProtokollOperationsCode ZUSTAND_14_FLUSSKONTROLLE = new AttPuaProtokollOperationsCode("Flusskontrolle", 		Short
	.valueOf("14"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttPuaProtokollOperationsCode getZustand(final 		Short
	 value) {
		for (AttPuaProtokollOperationsCode e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttPuaProtokollOperationsCode getZustand(final String value) {
		for (AttPuaProtokollOperationsCode e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttPuaProtokollOperationsCode> getZustaende() {
		List<AttPuaProtokollOperationsCode> list = new ArrayList<AttPuaProtokollOperationsCode>();
		list.add(ZUSTAND_1_PROTOKOLLERSTELLUNG);
		list.add(ZUSTAND_2_ABBRECHEN);
		list.add(ZUSTAND_3_PROTOKOLLLOESCHEN);
		list.add(ZUSTAND_4_PROTOKOLLLISTE);
		list.add(ZUSTAND_5_STATUS);
		list.add(ZUSTAND_6_PROTOKOLLABRUFEN);
		list.add(ZUSTAND_7_PROTOKOLLANHALTEN);
		list.add(ZUSTAND_8_PROTOKOLLFORTSETZEN);
		list.add(ZUSTAND_9_UNGELESENESPROTOKOLLABRUFEN);
		list.add(ZUSTAND_10_LISTEUNGELESENEPROTOKOLLE);
		list.add(ZUSTAND_11_PUAARSSTATUS);
		list.add(ZUSTAND_12_PROTOKOLLFERTIGMELDUNG);
		list.add(ZUSTAND_100_FEHLER);
		list.add(ZUSTAND_200_QUITTUNG);
		list.add(ZUSTAND_13_LISTEANFRAGE);
		list.add(ZUSTAND_14_FLUSSKONTROLLE);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut Operationscode.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttPuaProtokollOperationsCode(final 		Short
	 value) {
		super(value);
	}
	
	private AttPuaProtokollOperationsCode(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
