/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppe zur Uebertragung von Nachrichten die zur Abwicklung von PuA Anfragen dienen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class OdPuaProtokollAnfrageSchnittstelle extends AbstractOnlineDatensatz<OdPuaProtokollAnfrageSchnittstelle.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Anfrage,
					Aspekte.Antwort,
				};
			}
	
			/**
			 * Wird zur Anfrage von Informationen benutzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Anfrage = new Aspekte("Anfrage", "asp.anfrage");
			
			/**
			 * Wird zur Beantwortung von Anfragen benutzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Antwort = new Aspekte("Antwort", "asp.antwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	Object
				 _absender
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _protokollId
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AttPuaProtokollOperationsCode
				 _operationscode
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				> _daten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				>(0, true);
				@Defaultwert(wert = "0")
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _flusskontrolle
				;
		
			/**
			Referenz auf den Absender des Datensatzes.
			<p>
			Die anfragende Applikation traegt in diesem Attribut das vom Datenverteiler dynamisch erzeugte Applikations-Objekt ein.Das Archiv adressiert entsprechende Antworten an dieses Applikationsobjekt. In den Antworten von PUA ist in diesem Attribut eine Referenz auf den Konfigurationsverantwortlichen enthalten.
			</p>
			
			@return der Wert von Absender.
			*/
				public 	Object
				 getAbsender() {
				return _absender;
			}
		
			/**
			Referenz auf den Absender des Datensatzes.
			<p>
			Die anfragende Applikation traegt in diesem Attribut das vom Datenverteiler dynamisch erzeugte Applikations-Objekt ein.Das Archiv adressiert entsprechende Antworten an dieses Applikationsobjekt. In den Antworten von PUA ist in diesem Attribut eine Referenz auf den Konfigurationsverantwortlichen enthalten.
			</p>
			
			@param _absender der neue Wert von Absender.
			*/
			public void setAbsender(	Object
			 _absender) {
				this._absender = _absender;
			}
		
			/**
			Kennzeichnung, die von der anfragenden Applikation zur Unterscheidung mehrerer paralleler Anfragen fortlaufend vergeben wird.
			<p>
			In allen zu einer PUA Anfrage gehoerenden Nachrichten wird diese Identifikation eingetragen, damit der jeweilige Empfaenger die Nachricht zu der richtigen Anfrage zuordnen kann.
			</p>
			
			@return der Wert von ProtokollId.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getProtokollId() {
				return _protokollId;
			}
		
			/**
			Kennzeichnung, die von der anfragenden Applikation zur Unterscheidung mehrerer paralleler Anfragen fortlaufend vergeben wird.
			<p>
			In allen zu einer PUA Anfrage gehoerenden Nachrichten wird diese Identifikation eingetragen, damit der jeweilige Empfaenger die Nachricht zu der richtigen Anfrage zuordnen kann.
			</p>
			
			@param _protokollId der neue Wert von ProtokollId.
			*/
			public void setProtokollId(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _protokollId) {
				this._protokollId = _protokollId;
			}
		
			/**
			Typ der Nachricht.
			<p>
			
			</p>
			
			@return der Wert von Operationscode.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AttPuaProtokollOperationsCode
				 getOperationscode() {
				return _operationscode;
			}
		
			/**
			Typ der Nachricht.
			<p>
			
			</p>
			
			@param _operationscode der neue Wert von Operationscode.
			*/
			public void setOperationscode(de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AttPuaProtokollOperationsCode
			 _operationscode) {
				this._operationscode = _operationscode;
			}
		
			/**
			Datenbytes der Nachricht.
			<p>
			
			</p>
			
			@return der Wert von Daten.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				> getDaten() {
				return _daten;
			}
		
		
			/**
			Wird zur automatischen Flusskontrolle benutzt und teilt dem PuA-Server die Datensatznummer mit bis zu der anfangs Protokolldaten gesendet werden sollen.
			<p>
			Diese Zahl ist nur relevant bei Protokoll-Erstellen- und bei Protokoll-Abrufen-Aufträgen. Bleibt der Wert auf dem Default-Wert 0 signalisiert das, dass keine Flusskontrolle möglich oder erwünscht ist.
			</p>
			
			@return der Wert von Flusskontrolle.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getFlusskontrolle() {
				return _flusskontrolle;
			}
		
			/**
			Wird zur automatischen Flusskontrolle benutzt und teilt dem PuA-Server die Datensatznummer mit bis zu der anfangs Protokolldaten gesendet werden sollen.
			<p>
			Diese Zahl ist nur relevant bei Protokoll-Erstellen- und bei Protokoll-Abrufen-Aufträgen. Bleibt der Wert auf dem Default-Wert 0 signalisiert das, dass keine Flusskontrolle möglich oder erwünscht ist.
			</p>
			
			@param _flusskontrolle der neue Wert von Flusskontrolle.
			*/
			public void setFlusskontrolle(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _flusskontrolle) {
				this._flusskontrolle = _flusskontrolle;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soAbsender = getAbsender();
						final SystemObject tmpAbsender;
							if (soAbsender instanceof SystemObject) {
								tmpAbsender = (SystemObject)soAbsender;
							} else if(soAbsender instanceof SystemObjekt){
								tmpAbsender = ((SystemObjekt)soAbsender).getSystemObject();
							} else{
								tmpAbsender = null;
							}
						datum.getReferenceValue("Absender").setSystemObject(tmpAbsender);
					// GanzzahlAttributTyp
					if (getProtokollId() != null) {
		                if (getProtokollId().isZustand()) {
		                    datum.getUnscaledValue("Protokoll-Id").setText(getProtokollId().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Protokoll-Id").set(getProtokollId().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getOperationscode() != null) {
		                if (getOperationscode().isZustand()) {
		                    datum.getUnscaledValue("Operationscode").setText(getOperationscode().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Operationscode").set(getOperationscode().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDaten() != null) {
						final Data.NumberArray arrayDaten = datum.
							getUnscaledArray
							("Daten");
						arrayDaten.setLength(getDaten().size());
						for (int i = 0; i < arrayDaten.getLength(); ++i) {
							arrayDaten.getValue(i).set(getDaten().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getFlusskontrolle() != null) {
		                if (getFlusskontrolle().isZustand()) {
		                    datum.getUnscaledValue("Flusskontrolle").setText(getFlusskontrolle().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Flusskontrolle").set(getFlusskontrolle().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idAbsender = daten.getReferenceValue("Absender").getId();
						final SystemObjekt tmpAbsender;
						if (idAbsender == 0) {
							tmpAbsender = null;
						} else {
							final SystemObject soAbsender = factory.getDav().getDataModel().getObject(idAbsender);
							if (soAbsender == null) {
									tmpAbsender = new BaseUngueltigesSystemObjekt(idAbsender);
							} else {
								tmpAbsender = factory.getModellobjekt(soAbsender);
							}
						}
						setAbsender((	Object
						) tmpAbsender);
					// GanzzahlAttributTyp
							setProtokollId(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("Protokoll-Id").
									longValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Operationscode").isState()) {
								setOperationscode(de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AttPuaProtokollOperationsCode
								.getZustand(daten.getScaledValue("Operationscode").getText()));
							} else {
							setOperationscode(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.attribute.AttPuaProtokollOperationsCode
							(daten.
								getUnscaledValue
							("Operationscode").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
						final Data.NumberArray arrayDaten = daten.
							getUnscaledArray
						("Daten");
		
						for (int i = 0; i < arrayDaten.getLength(); ++i) {
		                    getDaten().add(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
		                    (arrayDaten.
		                    		byteValue
		                    (i)));
		                }
					// GanzzahlAttributTyp
							setFlusskontrolle(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("Flusskontrolle").
									longValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAbsender(getAbsender());
							klon.setProtokollId(getProtokollId());
							klon.setOperationscode(getOperationscode());
						klon._daten = getDaten().clone();
							klon.setFlusskontrolle(getFlusskontrolle());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.puaProtokollAnfrageSchnittstelle";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdPuaProtokollAnfrageSchnittstelle(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
