/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Datenspezifikation.
<p>
&lt;absatz&gt;
						In der Attributliste können Tupel bestehend aus Konfigurationsobjekt(en), Attributgruppe(n) und Aspekt(en) angegeben werden. Bei der
						Datenspezifikation mit der Attributliste werden die Objekte, Attributgruppen und Aspekte in voneinander unabhängigen Feldern
						spezifiziert.
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;
						Die konkrete Auswahl ergibt sich durch jede gültige Kombination der Angabe in den drei Feldern. Dabei ist zu beachten, dass nur
						sinnvolle Kombinationen betrachtet werden; d.h. es werden natürlich nur die Attributgruppen&#47;Aspektkombinationen für ein
						Konfigurationsobjekt ausgewählt, die laut Konfiguration bei einem Konfigurationsobjekt des entsprechenden Typs möglich sind.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlDatenSpezifikationen implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	Object
			> _objekt = new Feld<	Object
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			> _attributGruppe = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			> _aspekt = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			>(0, true);
	
		/**
		Mit diesem Attribut können beliebig viele Konfigurationsobjekte angegeben werden. Die Spezifikation der gewünschten
								Konfigurationsobjekte erfolgt über die direkte Angabe von einzelnen Konfigurationsobjekten (z.B. über die PID), über die Angabe einer
								Menge (z.B. Menge der MQ) unf durch die Angabe von Typen (z.B. Typ MQ). Bei der Angabe von Objekttypen werden alle Konfigurationsobjekte
								dieses Typs aus den Konfigurationsbereichen ausgewählt, die über das Attribut "Bereich" spezifiziert wurden (Kein Eintrag bedeutet: alle
								Objekte ausgewählt).
		<p>
		
		</p>
		
		@return der Wert von Objekt.
		*/
			public Feld<	Object
			> getObjekt() {
			return _objekt;
		}
	
	
		/**
		Mit diesem Attribut können beliebig viele Attributgruppen spezifiziert werden. (Kein Eintrag bedeutet: alle Attributtgruppen
								ausgewählt).
		<p>
		
		</p>
		
		@return der Wert von AttributGruppe.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			> getAttributGruppe() {
			return _attributGruppe;
		}
	
	
		/**
		Mit diesem Attribut können beliebig viele Aspekte spezifiziert werden. (Kein Eintrag bedeutet: alle Aspekte ausgewählt).
		<p>
		
		</p>
		
		@return der Wert von Aspekt.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			> getAspekt() {
			return _aspekt;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayObjekt = datum.getReferenceArray("Objekt");
					arrayObjekt.setLength(getObjekt().size());
					for (int i = 0; i < arrayObjekt.getLength(); ++i) {
						final Object soObjekt = getObjekt().get(i);
						final SystemObject tmpObjekt;
						if (soObjekt instanceof SystemObject) {
							tmpObjekt = (SystemObject)soObjekt;
						} else if(soObjekt instanceof SystemObjekt){
							tmpObjekt = ((SystemObjekt)soObjekt).getSystemObject();
						} else{
							tmpObjekt = null;
						}
						arrayObjekt.getReferenceValue(i).setSystemObject(tmpObjekt);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAttributGruppe = datum.getReferenceArray("AttributGruppe");
					arrayAttributGruppe.setLength(getAttributGruppe().size());
					for (int i = 0; i < arrayAttributGruppe.getLength(); ++i) {
						final Object soAttributGruppe = getAttributGruppe().get(i);
						final SystemObject tmpAttributGruppe;
						if (soAttributGruppe instanceof SystemObject) {
							tmpAttributGruppe = (SystemObject)soAttributGruppe;
						} else if(soAttributGruppe instanceof SystemObjekt){
							tmpAttributGruppe = ((SystemObjekt)soAttributGruppe).getSystemObject();
						} else{
							tmpAttributGruppe = null;
						}
						arrayAttributGruppe.getReferenceValue(i).setSystemObject(tmpAttributGruppe);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAspekt = datum.getReferenceArray("Aspekt");
					arrayAspekt.setLength(getAspekt().size());
					for (int i = 0; i < arrayAspekt.getLength(); ++i) {
						final Object soAspekt = getAspekt().get(i);
						final SystemObject tmpAspekt;
						if (soAspekt instanceof SystemObject) {
							tmpAspekt = (SystemObject)soAspekt;
						} else if(soAspekt instanceof SystemObjekt){
							tmpAspekt = ((SystemObjekt)soAspekt).getSystemObject();
						} else{
							tmpAspekt = null;
						}
						arrayAspekt.getReferenceValue(i).setSystemObject(tmpAspekt);
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayObjekt = daten.getReferenceArray("Objekt");
					for (int i = 0; i < arrayObjekt.getLength(); ++i) {
						final long idObjekt = daten.getReferenceArray("Objekt").getReferenceValue(i).getId();
						final SystemObjekt tmpObjekt;
						if (idObjekt == 0) {
							tmpObjekt = null;
						} else {
							final SystemObject soObjekt = factory.getDav().getDataModel().getObject(idObjekt);
							if (soObjekt == null) {
									tmpObjekt = new BaseUngueltigesSystemObjekt(idObjekt);
							} else {
								tmpObjekt = factory.getModellobjekt(soObjekt);
							}
						}
							getObjekt().add((	Object
							) tmpObjekt);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAttributGruppe = daten.getReferenceArray("AttributGruppe");
					for (int i = 0; i < arrayAttributGruppe.getLength(); ++i) {
						final long idAttributGruppe = daten.getReferenceArray("AttributGruppe").getReferenceValue(i).getId();
						final SystemObjekt tmpAttributGruppe;
						if (idAttributGruppe == 0) {
							tmpAttributGruppe = null;
						} else {
							final SystemObject soAttributGruppe = factory.getDav().getDataModel().getObject(idAttributGruppe);
							if (soAttributGruppe == null) {
									tmpAttributGruppe = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AttributgruppeUngueltig(idAttributGruppe);
							} else {
								tmpAttributGruppe = factory.getModellobjekt(soAttributGruppe);
							}
						}
							getAttributGruppe().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
							) tmpAttributGruppe);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAspekt = daten.getReferenceArray("Aspekt");
					for (int i = 0; i < arrayAspekt.getLength(); ++i) {
						final long idAspekt = daten.getReferenceArray("Aspekt").getReferenceValue(i).getId();
						final SystemObjekt tmpAspekt;
						if (idAspekt == 0) {
							tmpAspekt = null;
						} else {
							final SystemObject soAspekt = factory.getDav().getDataModel().getObject(idAspekt);
							if (soAspekt == null) {
									tmpAspekt = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektUngueltig(idAspekt);
							} else {
								tmpAspekt = factory.getModellobjekt(soAspekt);
							}
						}
							getAspekt().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
							) tmpAspekt);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlDatenSpezifikationen clone() {
		AtlDatenSpezifikationen klon = new AtlDatenSpezifikationen();
		
					klon._objekt = getObjekt().clone();
					klon._attributGruppe = getAttributGruppe().clone();
					klon._aspekt = getAspekt().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
