/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Erzeuge-Anforderung von Simulationen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class AtlErzeugeSimulationAnfrage implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _name
			= new String
			()
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.SimulationsStrecke
			 _referenzSimulationsStrecke
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttSimulationsArt
			 _simulationsArt
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlOfflineSimulationsZeitbereich
			> _offlineSimulationsZeitbereich = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlOfflineSimulationsZeitbereich
			>(1, true);
	
		/**
		Name der Simulation.
		<p>
		
		</p>
		
		@return der Wert von Name.
		*/
			public String
			 getName() {
			return _name;
		}
	
		/**
		Name der Simulation.
		<p>
		
		</p>
		
		@param _name der neue Wert von Name.
		*/
		public void setName(String
		 _name) {
			if (_name.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._name = _name;
		}
	
		/**
		Referenz der zu benutzenden Simulationsstrecke.
		<p>
		
		</p>
		
		@return der Wert von ReferenzSimulationsStrecke.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.SimulationsStrecke
			 getReferenzSimulationsStrecke() {
			return _referenzSimulationsStrecke;
		}
	
		/**
		Referenz der zu benutzenden Simulationsstrecke.
		<p>
		
		</p>
		
		@param _referenzSimulationsStrecke der neue Wert von ReferenzSimulationsStrecke.
		*/
		public void setReferenzSimulationsStrecke(	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.SimulationsStrecke
		 _referenzSimulationsStrecke) {
			this._referenzSimulationsStrecke = _referenzSimulationsStrecke;
		}
	
		/**
		Simulationsart - Online&#47;Offline.
		<p>
		
		</p>
		
		@return der Wert von SimulationsArt.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttSimulationsArt
			 getSimulationsArt() {
			return _simulationsArt;
		}
	
		/**
		Simulationsart - Online&#47;Offline.
		<p>
		
		</p>
		
		@param _simulationsArt der neue Wert von SimulationsArt.
		*/
		public void setSimulationsArt(de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttSimulationsArt
		 _simulationsArt) {
			this._simulationsArt = _simulationsArt;
		}
	
		/**
		Zeitbereich für die Offline-Simulation.
		<p>
		
		</p>
		
		@return der Wert von OfflineSimulationsZeitbereich.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlOfflineSimulationsZeitbereich
			> getOfflineSimulationsZeitbereich() {
			return _offlineSimulationsZeitbereich;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getName() != null) {
					datum.getTextValue("Name").setText(getName());
				}
				// ObjektReferenzAttributTyp
					final Object soReferenzSimulationsStrecke = getReferenzSimulationsStrecke();
					final SystemObject tmpReferenzSimulationsStrecke;
						if (soReferenzSimulationsStrecke instanceof SystemObject) {
							tmpReferenzSimulationsStrecke = (SystemObject)soReferenzSimulationsStrecke;
						} else if(soReferenzSimulationsStrecke instanceof SystemObjekt){
							tmpReferenzSimulationsStrecke = ((SystemObjekt)soReferenzSimulationsStrecke).getSystemObject();
						} else{
							tmpReferenzSimulationsStrecke = null;
						}
					datum.getReferenceValue("ReferenzSimulationsStrecke").setSystemObject(tmpReferenzSimulationsStrecke);
				// GanzzahlAttributTyp
				if (getSimulationsArt() != null) {
	                if (getSimulationsArt().isZustand()) {
	                    datum.getUnscaledValue("SimulationsArt").setText(getSimulationsArt().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SimulationsArt").set(getSimulationsArt().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayOfflineSimulationsZeitbereich = datum.getArray("OfflineSimulationsZeitbereich");
					arrayOfflineSimulationsZeitbereich.setLength(getOfflineSimulationsZeitbereich().size());
					for (int i = 0; i < arrayOfflineSimulationsZeitbereich.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlOfflineSimulationsZeitbereich
						 atl = getOfflineSimulationsZeitbereich().get(i);
						atl.bean2Atl(arrayOfflineSimulationsZeitbereich.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setName(daten.getTextValue("Name").getText());
				// ObjektReferenzAttributTyp
					final long idReferenzSimulationsStrecke = daten.getReferenceValue("ReferenzSimulationsStrecke").getId();
					final SystemObjekt tmpReferenzSimulationsStrecke;
					if (idReferenzSimulationsStrecke == 0) {
						tmpReferenzSimulationsStrecke = null;
					} else {
						final SystemObject soReferenzSimulationsStrecke = factory.getDav().getDataModel().getObject(idReferenzSimulationsStrecke);
						if (soReferenzSimulationsStrecke == null) {
								tmpReferenzSimulationsStrecke = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.impl.SimulationsStreckeUngueltig(idReferenzSimulationsStrecke);
						} else {
							tmpReferenzSimulationsStrecke = factory.getModellobjekt(soReferenzSimulationsStrecke);
						}
					}
					setReferenzSimulationsStrecke((	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.SimulationsStrecke
					) tmpReferenzSimulationsStrecke);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("SimulationsArt").isState()) {
							setSimulationsArt(de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttSimulationsArt
							.getZustand(daten.getScaledValue("SimulationsArt").getText()));
						} else {
						setSimulationsArt(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttSimulationsArt
						(daten.
							getUnscaledValue
						("SimulationsArt").
								byteValue
						()));
						}
				// AttributListenDefinition
					final Data.Array arrayOfflineSimulationsZeitbereich = daten.getArray("OfflineSimulationsZeitbereich");
					for (int i = 0; i < arrayOfflineSimulationsZeitbereich.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlOfflineSimulationsZeitbereich
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AtlOfflineSimulationsZeitbereich
						 ();
						atl.atl2Bean(arrayOfflineSimulationsZeitbereich.getItem(i), factory);
						getOfflineSimulationsZeitbereich().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlErzeugeSimulationAnfrage clone() {
		AtlErzeugeSimulationAnfrage klon = new AtlErzeugeSimulationAnfrage();
		
						klon.setName(getName());
						klon.setReferenzSimulationsStrecke(getReferenzSimulationsStrecke());
						klon.setSimulationsArt(getSimulationsArt());
					klon._offlineSimulationsZeitbereich = getOfflineSimulationsZeitbereich().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
