/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Lösche-Antwort von Simulationen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class AtlLoescheSimulationAntwort implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttLoescheSimulationZustand
			 _loescheSimulationZustand
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttLoescheSimulationFehler
			 _loescheSimulationFehler
			;
	
		/**
		Zustand nach Loesche-Anforderung einer Simulation.
		<p>
		
		</p>
		
		@return der Wert von LoescheSimulationZustand.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttLoescheSimulationZustand
			 getLoescheSimulationZustand() {
			return _loescheSimulationZustand;
		}
	
		/**
		Zustand nach Loesche-Anforderung einer Simulation.
		<p>
		
		</p>
		
		@param _loescheSimulationZustand der neue Wert von LoescheSimulationZustand.
		*/
		public void setLoescheSimulationZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttLoescheSimulationZustand
		 _loescheSimulationZustand) {
			this._loescheSimulationZustand = _loescheSimulationZustand;
		}
	
		/**
		Fehler-Status nach Loesche-Anforderung einer Simulation.
		<p>
		
		</p>
		
		@return der Wert von LoescheSimulationFehler.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttLoescheSimulationFehler
			 getLoescheSimulationFehler() {
			return _loescheSimulationFehler;
		}
	
		/**
		Fehler-Status nach Loesche-Anforderung einer Simulation.
		<p>
		
		</p>
		
		@param _loescheSimulationFehler der neue Wert von LoescheSimulationFehler.
		*/
		public void setLoescheSimulationFehler(de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttLoescheSimulationFehler
		 _loescheSimulationFehler) {
			this._loescheSimulationFehler = _loescheSimulationFehler;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getLoescheSimulationZustand() != null) {
	                if (getLoescheSimulationZustand().isZustand()) {
	                    datum.getUnscaledValue("LoescheSimulationZustand").setText(getLoescheSimulationZustand().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LoescheSimulationZustand").set(getLoescheSimulationZustand().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLoescheSimulationFehler() != null) {
	                if (getLoescheSimulationFehler().isZustand()) {
	                    datum.getUnscaledValue("LoescheSimulationFehler").setText(getLoescheSimulationFehler().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LoescheSimulationFehler").set(getLoescheSimulationFehler().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("LoescheSimulationZustand").isState()) {
							setLoescheSimulationZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttLoescheSimulationZustand
							.getZustand(daten.getScaledValue("LoescheSimulationZustand").getText()));
						} else {
						setLoescheSimulationZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttLoescheSimulationZustand
						(daten.
							getUnscaledValue
						("LoescheSimulationZustand").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("LoescheSimulationFehler").isState()) {
							setLoescheSimulationFehler(de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttLoescheSimulationFehler
							.getZustand(daten.getScaledValue("LoescheSimulationFehler").getText()));
						} else {
						setLoescheSimulationFehler(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute.AttLoescheSimulationFehler
						(daten.
							getUnscaledValue
						("LoescheSimulationFehler").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlLoescheSimulationAntwort clone() {
		AtlLoescheSimulationAntwort klon = new AtlLoescheSimulationAntwort();
		
						klon.setLoescheSimulationZustand(getLoescheSimulationZustand());
						klon.setLoescheSimulationFehler(getLoescheSimulationFehler());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
