/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Fehlerstatus nach Erzeuge-Anforderung einer Simulation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class AttErzeugeSimulationFehler extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Anfrage fehlerfrei durchgeführt.
	<p>
	
	</p>
	*/
	public static final AttErzeugeSimulationFehler ZUSTAND_0_KEIN_FEHLER = new AttErzeugeSimulationFehler("Kein Fehler", 		Byte
	.valueOf("0"));

	/**
	Es konnte keine freie Simulationsvariante berechnet werden.
	<p>
	
	</p>
	*/
	public static final AttErzeugeSimulationFehler ZUSTAND_1_KEINE_FREIE_SIMULATIONSVARIANTE = new AttErzeugeSimulationFehler("Keine freie Simulationsvariante", 		Byte
	.valueOf("1"));

	/**
	Die Referenz auf die Simulationsstrecke ist ungültig.
	<p>
	
	</p>
	*/
	public static final AttErzeugeSimulationFehler ZUSTAND_2_UNGUELTIGE_SIMULATIONSSTRECKEN_REFERENZ = new AttErzeugeSimulationFehler("Ungültige Simulationsstrecken-Referenz", 		Byte
	.valueOf("2"));

	/**
	Allgemeiner - unspezifizierter - Fehler beim Erzeugen der Simulation..
	<p>
	
	</p>
	*/
	public static final AttErzeugeSimulationFehler ZUSTAND_3_ALLGEMEINER_FEHLER = new AttErzeugeSimulationFehler("Allgemeiner Fehler", 		Byte
	.valueOf("3"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttErzeugeSimulationFehler getZustand(final 		Byte
	 value) {
		for (AttErzeugeSimulationFehler e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttErzeugeSimulationFehler getZustand(final String value) {
		for (AttErzeugeSimulationFehler e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttErzeugeSimulationFehler> getZustaende() {
		List<AttErzeugeSimulationFehler> list = new ArrayList<AttErzeugeSimulationFehler>();
		list.add(ZUSTAND_0_KEIN_FEHLER);
		list.add(ZUSTAND_1_KEINE_FREIE_SIMULATIONSVARIANTE);
		list.add(ZUSTAND_2_UNGUELTIGE_SIMULATIONSSTRECKEN_REFERENZ);
		list.add(ZUSTAND_3_ALLGEMEINER_FEHLER);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut ErzeugeSimulationFehler.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttErzeugeSimulationFehler(final 		Byte
	 value) {
		super(value);
	}
	
	private AttErzeugeSimulationFehler(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
