/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zustand eines Simulationsobjektes.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 7
 */
public class AttSimulationsZustand extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Ein neues Simulationsobjekt wurde angelegt.
	<p>
	
	</p>
	*/
	public static final AttSimulationsZustand ZUSTAND_0_NEU = new AttSimulationsZustand("neu", 		Byte
	.valueOf("0"));

	/**
	Vor dem eigentlichen Start einer Simulation.
	<p>
	
	</p>
	*/
	public static final AttSimulationsZustand ZUSTAND_1_VORSTART = new AttSimulationsZustand("Vorstart", 		Byte
	.valueOf("1"));

	/**
	Start der Simulation; ist erst möglich, wenn der Vorstart erfolgreich war.
	<p>
	
	</p>
	*/
	public static final AttSimulationsZustand ZUSTAND_2_START = new AttSimulationsZustand("Start", 		Byte
	.valueOf("2"));

	/**
	Stop der Simulation.
	<p>
	
	</p>
	*/
	public static final AttSimulationsZustand ZUSTAND_3_STOP = new AttSimulationsZustand("Stop", 		Byte
	.valueOf("3"));

	/**
	Löschen der Simulation; führt dazu, dass das Simulationsobjekt gelöscht wird und die Simulationsvariante von einer anderen
								Simulation benutzt werden kann.
	<p>
	
	</p>
	*/
	public static final AttSimulationsZustand ZUSTAND_4_GELOESCHT = new AttSimulationsZustand("gelöscht", 		Byte
	.valueOf("4"));

	/**
	Anhalten der Simulation; nur bei der Offlinesimulation möglich.
	<p>
	
	</p>
	*/
	public static final AttSimulationsZustand ZUSTAND_5_PAUSE = new AttSimulationsZustand("Pause", 		Byte
	.valueOf("5"));

	/**
	Befehl um in der Simulation um einen Schritt fortzuschreiten.
	<p>
	Der Simulationsdatengenerator speist die Datensätze des nächst folgenden durch den Archivzeitstempel vorgegebenen Zeitpunkt ein.
	</p>
	*/
	public static final AttSimulationsZustand ZUSTAND_6_EINZELSCHRITT = new AttSimulationsZustand("Einzelschritt", 		Byte
	.valueOf("6"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttSimulationsZustand getZustand(final 		Byte
	 value) {
		for (AttSimulationsZustand e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttSimulationsZustand getZustand(final String value) {
		for (AttSimulationsZustand e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttSimulationsZustand> getZustaende() {
		List<AttSimulationsZustand> list = new ArrayList<AttSimulationsZustand>();
		list.add(ZUSTAND_0_NEU);
		list.add(ZUSTAND_1_VORSTART);
		list.add(ZUSTAND_2_START);
		list.add(ZUSTAND_3_STOP);
		list.add(ZUSTAND_4_GELOESCHT);
		list.add(ZUSTAND_5_PAUSE);
		list.add(ZUSTAND_6_EINZELSCHRITT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut SimulationsZustand.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttSimulationsZustand(final 		Byte
	 value) {
		super(value);
	}
	
	private AttSimulationsZustand(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
