/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Objekte, die Simulationen repräsentieren.
<p>
&lt;absatz&gt;
						Der Aufbau der PID muss der Form 'simulation.XXX' entsprechen. Dabei ist 'XXX' die vergebene Simulationsvariante des
						Simulationsobjektes.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class SimulationImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.Simulation { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public SimulationImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public SimulationImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein Simulation.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationsStatusArchiv getOdSimulationsStatusArchiv() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationsStatusArchiv.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationsStatusParametrierung getOdSimulationsStatusParametrierung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationsStatusParametrierung.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.konfigurationsdaten.KdSimulationsEigenschaften getKdSimulationsEigenschaften() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.konfigurationsdaten.KdSimulationsEigenschaften.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdKexdavAustauschObjekt getKdKexdavAustauschObjekt() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdKexdavAustauschObjekt.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationsStatusStartStopp getOdSimulationsStatusStartStopp() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationsStatusStartStopp.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationsStatusKonfiguration getOdSimulationsStatusKonfiguration() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationsStatusKonfiguration.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.parameter.PdSimulationStartInfo getPdSimulationStartInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.parameter.PdSimulationStartInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
