/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
beschreibt einen Eintrag des historischen Ablaufs der Skriptbearbeitung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlUdaHistorie implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _aenderungsdatum
			;
			private String
			 _name
			= new String
			()
			;
			private String
			 _grund
			= new String
			()
			;
	
		/**
		der Zeitstempel der Änderung.
		<p>
		
		</p>
		
		@return der Wert von Aenderungsdatum.
		*/
			public 	Zeitstempel
			 getAenderungsdatum() {
			return _aenderungsdatum;
		}
	
		/**
		der Zeitstempel der Änderung.
		<p>
		
		</p>
		
		@param _aenderungsdatum der neue Wert von Aenderungsdatum.
		*/
		public void setAenderungsdatum(	Zeitstempel
		 _aenderungsdatum) {
			this._aenderungsdatum = _aenderungsdatum;
		}
	
		/**
		der Name des Nutzers, der die Änderung vorgenommen hat.
		<p>
		
		</p>
		
		@return der Wert von Name.
		*/
			public String
			 getName() {
			return _name;
		}
	
		/**
		der Name des Nutzers, der die Änderung vorgenommen hat.
		<p>
		
		</p>
		
		@param _name der neue Wert von Name.
		*/
		public void setName(String
		 _name) {
			if (_name.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._name = _name;
		}
	
		/**
		die Beschreibung des Änderungsgrundes.
		<p>
		
		</p>
		
		@return der Wert von Grund.
		*/
			public String
			 getGrund() {
			return _grund;
		}
	
		/**
		die Beschreibung des Änderungsgrundes.
		<p>
		
		</p>
		
		@param _grund der neue Wert von Grund.
		*/
		public void setGrund(String
		 _grund) {
			if (_grund.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._grund = _grund;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Änderungsdatum").setMillis(getAenderungsdatum().getTime());
				// ZeichenkettenAttributTyp
				if (getName() != null) {
					datum.getTextValue("Name").setText(getName());
				}
				// ZeichenkettenAttributTyp
				if (getGrund() != null) {
					datum.getTextValue("Grund").setText(getGrund());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setAenderungsdatum(new
						Zeitstempel
						(daten.getTimeValue("Änderungsdatum").getMillis()));
				// ZeichenkettenAttributTyp
					setName(daten.getTextValue("Name").getText());
				// ZeichenkettenAttributTyp
					setGrund(daten.getTextValue("Grund").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlUdaHistorie clone() {
		AtlUdaHistorie klon = new AtlUdaHistorie();
		
						klon.setAenderungsdatum(getAenderungsdatum());
						klon.setName(getName());
						klon.setGrund(getGrund());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
