/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
die Beschreibung des Protokolls für die Ausführung eines Skriptlaufs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlUdaProtokoll implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AttUdaProtokollTyp
			 _typ
			;
			private String
			 _name
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _anzahl
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _maxGroesse
			;
	
		/**
		der Typ des Protokolls.
		<p>
		
		</p>
		
		@return der Wert von Typ.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AttUdaProtokollTyp
			 getTyp() {
			return _typ;
		}
	
		/**
		der Typ des Protokolls.
		<p>
		
		</p>
		
		@param _typ der neue Wert von Typ.
		*/
		public void setTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AttUdaProtokollTyp
		 _typ) {
			this._typ = _typ;
		}
	
		/**
		der Name des Protokolls (z.B. Dateiname).
		<p>
		
		</p>
		
		@return der Wert von Name.
		*/
			public String
			 getName() {
			return _name;
		}
	
		/**
		der Name des Protokolls (z.B. Dateiname).
		<p>
		
		</p>
		
		@param _name der neue Wert von Name.
		*/
		public void setName(String
		 _name) {
			if (_name.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._name = _name;
		}
	
		/**
		die Anzahl der Protokolldateien (z.B. bei Verwendung von Logging), wird nicht von allen Typen
								berücksichtigt.
		<p>
		
		</p>
		
		@return der Wert von Anzahl.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getAnzahl() {
			return _anzahl;
		}
	
		/**
		die Anzahl der Protokolldateien (z.B. bei Verwendung von Logging), wird nicht von allen Typen
								berücksichtigt.
		<p>
		
		</p>
		
		@param _anzahl der neue Wert von Anzahl.
		*/
		public void setAnzahl(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _anzahl) {
			this._anzahl = _anzahl;
		}
	
		/**
		die maximale Größe der Protokollausgabe (wird nicht von allen Typen berücksichtigt).
		<p>
		
		</p>
		
		@return der Wert von MaxGroesse.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getMaxGroesse() {
			return _maxGroesse;
		}
	
		/**
		die maximale Größe der Protokollausgabe (wird nicht von allen Typen berücksichtigt).
		<p>
		
		</p>
		
		@param _maxGroesse der neue Wert von MaxGroesse.
		*/
		public void setMaxGroesse(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _maxGroesse) {
			this._maxGroesse = _maxGroesse;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getTyp() != null) {
	                if (getTyp().isZustand()) {
	                    datum.getUnscaledValue("Typ").setText(getTyp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Typ").set(getTyp().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getName() != null) {
					datum.getTextValue("Name").setText(getName());
				}
				// GanzzahlAttributTyp
				if (getAnzahl() != null) {
	                if (getAnzahl().isZustand()) {
	                    datum.getUnscaledValue("Anzahl").setText(getAnzahl().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Anzahl").set(getAnzahl().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getMaxGroesse() != null) {
	                if (getMaxGroesse().isZustand()) {
	                    datum.getUnscaledValue("MaxGroesse").setText(getMaxGroesse().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("MaxGroesse").set(getMaxGroesse().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Typ").isState()) {
							setTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AttUdaProtokollTyp
							.getZustand(daten.getScaledValue("Typ").getText()));
						} else {
						setTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AttUdaProtokollTyp
						(daten.
							getUnscaledValue
						("Typ").
								shortValue
						()));
						}
				// ZeichenkettenAttributTyp
					setName(daten.getTextValue("Name").getText());
				// GanzzahlAttributTyp
						setAnzahl(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Anzahl").
								longValue
						()));
				// GanzzahlAttributTyp
						setMaxGroesse(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("MaxGroesse").
								longValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlUdaProtokoll clone() {
		AtlUdaProtokoll klon = new AtlUdaProtokoll();
		
						klon.setTyp(getTyp());
						klon.setName(getName());
						klon.setAnzahl(getAnzahl());
						klon.setMaxGroesse(getMaxGroesse());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
