/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
die Daten für die zyklische Ausführung eines Skriptlaufs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlUdaZyklus implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _startzeitpunkt
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _intervall
			;
	
		/**
		der Startzeitpunkt für die Ausführung des Skripts.
		<p>
		Der Startzeitpunkt kann ein konkreter Zeitstempel sein, z.B. bei einer einmaligen Ausführung.
								Für eine zyklische Ausführung kann der Wert auf 0 gesetzt werden, damit wird die Ausführung
								ausgehend von = Uhr des aktuellen Tages im angegebenen Intervall ausgeführt.
		</p>
		
		@return der Wert von Startzeitpunkt.
		*/
			public 	Zeitstempel
			 getStartzeitpunkt() {
			return _startzeitpunkt;
		}
	
		/**
		der Startzeitpunkt für die Ausführung des Skripts.
		<p>
		Der Startzeitpunkt kann ein konkreter Zeitstempel sein, z.B. bei einer einmaligen Ausführung.
								Für eine zyklische Ausführung kann der Wert auf 0 gesetzt werden, damit wird die Ausführung
								ausgehend von = Uhr des aktuellen Tages im angegebenen Intervall ausgeführt.
		</p>
		
		@param _startzeitpunkt der neue Wert von Startzeitpunkt.
		*/
		public void setStartzeitpunkt(	Zeitstempel
		 _startzeitpunkt) {
			this._startzeitpunkt = _startzeitpunkt;
		}
	
		/**
		das Intervall für die zyklische Ausführung, 0 bei einmaliger Ausführung.
		<p>
		
		</p>
		
		@return der Wert von Intervall.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getIntervall() {
			return _intervall;
		}
	
		/**
		das Intervall für die zyklische Ausführung, 0 bei einmaliger Ausführung.
		<p>
		
		</p>
		
		@param _intervall der neue Wert von Intervall.
		*/
		public void setIntervall(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _intervall) {
			this._intervall = _intervall;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Startzeitpunkt").setMillis(getStartzeitpunkt().getTime());
				// GanzzahlAttributTyp
				if (getIntervall() != null) {
	                if (getIntervall().isZustand()) {
	                    datum.getUnscaledValue("Intervall").setText(getIntervall().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Intervall").set(getIntervall().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setStartzeitpunkt(new
						Zeitstempel
						(daten.getTimeValue("Startzeitpunkt").getMillis()));
				// GanzzahlAttributTyp
						setIntervall(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Intervall").
								longValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlUdaZyklus clone() {
		AtlUdaZyklus klon = new AtlUdaZyklus();
		
						klon.setStartzeitpunkt(getStartzeitpunkt());
						klon.setIntervall(getIntervall());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
