/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
ein Kommando an die Uda inklusive der Codes für die Antworten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttUdaSkriptLaufKommandoTyp extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Ausführung des Kommandos erfolgreich abgeschlossen.
	<p>
	
	</p>
	*/
	public static final AttUdaSkriptLaufKommandoTyp ZUSTAND_0_OK = new AttUdaSkriptLaufKommandoTyp("OK", 		Byte
	.valueOf("0"));

	/**
	der Skriptlauf kann nicht gestartet werden, weil er bereits aktiv ist.
	<p>
	
	</p>
	*/
	public static final AttUdaSkriptLaufKommandoTyp ZUSTAND_1N_SCHONAKTIV = new AttUdaSkriptLaufKommandoTyp("SchonAktiv", 		Byte
	.valueOf("-1"));

	/**
	der Skriptlauf ist nicht aktiv.
	<p>
	
	</p>
	*/
	public static final AttUdaSkriptLaufKommandoTyp ZUSTAND_2N_NICHTAKTIV = new AttUdaSkriptLaufKommandoTyp("NichtAktiv", 		Byte
	.valueOf("-2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUdaSkriptLaufKommandoTyp ZUSTAND_3N_ALLGEMEINERFEHLER = new AttUdaSkriptLaufKommandoTyp("AllgemeinerFehler", 		Byte
	.valueOf("-3"));

	/**
	Skriptlauf starten.
	<p>
	
	</p>
	*/
	public static final AttUdaSkriptLaufKommandoTyp ZUSTAND_1_STARTEN = new AttUdaSkriptLaufKommandoTyp("Starten", 		Byte
	.valueOf("1"));

	/**
	Skriptausführung anhalten.
	<p>
	
	</p>
	*/
	public static final AttUdaSkriptLaufKommandoTyp ZUSTAND_2_ANHALTEN = new AttUdaSkriptLaufKommandoTyp("Anhalten", 		Byte
	.valueOf("2"));

	/**
	Skriptausführung fortsetzen.
	<p>
	
	</p>
	*/
	public static final AttUdaSkriptLaufKommandoTyp ZUSTAND_3_FORTSETZEN = new AttUdaSkriptLaufKommandoTyp("Fortsetzen", 		Byte
	.valueOf("3"));

	/**
	Skriptausführung beenden.
	<p>
	
	</p>
	*/
	public static final AttUdaSkriptLaufKommandoTyp ZUSTAND_4_BEENDEN = new AttUdaSkriptLaufKommandoTyp("Beenden", 		Byte
	.valueOf("4"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttUdaSkriptLaufKommandoTyp getZustand(final 		Byte
	 value) {
		for (AttUdaSkriptLaufKommandoTyp e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttUdaSkriptLaufKommandoTyp getZustand(final String value) {
		for (AttUdaSkriptLaufKommandoTyp e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttUdaSkriptLaufKommandoTyp> getZustaende() {
		List<AttUdaSkriptLaufKommandoTyp> list = new ArrayList<AttUdaSkriptLaufKommandoTyp>();
		list.add(ZUSTAND_0_OK);
		list.add(ZUSTAND_1N_SCHONAKTIV);
		list.add(ZUSTAND_2N_NICHTAKTIV);
		list.add(ZUSTAND_3N_ALLGEMEINERFEHLER);
		list.add(ZUSTAND_1_STARTEN);
		list.add(ZUSTAND_2_ANHALTEN);
		list.add(ZUSTAND_3_FORTSETZEN);
		list.add(ZUSTAND_4_BEENDEN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut UdaSkriptLaufKommandoTyp.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttUdaSkriptLaufKommandoTyp(final 		Byte
	 value) {
		super(value);
	}
	
	private AttUdaSkriptLaufKommandoTyp(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
