/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
beschreibt die konfigurierenden Eigenschaften eines Skripts.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdUdaSkript extends AbstractOnlineDatensatz<OdUdaSkript.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.UdaIst,
					Aspekte.UdaVorgabe,
				};
			}
	
			/**
			 * Aspekt zur Beschreibung einer Vorgabe für Daten eines UdaObjekts.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt UdaIst = new Aspekte("UdaIst", "asp.udaIst");
			
			/**
			 * Aspekt zur Beschreibung einer Vorgabe für Daten eines UdaObjekts.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt UdaVorgabe = new Aspekte("UdaVorgabe", "asp.udaVorgabe");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _name
				= new String
				()
				;
				private String
				 _beschreibung
				= new String
				()
				;
				private 	Zeitstempel
				 _erstelltAm
				;
				private String
				 _erstelltDurch
				= new String
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaHistorie
				> _versionshistorie = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaHistorie
				>(0, true);
				@Defaultwert(wert = "InBearbeitung")
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AttUdaSkriptZustand
				 _zustand
				;
				private Feld<String
				> _quelltext = new Feld<String
				>(0, true);
		
			/**
			Der Name des Skripts.
			<p>
			
			</p>
			
			@return der Wert von Name.
			*/
				public String
				 getName() {
				return _name;
			}
		
			/**
			Der Name des Skripts.
			<p>
			
			</p>
			
			@param _name der neue Wert von Name.
			*/
			public void setName(String
			 _name) {
				if (_name.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._name = _name;
			}
		
			/**
			die erklärende Beschreibung der Funktion des Skripts.
			<p>
			
			</p>
			
			@return der Wert von Beschreibung.
			*/
				public String
				 getBeschreibung() {
				return _beschreibung;
			}
		
			/**
			die erklärende Beschreibung der Funktion des Skripts.
			<p>
			
			</p>
			
			@param _beschreibung der neue Wert von Beschreibung.
			*/
			public void setBeschreibung(String
			 _beschreibung) {
				if (_beschreibung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._beschreibung = _beschreibung;
			}
		
			/**
			der Erstellungszeitpunkt des Skripts.
			<p>
			
			</p>
			
			@return der Wert von ErstelltAm.
			*/
				public 	Zeitstempel
				 getErstelltAm() {
				return _erstelltAm;
			}
		
			/**
			der Erstellungszeitpunkt des Skripts.
			<p>
			
			</p>
			
			@param _erstelltAm der neue Wert von ErstelltAm.
			*/
			public void setErstelltAm(	Zeitstempel
			 _erstelltAm) {
				this._erstelltAm = _erstelltAm;
			}
		
			/**
			Der Name des Nutzers, der das Skript erstellt hat.
			<p>
			
			</p>
			
			@return der Wert von ErstelltDurch.
			*/
				public String
				 getErstelltDurch() {
				return _erstelltDurch;
			}
		
			/**
			Der Name des Nutzers, der das Skript erstellt hat.
			<p>
			
			</p>
			
			@param _erstelltDurch der neue Wert von ErstelltDurch.
			*/
			public void setErstelltDurch(String
			 _erstelltDurch) {
				if (_erstelltDurch.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._erstelltDurch = _erstelltDurch;
			}
		
			/**
			eine Liste mit Einträgen zur Historie des Skripts.
			<p>
			
			</p>
			
			@return der Wert von Versionshistorie.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaHistorie
				> getVersionshistorie() {
				return _versionshistorie;
			}
		
		
			/**
			der aktuelle Bearbeitungszustand des Skripts.
			<p>
			
			</p>
			
			@return der Wert von Zustand.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AttUdaSkriptZustand
				 getZustand() {
				return _zustand;
			}
		
			/**
			der aktuelle Bearbeitungszustand des Skripts.
			<p>
			
			</p>
			
			@param _zustand der neue Wert von Zustand.
			*/
			public void setZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AttUdaSkriptZustand
			 _zustand) {
				this._zustand = _zustand;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Quelltext.
			*/
				public Feld<String
				> getQuelltext() {
				return _quelltext;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getName() != null) {
						datum.getTextValue("Name").setText(getName());
					}
					// ZeichenkettenAttributTyp
					if (getBeschreibung() != null) {
						datum.getTextValue("Beschreibung").setText(getBeschreibung());
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("ErstelltAm").setMillis(getErstelltAm().getTime());
					// ZeichenkettenAttributTyp
					if (getErstelltDurch() != null) {
						datum.getTextValue("ErstelltDurch").setText(getErstelltDurch());
					}
					// AttributListenDefinition
						final Data.Array arrayVersionshistorie = datum.getArray("Versionshistorie");
						arrayVersionshistorie.setLength(getVersionshistorie().size());
						for (int i = 0; i < arrayVersionshistorie.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaHistorie
							 atl = getVersionshistorie().get(i);
							atl.bean2Atl(arrayVersionshistorie.getItem(i), factory);
		
						}
					// GanzzahlAttributTyp
					if (getZustand() != null) {
		                if (getZustand().isZustand()) {
		                    datum.getUnscaledValue("Zustand").setText(getZustand().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Zustand").set(getZustand().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getQuelltext() != null) {
						final Data.TextArray arrayQuelltext = datum.getTextArray("Quelltext");
						arrayQuelltext.setLength(getQuelltext().size());
						for (int i = 0; i < arrayQuelltext.getLength(); ++i) {
							arrayQuelltext.getTextValue(i).setText(getQuelltext().get(i));
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setName(daten.getTextValue("Name").getText());
					// ZeichenkettenAttributTyp
						setBeschreibung(daten.getTextValue("Beschreibung").getText());
					// ZeitstempelAttributTyp
						setErstelltAm(new
							Zeitstempel
							(daten.getTimeValue("ErstelltAm").getMillis()));
					// ZeichenkettenAttributTyp
						setErstelltDurch(daten.getTextValue("ErstelltDurch").getText());
					// AttributListenDefinition
						final Data.Array arrayVersionshistorie = daten.getArray("Versionshistorie");
						for (int i = 0; i < arrayVersionshistorie.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaHistorie
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaHistorie
							 ();
							atl.atl2Bean(arrayVersionshistorie.getItem(i), factory);
							getVersionshistorie().add(atl);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Zustand").isState()) {
								setZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AttUdaSkriptZustand
								.getZustand(daten.getScaledValue("Zustand").getText()));
							} else {
							setZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AttUdaSkriptZustand
							(daten.
								getUnscaledValue
							("Zustand").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayQuelltext = daten.getTextArray("Quelltext");
						for (int i = 0; i < arrayQuelltext.getLength(); ++i) {
							getQuelltext().add(arrayQuelltext.getText(i));
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setName(getName());
							klon.setBeschreibung(getBeschreibung());
							klon.setErstelltAm(getErstelltAm());
							klon.setErstelltDurch(getErstelltDurch());
						klon._versionshistorie = getVersionshistorie().clone();
							klon.setZustand(getZustand());
						klon._quelltext = getQuelltext().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.udaSkript";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdUdaSkript(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
