/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
die konfigurierenden Eigenschaften eines Skriptlaufs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdUdaSkriptLauf extends AbstractOnlineDatensatz<OdUdaSkriptLauf.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.UdaIst,
					Aspekte.UdaVorgabe,
				};
			}
	
			/**
			 * Aspekt zur Beschreibung einer Vorgabe für Daten eines UdaObjekts.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt UdaIst = new Aspekte("UdaIst", "asp.udaIst");
			
			/**
			 * Aspekt zur Beschreibung einer Vorgabe für Daten eines UdaObjekts.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt UdaVorgabe = new Aspekte("UdaVorgabe", "asp.udaVorgabe");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _name
				= new String
				()
				;
				private String
				 _beschreibung
				= new String
				()
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.objekte.UdaSkript
				 _skript
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaSkriptParameter
				> _parameter = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaSkriptParameter
				>(0, true);
				private String
				 _benutzer
				= new String
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				> _passwort = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AttUdaStartTyp
				 _starttyp
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaZyklus
				 _startzyklus
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaZyklus
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaProtokoll
				> _protokoll = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaProtokoll
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaHistorie
				> _versionshistorie = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaHistorie
				>(0, true);
		
			/**
			der Name des Skriptlaufs.
			<p>
			
			</p>
			
			@return der Wert von Name.
			*/
				public String
				 getName() {
				return _name;
			}
		
			/**
			der Name des Skriptlaufs.
			<p>
			
			</p>
			
			@param _name der neue Wert von Name.
			*/
			public void setName(String
			 _name) {
				if (_name.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._name = _name;
			}
		
			/**
			die Beschreibung des Skriptlaufs.
			<p>
			
			</p>
			
			@return der Wert von Beschreibung.
			*/
				public String
				 getBeschreibung() {
				return _beschreibung;
			}
		
			/**
			die Beschreibung des Skriptlaufs.
			<p>
			
			</p>
			
			@param _beschreibung der neue Wert von Beschreibung.
			*/
			public void setBeschreibung(String
			 _beschreibung) {
				if (_beschreibung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._beschreibung = _beschreibung;
			}
		
			/**
			das Skript, das ausgeführt werden soll.
			<p>
			
			</p>
			
			@return der Wert von Skript.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.objekte.UdaSkript
				 getSkript() {
				return _skript;
			}
		
			/**
			das Skript, das ausgeführt werden soll.
			<p>
			
			</p>
			
			@param _skript der neue Wert von Skript.
			*/
			public void setSkript(	de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.objekte.UdaSkript
			 _skript) {
				this._skript = _skript;
			}
		
			/**
			die Parameter, die beim Start an des Skript übergeben werden sollen.
			<p>
			
			</p>
			
			@return der Wert von Parameter.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaSkriptParameter
				> getParameter() {
				return _parameter;
			}
		
		
			/**
			der Name des Benutzers mit dessen Anmeldung das Skript ausgeführt werden soll.
			<p>
			
			</p>
			
			@return der Wert von Benutzer.
			*/
				public String
				 getBenutzer() {
				return _benutzer;
			}
		
			/**
			der Name des Benutzers mit dessen Anmeldung das Skript ausgeführt werden soll.
			<p>
			
			</p>
			
			@param _benutzer der neue Wert von Benutzer.
			*/
			public void setBenutzer(String
			 _benutzer) {
				if (_benutzer.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._benutzer = _benutzer;
			}
		
			/**
			der Name des Benutzers mit dessen Anmeldung das Skript ausgeführt werden soll.
			<p>
			
			</p>
			
			@return der Wert von Passwort.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				> getPasswort() {
				return _passwort;
			}
		
		
			/**
			die Art der Ausführung (des Starts) des Skripts.
			<p>
			
			</p>
			
			@return der Wert von Starttyp.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AttUdaStartTyp
				 getStarttyp() {
				return _starttyp;
			}
		
			/**
			die Art der Ausführung (des Starts) des Skripts.
			<p>
			
			</p>
			
			@param _starttyp der neue Wert von Starttyp.
			*/
			public void setStarttyp(de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AttUdaStartTyp
			 _starttyp) {
				this._starttyp = _starttyp;
			}
		
			/**
			die Beschreibung des Ausführungszyklus.
			<p>
			
			</p>
			
			@return der Wert von Startzyklus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaZyklus
				 getStartzyklus() {
				return _startzyklus;
			}
		
			/**
			die Beschreibung des Ausführungszyklus.
			<p>
			
			</p>
			
			@param _startzyklus der neue Wert von Startzyklus.
			*/
			public void setStartzyklus(de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaZyklus
			 _startzyklus) {
				this._startzyklus = _startzyklus;
			}
		
			/**
			die Beschreibung des Protokolls für die Ausführung eines Skriptlaufs.
			<p>
			
			</p>
			
			@return der Wert von Protokoll.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaProtokoll
				> getProtokoll() {
				return _protokoll;
			}
		
		
			/**
			eine Liste mit Einträgen zur Historie des Skriptlaufs.
			<p>
			
			</p>
			
			@return der Wert von Versionshistorie.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaHistorie
				> getVersionshistorie() {
				return _versionshistorie;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getName() != null) {
						datum.getTextValue("Name").setText(getName());
					}
					// ZeichenkettenAttributTyp
					if (getBeschreibung() != null) {
						datum.getTextValue("Beschreibung").setText(getBeschreibung());
					}
					// ObjektReferenzAttributTyp
						final Object soSkript = getSkript();
						final SystemObject tmpSkript;
							if (soSkript instanceof SystemObject) {
								tmpSkript = (SystemObject)soSkript;
							} else if(soSkript instanceof SystemObjekt){
								tmpSkript = ((SystemObjekt)soSkript).getSystemObject();
							} else{
								tmpSkript = null;
							}
						datum.getReferenceValue("Skript").setSystemObject(tmpSkript);
					// AttributListenDefinition
						final Data.Array arrayParameter = datum.getArray("Parameter");
						arrayParameter.setLength(getParameter().size());
						for (int i = 0; i < arrayParameter.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaSkriptParameter
							 atl = getParameter().get(i);
							atl.bean2Atl(arrayParameter.getItem(i), factory);
		
						}
					// ZeichenkettenAttributTyp
					if (getBenutzer() != null) {
						datum.getTextValue("Benutzer").setText(getBenutzer());
					}
					// GanzzahlAttributTyp
					if (getPasswort() != null) {
						final Data.NumberArray arrayPasswort = datum.
							getUnscaledArray
							("Passwort");
						arrayPasswort.setLength(getPasswort().size());
						for (int i = 0; i < arrayPasswort.getLength(); ++i) {
							arrayPasswort.getValue(i).set(getPasswort().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getStarttyp() != null) {
		                if (getStarttyp().isZustand()) {
		                    datum.getUnscaledValue("Starttyp").setText(getStarttyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Starttyp").set(getStarttyp().getValue());
		                }
					}
					// AttributListenDefinition
						getStartzyklus().bean2Atl(datum.getItem("Startzyklus"), factory);
					// AttributListenDefinition
						final Data.Array arrayProtokoll = datum.getArray("Protokoll");
						arrayProtokoll.setLength(getProtokoll().size());
						for (int i = 0; i < arrayProtokoll.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaProtokoll
							 atl = getProtokoll().get(i);
							atl.bean2Atl(arrayProtokoll.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayVersionshistorie = datum.getArray("Versionshistorie");
						arrayVersionshistorie.setLength(getVersionshistorie().size());
						for (int i = 0; i < arrayVersionshistorie.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaHistorie
							 atl = getVersionshistorie().get(i);
							atl.bean2Atl(arrayVersionshistorie.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setName(daten.getTextValue("Name").getText());
					// ZeichenkettenAttributTyp
						setBeschreibung(daten.getTextValue("Beschreibung").getText());
					// ObjektReferenzAttributTyp
						final long idSkript = daten.getReferenceValue("Skript").getId();
						final SystemObjekt tmpSkript;
						if (idSkript == 0) {
							tmpSkript = null;
						} else {
							final SystemObject soSkript = factory.getDav().getDataModel().getObject(idSkript);
							if (soSkript == null) {
									tmpSkript = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.objekte.impl.UdaSkriptUngueltig(idSkript);
							} else {
								tmpSkript = factory.getModellobjekt(soSkript);
							}
						}
						setSkript((	de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.objekte.UdaSkript
						) tmpSkript);
					// AttributListenDefinition
						final Data.Array arrayParameter = daten.getArray("Parameter");
						for (int i = 0; i < arrayParameter.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaSkriptParameter
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaSkriptParameter
							 ();
							atl.atl2Bean(arrayParameter.getItem(i), factory);
							getParameter().add(atl);
						}
					// ZeichenkettenAttributTyp
						setBenutzer(daten.getTextValue("Benutzer").getText());
					// GanzzahlAttributTyp
						final Data.NumberArray arrayPasswort = daten.
							getUnscaledArray
						("Passwort");
		
						for (int i = 0; i < arrayPasswort.getLength(); ++i) {
		                    getPasswort().add(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
		                    (arrayPasswort.
		                    		byteValue
		                    (i)));
		                }
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Starttyp").isState()) {
								setStarttyp(de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AttUdaStartTyp
								.getZustand(daten.getScaledValue("Starttyp").getText()));
							} else {
							setStarttyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AttUdaStartTyp
							(daten.
								getUnscaledValue
							("Starttyp").
									byteValue
							()));
							}
					// AttributListenDefinition
						getStartzyklus().atl2Bean(daten.getItem("Startzyklus"), factory);
					// AttributListenDefinition
						final Data.Array arrayProtokoll = daten.getArray("Protokoll");
						for (int i = 0; i < arrayProtokoll.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaProtokoll
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaProtokoll
							 ();
							atl.atl2Bean(arrayProtokoll.getItem(i), factory);
							getProtokoll().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayVersionshistorie = daten.getArray("Versionshistorie");
						for (int i = 0; i < arrayVersionshistorie.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaHistorie
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AtlUdaHistorie
							 ();
							atl.atl2Bean(arrayVersionshistorie.getItem(i), factory);
							getVersionshistorie().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setName(getName());
							klon.setBeschreibung(getBeschreibung());
							klon.setSkript(getSkript());
						klon._parameter = getParameter().clone();
							klon.setBenutzer(getBenutzer());
						klon._passwort = getPasswort().clone();
							klon.setStarttyp(getStarttyp());
							klon._startzyklus = getStartzyklus().clone();
						klon._protokoll = getProtokoll().clone();
						klon._versionshistorie = getVersionshistorie().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.udaSkriptLauf";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdUdaSkriptLauf(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
