/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Kommando.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdUdaSkriptLaufKommando extends AbstractOnlineDatensatz<OdUdaSkriptLaufKommando.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.UdaAnforderung,
					Aspekte.UdaAntwort,
				};
			}
	
			/**
			 * Aspekt zur Beschreibung eines Anforderung an die "Umfassende Datenanalyse".	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt UdaAnforderung = new Aspekte("UdaAnforderung", "asp.udaAnforderung");
			
			/**
			 * Aspekt zur Beschreibung einer Antwort auf eine Anforderung an die "Umfassende
						Datenanalyse".	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt UdaAntwort = new Aspekte("UdaAntwort", "asp.udaAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _anwendung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _id
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AttUdaSkriptLaufKommandoTyp
				 _kommando
				;
				private Feld<String
				> _meldung = new Feld<String
				>(0, true);
		
			/**
			die ID zur Identifikation der anfragenden Anwendung.
			<p>
			
			</p>
			
			@return der Wert von Anwendung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getAnwendung() {
				return _anwendung;
			}
		
			/**
			die ID zur Identifikation der anfragenden Anwendung.
			<p>
			
			</p>
			
			@param _anwendung der neue Wert von Anwendung.
			*/
			public void setAnwendung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _anwendung) {
				this._anwendung = _anwendung;
			}
		
			/**
			die ID zur Identifikation der Antwort.
			<p>
			
			</p>
			
			@return der Wert von Id.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getId() {
				return _id;
			}
		
			/**
			die ID zur Identifikation der Antwort.
			<p>
			
			</p>
			
			@param _id der neue Wert von Id.
			*/
			public void setId(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _id) {
				this._id = _id;
			}
		
			/**
			das auszuführende Kommando.
			<p>
			
			</p>
			
			@return der Wert von Kommando.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AttUdaSkriptLaufKommandoTyp
				 getKommando() {
				return _kommando;
			}
		
			/**
			das auszuführende Kommando.
			<p>
			
			</p>
			
			@param _kommando der neue Wert von Kommando.
			*/
			public void setKommando(de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AttUdaSkriptLaufKommandoTyp
			 _kommando) {
				this._kommando = _kommando;
			}
		
			/**
			eine mit dem Kommando versendete Nachricht.
			<p>
			
			</p>
			
			@return der Wert von Meldung.
			*/
				public Feld<String
				> getMeldung() {
				return _meldung;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getAnwendung() != null) {
		                if (getAnwendung().isZustand()) {
		                    datum.getUnscaledValue("Anwendung").setText(getAnwendung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Anwendung").set(getAnwendung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getId() != null) {
		                if (getId().isZustand()) {
		                    datum.getUnscaledValue("Id").setText(getId().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Id").set(getId().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKommando() != null) {
		                if (getKommando().isZustand()) {
		                    datum.getUnscaledValue("Kommando").setText(getKommando().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Kommando").set(getKommando().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getMeldung() != null) {
						final Data.TextArray arrayMeldung = datum.getTextArray("Meldung");
						arrayMeldung.setLength(getMeldung().size());
						for (int i = 0; i < arrayMeldung.getLength(); ++i) {
							arrayMeldung.getTextValue(i).setText(getMeldung().get(i));
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							setAnwendung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("Anwendung").
									longValue
							()));
					// GanzzahlAttributTyp
							setId(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("Id").
									longValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Kommando").isState()) {
								setKommando(de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AttUdaSkriptLaufKommandoTyp
								.getZustand(daten.getScaledValue("Kommando").getText()));
							} else {
							setKommando(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewudaglobal.attribute.AttUdaSkriptLaufKommandoTyp
							(daten.
								getUnscaledValue
							("Kommando").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayMeldung = daten.getTextArray("Meldung");
						for (int i = 0; i < arrayMeldung.getLength(); ++i) {
							getMeldung().add(arrayMeldung.getText(i));
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAnwendung(getAnwendung());
							klon.setId(getId());
							klon.setKommando(getKommando());
						klon._meldung = getMeldung().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.udaSkriptLaufKommando";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdUdaSkriptLaufKommando(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
