/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.util;

import de.bsvrz.dav.daf.main.config.ClientApplication;
import de.bsvrz.dav.daf.main.config.ConfigurationAuthority;
import de.bsvrz.dav.daf.main.config.DavApplication;
import de.bsvrz.dav.daf.main.config.DynamicObject;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.att.Feld;
import de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword;
import de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.objekte.AutarkeOrganisationsEinheit;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler;
import de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser;

/**
 * Allgemeine Hilfsmethoden zum BitCtrl-Modell.
 *
 * <p>
 * Folgende Funktionen werden unterstützt:
 * <ul>
 * <li>Konvertieren zwischen <code>AttJaNein</code> und
 * <code>boolean</code></li>
 * <li>Konvertieren zwischen Byte-Feld und <code>byte[]</code></li>
 * </ul>
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public final class ModellUtil {

	public static boolean getBoolean(final AttJaNein att) {
		return AttJaNein.ZUSTAND_1_JA.equals(att);
	}

	public static AttJaNein getJaNein(final boolean flag) {
		if (flag) {
			return AttJaNein.ZUSTAND_1_JA;
		}
		return AttJaNein.ZUSTAND_0_NEIN;
	}

	public static byte[] getByteArray(final Feld<AttByte_JavaKeyword> feld) {
		final byte[] result = new byte[feld.size()];
		for (int i = 0; i < result.length; i++) {
			result[i] = feld.get(i).getValue();
		}
		return result;
	}

	public static void fillByteFeld(final Feld<AttByte_JavaKeyword> feld, final byte[] data) {
		feld.clear();
		for (final byte element : data) {
			feld.add(new AttByte_JavaKeyword(element));
		}
	}

	public static Benutzer getLokalenBenutzer(final ObjektFactory objektFactory) {
		final DynamicObject localUser = objektFactory.getDav().getLocalUser();
		return (Benutzer) objektFactory.getModellobjekt(localUser);
	}

	public static Datenverteiler getLokalenDatenverteiler(final ObjektFactory objektFactory) {
		final DavApplication localDav = objektFactory.getDav().getLocalDav();
		return (Datenverteiler) objektFactory.getModellobjekt(localDav);
	}

	public static Applikation getLokaleApplikation(final ObjektFactory objektFactory) {
		final ClientApplication localApplication = objektFactory.getDav().getLocalApplicationObject();
		return (Applikation) objektFactory.getModellobjekt(localApplication);
	}

	public static AutarkeOrganisationsEinheit getAutarkeOrganisationsEinheit(final ObjektFactory objektFactory) {
		final ConfigurationAuthority aoe = objektFactory.getDav().getLocalConfigurationAuthority();
		return (AutarkeOrganisationsEinheit) objektFactory.getModellobjekt(aoe);
	}

	/**
	 * Erzeugt eine Urlasserinformation mit dem aktuellen Datenverteilerbenutzer als
	 * Urlasser.
	 *
	 * @param veranlasser   der Name des Veranlassers
	 * @param ursache       der text für die Beschreibung fer Ursache der Aktion
	 * @param objektFactory die verwendete ObjektFaktory zum erzeugen des Objekts
	 *
	 * @return die generierte Urlasserinformation
	 */
	public static AtlUrlasser getUrlasserInformation(final String veranlasser, final String ursache,
			final ObjektFactory objektFactory) {
		final AtlUrlasser urlasser = new AtlUrlasser();
		urlasser.setBenutzerReferenz(getLokalenBenutzer(objektFactory));
		urlasser.setVeranlasser(veranlasser);
		urlasser.setUrsache(ursache);
		return urlasser;
	}

	private ModellUtil() {
		// utility class
	}

}
