/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util;

import java.util.Date;

/**
 * Interface, welches von Klassen implementiert werden kann, die über einen
 * Definition eines Zeitbereiches verfügen.
 * 
 * @author BitCtrl Systems GmbH, Andreas Meissner
 * @version $Id: UebernehmeSystemKalenderZeitbereichAction.java 23342 2010-05-27
 *          09:03:26Z peuker $
 */
public interface ObjektMitZeitBereich {

	/**
	 * Setzt den Startzeitpunkt des Zeitbereiches.
	 * 
	 * @param startZeit der neue Startzeitpunkt des Zeitbereiches
	 */
	void setStartZeit(Date startZeit);

	/**
	 * Setzt den Endzeitpunkt des Zeitbereiches.
	 * 
	 * @param endZeit der neue Endzeitpunkt des Zeitbereiches
	 */
	void setEndZeit(Date endZeit);
}
