/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.util.bmvew;

import com.bitctrl.commands.Command;

import de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.onlinedaten.OdBetriebsMeldung;

/**
 * Beschreibt einen Befehl beim Eintreffen bestimmter Betriebsmeldungen
 * ausgeführt werden soll.
 * 
 * @author BitCtrl Systems GmbH, Schumann
 */
public interface BetriebsmeldungCommand extends Command {

	/**
	 * Prüft ob eine bestimmte Betriebsmeldung diesen Befehl auslöst.
	 * 
	 * @param meldung eine Betriebsmeldung.
	 * @return {@code true}, wenn der Befehl ausgeführt werden soll.
	 */
	boolean isTrigger(OdBetriebsMeldung.Daten meldung);

}
