/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util.cache;

import com.bitctrl.util.monitor.IMonitor;

import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;

/**
 * Cached zu einer PID das entsprechende Modell-Objekt.
 * 
 * @author BitCtrl Systems GmbH, schnepel
 * @version $Id$
 */
public class ModellObjektCache extends AbstractCache {

	private Object threadSync;

	private SystemObjekt modellObjekt;

	private AbstractDavVerbindungsCache verbindungsCache;

	public ModellObjektCache(final String pid, final AbstractDavVerbindungsCache verbindungsCache) {
		super(pid, verbindungsCache);
	}

	protected void preInit(final AbstractDavVerbindungsCache verbindungsCache) {
		threadSync = new Object();
		this.verbindungsCache = verbindungsCache;
	}

	@Override
	protected boolean doInit(final IMonitor monitor) {
		modellObjekt = verbindungsCache.getObjektFactory().getModellobjekt(getName());
		return null != modellObjekt;
	}

	@Override
	protected void callDoInit(final IMonitor monitor) {
		synchronized (threadSync) {
			final Thread thread = new Thread() {
				@Override
				public void run() {
					synchronized (threadSync) {
						ModellObjektCache.super.callDoInit(monitor);
					}
				}
			};
			thread.setDaemon(true);
			thread.start();
		}
	}

	public SystemObjekt getModellObjekt() {
		ensureInit();
		if (null == modellObjekt) {
			throw new IllegalStateException(
					"Der ModellObjektCache(" + getName() + ") wurde nicht korrekt initialisiert.");
		}
		return modellObjekt;
	}
}
