/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util.geolib;

import java.util.ArrayList;
import java.util.List;

import de.bsvrz.sys.funclib.bitctrl.geolib.UTMKoordinate;
import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Polygon;
import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Punkt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Linie;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Punkt;

/**
 * Macht die geolib aus funclib.bitctrl für die Modell-Objekte nutzbar. Diese
 * Klasse arbeitet nur mit den UTM-Koordinaten.
 * 
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @see WGS84Util
 */
public final class UTMUtil {

	/**
	 * Bestimmt die UTM-Koordinaten eines Punkts. Erweitert ein Objekt sowohl
	 * <code>PunktXY</code> als auch <code>PunktLiegtAufLinienObjekt</code>, wird
	 * zuerst versucht die Koordinaten über <code>PunktLiegtAufLinienObjekt</code>
	 * zu bestimmen, ist das nicht möglich, wird versucht sie über
	 * <code>PunktXY</code> zu bestimmen.
	 * 
	 * @param punkt der Punkt, dessen Koordinaten gesucht sind.
	 * @return die Koordinaten des Punkts.
	 */
	public static UTMKoordinate konvertiere(final Punkt punkt) {
		return WGS84Util.konvertiereIntern(punkt).toUTMKoordinate();
	}

	/**
	 * Bestimmt die Liste der Koordinaten für eine Linie.
	 * 
	 * @param linie die Linie, deren Koordinaten gesucht sind.
	 * @return die Liste der Koordinaten der Linie.
	 */
	public static List<UTMKoordinate> konvertiere(final Linie linie) {
		final WGS84Polygon wgs84 = WGS84Util.konvertiereIntern(linie);
		final List<UTMKoordinate> result = new ArrayList<>();
		for (final WGS84Punkt p : wgs84.getKoordinaten()) {
			result.add(p.toUTMKoordinate());
		}
		return result;
	}

	private UTMUtil() {
		// utility class
	}

}
