/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.util.kalender;

import java.util.HashSet;
import java.util.Set;

import com.bitctrl.util.Interval;

import de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AttEreignisTypenOption;
import de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.NetzBestandTeil;

/**
 * Repr&auml;sentiert eine Anfrage an den Ereigniskalender.
 *
 * @author BitCtrl Systems GmbH, Schumann
 */
public class KalenderAnfrage {

	/**
	 * Menge von Ereignistypen, die entsprechend der gesetzten Auswahloption
	 * ber&uuml;cksichtigt werden.
	 *
	 * @see #ereignisTypenOption
	 */
	private final Set<EreignisTyp> ereignisTypen = new HashSet<>();

	/** Menge der Netzbestandteile, dessen Ereignisse angefragt werden. */
	private final Set<NetzBestandTeil> raeumlicheGueltigkeit = new HashSet<>();

	/** Das Zeitintervall, indem Ereignisse angefragt werden. */
	private Interval intervall;

	/**
	 * Auswahloption f&uuml;r die Liste der Ereignistypen. Standard ist
	 * {@link AttEreignisTypenOption#ZUSTAND_0_ALLE}.
	 *
	 * @see #ereignisTypen
	 */
	private AttEreignisTypenOption ereignisTypenOption = AttEreignisTypenOption.ZUSTAND_0_ALLE;

	/**
	 * Gibt den Wert der Eigenschaft {@code ereignisTypen} wieder.
	 *
	 * @return {@code ereignisTypen}.
	 */
	public Set<EreignisTyp> getEreignisTypen() {
		return ereignisTypen;
	}

	/**
	 * Gibt den Wert der Eigenschaft {@code ereignisTypenOption} wieder.
	 *
	 * @return {@code ereignisTypenOption}.
	 */
	public AttEreignisTypenOption getEreignisTypenOption() {
		return ereignisTypenOption;
	}

	/**
	 * Gibt den Wert der Eigenschaft {@code intervall} wieder.
	 *
	 * @return {@code intervall}.
	 */
	public Interval getIntervall() {
		return intervall;
	}

	/**
	 * Gibt den Wert der Eigenschaft {@code raeumlicheGueltigkeit} wieder.
	 *
	 * @return {@code raeumlicheGueltigkeit}.
	 */
	public Set<NetzBestandTeil> getRaeumlicheGueltigkeit() {
		return raeumlicheGueltigkeit;
	}

	/**
	 * Legt den Wert der Eigenschaft {@code ereignisTypenOption} fest.
	 *
	 * @param ereignisTypenOption der neue Wert von {@code ereignisTypenOption}.
	 */
	public void setEreignisTypenOption(final AttEreignisTypenOption ereignisTypenOption) {
		this.ereignisTypenOption = ereignisTypenOption;
	}

	/**
	 * Legt den Wert der Eigenschaft {@code intervall} fest.
	 *
	 * @param intervall der neue Wert von {@code intervall}.
	 */
	public void setIntervall(final Interval intervall) {
		this.intervall = intervall;
	}

	/**
	 * {@inheritDoc}
	 *
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder s = new StringBuilder(getClass().getSimpleName()).append("[");

		s.append("intervall=").append(intervall);
		s.append(", ereignisTypenOption=").append(ereignisTypenOption);
		s.append(", ereignisTypen=").append(ereignisTypen);
		s.append(", raeumlicheGueltigkeit=").append(raeumlicheGueltigkeit);

		return s.append("]").toString();
	}

}
