/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.util.kalender;

import java.util.EventObject;

import de.bsvrz.sys.funclib.bitctrl.modell.att.Feld;
import de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein;
import de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AtlEreignisInformation;
import de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.onlinedaten.OdEreignisKalenderAntwort;

/**
 * Das Event wird vom Ereigniskalender ausgel&ouml;st.
 *
 * @author BitCtrl Systems GmbH, Gieseler
 */
public class KalenderEvent extends EventObject {

	/** Die Eigenschaft {@code serialVersionUID}. */
	private static final long serialVersionUID = 1L;

	/** Kapselt die Daten des Events. */
	private final OdEreignisKalenderAntwort.Daten datum;

	/**
	 * Konstruiert das Event.
	 *
	 * @param source die Quelle des Events.
	 * @param daten  das Zeichen des Absenders.
	 */
	public KalenderEvent(final Object source, final OdEreignisKalenderAntwort.Daten daten) {
		super(source);

		datum = daten.clone();
	}

	/**
	 * Gibt den Wert der Eigenschaft {@code absenderZeichen} wieder.
	 *
	 * @return {@code absenderZeichen}.
	 */
	public String getAbsenderZeichen() {
		return datum.getAbsenderZeichen();
	}

	/**
	 * Gibt den Kalender zur�ck, der das Event ausgel�st hat.
	 *
	 * @return der Kalender.
	 */
	public Ereigniskalender getKalender() {
		return (Ereigniskalender) source;
	}

	/**
	 * Gibt den Wert der Eigenschaft {@code zustandswechsel} wieder.
	 *
	 * @return {@code zustandswechsel}.
	 */
	public Feld<AtlEreignisInformation> getZustandswechsel() {
		return datum.getEreignis();
	}

	/**
	 * Flag, ob es sich um die erste Antwort handelt oder ob es sich um eine
	 * Aktualisierung handelt.
	 *
	 * @return {@code true}, wenn das Event eine Aktualisierung darstellt.
	 */
	public boolean isAenderung() {
		return datum.getAenderung().equals(AttJaNein.ZUSTAND_1_JA);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		String s = getClass().getName() + "[";

		s = "absenderZeichen=" + datum.getAbsenderZeichen();

		return s + "]";
	}

}
