/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util.rdstmc;

import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisKodierung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationFormat;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationTabelle;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationTabelleTyp;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsNachrichtenSprache;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttZahl0Bis65535;

/**
 * Klasse mit diversen Konstanten für die RDS-Meldungseingabe.
 * 
 * @author BitCtrl Systems GmbH, Andreas Meissner
 */
public final class Konstanten {

	/**
	 * Privater Kontruktor.
	 */
	private Konstanten() {
		// nur zur Beruhigung von CheckStyle
	}

	/** Maximal erlaubte Anzahl von Nachfolger TMC-Lokationen. */
	public static final int MAXIMALE_ANZAHL_NACHFOLGER_LOKATIONEN = 31;

	/** Der Standardwert für das RDS-Location-Format ("TMC Location"). */
	public static final AttRdsLocationFormat RDS_LOCATION_FORMAT = AttRdsLocationFormat.ZUSTAND_0_TMC_LOCATION;

	/**
	 * Der Standardwert für die RDS-Ereignis-Kodierung ("prEN ISO 14819-2
	 * (Alert-C)").
	 */
	public static final AttRdsEreignisKodierung RDS_EREIGNIS_KODIERUNG = AttRdsEreignisKodierung.ZUSTAND_0_PREN_ISO_14819_2_ALERT_C_;

	/** Der Standardwert für die RDS-Ereignistabellen-Nummer (1). */
	public static final AttZahl0Bis65535 RDS_EREIGNIS_TABELLE_NUMMER = new AttZahl0Bis65535(1);

	/** Der Standardwert für die RDS-Ereignistabellen-Version ("4.00"). */
	public static final String RDS_EREIGNIS_TABELLE_VERSION = "4.00";

	/** Der Standardwert für das RDS-Format (0). */
	public static final AttZahl0Bis65535 RDS_FORMAT = new AttZahl0Bis65535(0);

	/** Der Standardwert für die RDS-Nachrichtensprache ("deutsch (Standard)"). */
	public static final AttRdsNachrichtenSprache RDS_NACHRICHTEN_SPRACHE = AttRdsNachrichtenSprache.ZUSTAND_1031_DEUTSCH_STANDARD_;

	/** Der Standardwert für die RDS-Landeskennung ("rdsLandesKennung.DE"). */
	public static final String RDS_LANDESKENNUNG_PID = "rdsLandesKennung.DE";

	/**
	 * Der Standardwert für die RDS-Locationtabelle ("Deutschland(1), Tabelle 01").
	 */
	public static final AttRdsLocationTabelle RDS_LOCATION_TABELLE = AttRdsLocationTabelle.ZUSTAND_1001_DEUTSCHLAND_1_TABELLE_01;

	/**
	 * Der Standardwert für den RDS-Locationtabelle-Typ ("TMC Location Tabelle").
	 */
	public static final AttRdsLocationTabelleTyp RDS_LOCATION_TABELLE_TYP = AttRdsLocationTabelleTyp.ZUSTAND_0_TMC_LOCATION_TABELLE;

	/** Der Standardwert für den RDS-Locationtabelle-Name. */
	public static final String RDS_LOCATION_TABELLE_NAME = "";

	/** Der Standardwert für die RDS-Locationtabelle-Version. */
	public static final String RDS_LOCATION_TABELLE_VERSION = "";
}
